/**
 * @module ol/source/wms
 */
/**
 * Default WMS version.
 * @type {string}
 */
export const DEFAULT_VERSION: string;
/**
 * Set the server type to use implementation-specific parameters beyond the WMS specification.
 * - `'carmentaserver'`: HiDPI support for [Carmenta Server](https://www.carmenta.com/en/products/carmenta-server)
 * - `'geoserver'`: HiDPI support for [GeoServer](https://geoserver.org/)
 * - `'mapserver'`: HiDPI support for [MapServer](https://mapserver.org/)
 * - `'qgis'`: HiDPI support for [QGIS](https://qgis.org/)
 */
export type ServerType = 'carmentaserver' | 'geoserver' | 'mapserver' | 'qgis';
//# sourceMappingURL=wms.d.ts.map