/**
 * A {@link TopologicalOperator} for assigning coordinates to a topological
 * layering.
 *
 * @packageDocumentation
 */
import { CoordOperator } from ".";
/**
 * A {@link CoordOperator} for positioning edges of a topological layout.
 *
 * This operators also minimized a quadratic objective function (similar to
 * {@link QuadOperator}), but is tailored to topological layouts.
 *
 * Create with {@link topological}.
 *
 * <img alt="topological example" src="media://sugi-topological-opt-topological.png" width="1000">
 */
export declare type TopologicalOperator = CoordOperator<unknown, unknown>;
/**
 * Create a new {@link TopologicalOperator}, bundled as {@link coordTopological}.
 */
export declare function topological(...args: never[]): TopologicalOperator;
