import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { Modal } from '../Modal/Modal.js';
import { ConfirmContent } from './ConfirmContent.js';

const ConfirmModal = ({
  isOpen,
  title,
  body,
  description,
  confirmText,
  confirmVariant = "destructive",
  confirmationText,
  dismissText = "Cancel",
  dismissVariant = "secondary",
  alternativeText,
  modalClass,
  icon = "exclamation-triangle",
  onConfirm,
  onDismiss,
  onAlternative,
  confirmButtonVariant = "destructive",
  disabled
}) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx(Modal, { className: cx(styles.modal, modalClass), title, icon, isOpen, onDismiss, children: /* @__PURE__ */ jsx(
    ConfirmContent,
    {
      body,
      description,
      confirmButtonLabel: confirmText,
      dismissButtonLabel: dismissText,
      dismissButtonVariant: dismissVariant,
      confirmPromptText: confirmationText,
      alternativeButtonLabel: alternativeText,
      confirmButtonVariant,
      onConfirm,
      onDismiss,
      onAlternative,
      disabled
    }
  ) });
};
const getStyles = () => ({
  modal: css({
    width: "500px"
  })
});

export { ConfirmModal };
//# sourceMappingURL=ConfirmModal.js.map
