import * as common from '@grafana/schema';
export interface DashboardV2Spec {
    id?: number;
    title: string;
    description?: string;
    cursorSync: DashboardCursorSync;
    liveNow?: boolean;
    preload: boolean;
    editable?: boolean;
    links: DashboardLink[];
    tags: string[];
    timeSettings: TimeSettingsSpec;
    variables: VariableKind[];
    elements: Record<string, PanelKind>;
    annotations: AnnotationQueryKind[];
    layout: GridLayoutKind;
    schemaVersion: number;
    revision?: number;
}
export declare const defaultDashboardV2Spec: () => DashboardV2Spec;
export interface AnnotationPanelFilter {
    exclude?: boolean;
    ids: number[];
}
export declare const defaultAnnotationPanelFilter: () => AnnotationPanelFilter;
export type DashboardCursorSync = "Off" | "Crosshair" | "Tooltip";
export declare const defaultDashboardCursorSync: () => DashboardCursorSync;
export interface DashboardLink {
    title: string;
    type: DashboardLinkType;
    icon: string;
    tooltip: string;
    url?: string;
    tags: string[];
    asDropdown: boolean;
    targetBlank: boolean;
    includeVars: boolean;
    keepTime: boolean;
}
export declare const defaultDashboardLink: () => DashboardLink;
export interface DataSourceRef {
    type?: string;
    uid?: string;
}
export declare const defaultDataSourceRef: () => DataSourceRef;
export interface DataTransformerConfig {
    id: string;
    disabled?: boolean;
    filter?: MatcherConfig;
    topic?: common.DataTopic;
    options: any;
}
export declare const defaultDataTransformerConfig: () => DataTransformerConfig;
export interface DataLink {
    title: string;
    url: string;
    targetBlank?: boolean;
}
export declare const defaultDataLink: () => DataLink;
export interface FieldConfigSource {
    defaults: FieldConfig;
    overrides: {
        matcher: MatcherConfig;
        properties: DynamicConfigValue[];
    }[];
}
export declare const defaultFieldConfigSource: () => FieldConfigSource;
export interface FieldConfig {
    displayName?: string;
    displayNameFromDS?: string;
    description?: string;
    path?: string;
    writeable?: boolean;
    filterable?: boolean;
    unit?: string;
    decimals?: number;
    min?: number;
    max?: number;
    mappings?: ValueMapping[];
    thresholds?: ThresholdsConfig;
    color?: FieldColor;
    links?: any[];
    noValue?: string;
    custom?: Record<string, any>;
}
export declare const defaultFieldConfig: () => FieldConfig;
export interface DynamicConfigValue {
    id: string;
    value?: any;
}
export declare const defaultDynamicConfigValue: () => DynamicConfigValue;
export interface MatcherConfig {
    id: string;
    options?: any;
}
export declare const defaultMatcherConfig: () => MatcherConfig;
export interface Threshold {
    value: number;
    color: string;
}
export declare const defaultThreshold: () => Threshold;
export type ThresholdsMode = "absolute" | "percentage";
export declare const defaultThresholdsMode: () => ThresholdsMode;
export interface ThresholdsConfig {
    mode: ThresholdsMode;
    steps: Threshold[];
}
export declare const defaultThresholdsConfig: () => ThresholdsConfig;
export type ValueMapping = ValueMap | RangeMap | RegexMap | SpecialValueMap;
export declare const defaultValueMapping: () => ValueMapping;
export type MappingType = "value" | "range" | "regex" | "special";
export declare const defaultMappingType: () => MappingType;
export interface ValueMap {
    type: "value";
    options: Record<string, ValueMappingResult>;
}
export declare const defaultValueMap: () => ValueMap;
export interface RangeMap {
    type: "range";
    options: {
        from: number | null;
        to: number | null;
        result: ValueMappingResult;
    };
}
export declare const defaultRangeMap: () => RangeMap;
export interface RegexMap {
    type: "regex";
    options: {
        pattern: string;
        result: ValueMappingResult;
    };
}
export declare const defaultRegexMap: () => RegexMap;
export interface SpecialValueMap {
    type: "special";
    options: {
        match: SpecialValueMatch;
        result: ValueMappingResult;
    };
}
export declare const defaultSpecialValueMap: () => SpecialValueMap;
export type SpecialValueMatch = "true" | "false" | "null" | "nan" | "null+nan" | "empty";
export declare const defaultSpecialValueMatch: () => SpecialValueMatch;
export interface ValueMappingResult {
    text?: string;
    color?: string;
    icon?: string;
    index?: number;
}
export declare const defaultValueMappingResult: () => ValueMappingResult;
export type FieldColorModeId = "thresholds" | "palette-classic" | "palette-classic-by-name" | "continuous-GrYlRd" | "continuous-RdYlGr" | "continuous-BlYlRd" | "continuous-YlRd" | "continuous-BlPu" | "continuous-YlBl" | "continuous-blues" | "continuous-reds" | "continuous-greens" | "continuous-purples" | "fixed" | "shades";
export declare const defaultFieldColorModeId: () => FieldColorModeId;
export type FieldColorSeriesByMode = "min" | "max" | "last";
export declare const defaultFieldColorSeriesByMode: () => FieldColorSeriesByMode;
export interface FieldColor {
    mode: FieldColorModeId;
    fixedColor?: string;
    seriesBy?: FieldColorSeriesByMode;
}
export declare const defaultFieldColor: () => FieldColor;
export type DashboardLinkType = "link" | "dashboards";
export declare const defaultDashboardLinkType: () => DashboardLinkType;
export interface Kind {
    kind: string;
    spec: any;
    metadata?: any;
}
export declare const defaultKind: () => Kind;
export interface VizConfigSpec {
    pluginVersion: string;
    options: Record<string, any>;
    fieldConfig: FieldConfigSource;
}
export declare const defaultVizConfigSpec: () => VizConfigSpec;
export interface VizConfigKind {
    kind: string;
    spec: VizConfigSpec;
}
export declare const defaultVizConfigKind: () => VizConfigKind;
export interface AnnotationQuerySpec {
    datasource?: DataSourceRef;
    query?: DataQueryKind;
    enable: boolean;
    hide: boolean;
    iconColor: string;
    name: string;
    builtIn?: boolean;
    filter?: AnnotationPanelFilter;
}
export declare const defaultAnnotationQuerySpec: () => AnnotationQuerySpec;
export interface AnnotationQueryKind {
    kind: "AnnotationQuery";
    spec: AnnotationQuerySpec;
}
export declare const defaultAnnotationQueryKind: () => AnnotationQueryKind;
export interface QueryOptionsSpec {
    timeFrom?: string;
    maxDataPoints?: number;
    timeShift?: string;
    queryCachingTTL?: number;
    interval?: string;
    cacheTimeout?: string;
    hideTimeOverride?: boolean;
}
export declare const defaultQueryOptionsSpec: () => QueryOptionsSpec;
export interface DataQueryKind {
    kind: string;
    spec: Record<string, any>;
}
export declare const defaultDataQueryKind: () => DataQueryKind;
export interface PanelQuerySpec {
    query: DataQueryKind;
    datasource?: DataSourceRef;
    refId: string;
    hidden: boolean;
}
export declare const defaultPanelQuerySpec: () => PanelQuerySpec;
export interface PanelQueryKind {
    kind: "PanelQuery";
    spec: PanelQuerySpec;
}
export declare const defaultPanelQueryKind: () => PanelQueryKind;
export interface TransformationKind {
    kind: string;
    spec: DataTransformerConfig;
}
export declare const defaultTransformationKind: () => TransformationKind;
export interface QueryGroupSpec {
    queries: PanelQueryKind[];
    transformations: TransformationKind[];
    queryOptions: QueryOptionsSpec;
}
export declare const defaultQueryGroupSpec: () => QueryGroupSpec;
export interface QueryGroupKind {
    kind: "QueryGroup";
    spec: QueryGroupSpec;
}
export declare const defaultQueryGroupKind: () => QueryGroupKind;
export interface TimeSettingsSpec {
    timezone?: string;
    from: string;
    to: string;
    autoRefresh: string;
    autoRefreshIntervals: string[];
    quickRanges: string[];
    hideTimepicker: boolean;
    weekStart: string;
    fiscalYearStartMonth: number;
    nowDelay?: string;
}
export declare const defaultTimeSettingsSpec: () => TimeSettingsSpec;
export declare const RepeatMode = "variable";
export interface RepeatOptions {
    mode: "variable";
    value: string;
    direction?: "h" | "v";
    maxPerRow?: number;
}
export declare const defaultRepeatOptions: () => RepeatOptions;
export interface GridLayoutItemSpec {
    x: number;
    y: number;
    width: number;
    height: number;
    element: ElementReference;
    repeat?: RepeatOptions;
}
export declare const defaultGridLayoutItemSpec: () => GridLayoutItemSpec;
export interface GridLayoutItemKind {
    kind: "GridLayoutItem";
    spec: GridLayoutItemSpec;
}
export declare const defaultGridLayoutItemKind: () => GridLayoutItemKind;
export interface GridLayoutSpec {
    items: GridLayoutItemKind[];
}
export declare const defaultGridLayoutSpec: () => GridLayoutSpec;
export interface GridLayoutKind {
    kind: "GridLayout";
    spec: GridLayoutSpec;
}
export declare const defaultGridLayoutKind: () => GridLayoutKind;
export interface PanelSpec {
    id: number;
    title: string;
    description: string;
    links: DataLink[];
    data: QueryGroupKind;
    vizConfig: VizConfigKind;
    transparent?: boolean;
}
export declare const defaultPanelSpec: () => PanelSpec;
export interface PanelKind {
    kind: "Panel";
    spec: PanelSpec;
}
export declare const defaultPanelKind: () => PanelKind;
export interface ElementReference {
    kind: "ElementReference";
    name: string;
}
export declare const defaultElementReference: () => ElementReference;
export type VariableValue = VariableValueSingle | VariableValueSingle[];
export declare const defaultVariableValue: () => VariableValue;
export type VariableValueSingle = string | boolean | number | CustomVariableValue;
export declare const defaultVariableValueSingle: () => VariableValueSingle;
export interface CustomFormatterVariable {
    name: string;
    type: VariableType;
    multi: boolean;
    includeAll: boolean;
}
export declare const defaultCustomFormatterVariable: () => CustomFormatterVariable;
export interface CustomVariableValue {
    formatter: string | VariableCustomFormatterFn;
}
export declare const defaultCustomVariableValue: () => CustomVariableValue;
export interface VariableCustomFormatterFn {
    value: any;
    legacyVariableModel: {
        name: string;
        type: VariableType;
        multi: boolean;
        includeAll: boolean;
    };
    legacyDefaultFormatter?: VariableCustomFormatterFn;
}
export declare const defaultVariableCustomFormatterFn: () => VariableCustomFormatterFn;
export type VariableType = "query" | "adhoc" | "groupby" | "constant" | "datasource" | "interval" | "textbox" | "custom" | "system" | "snapshot";
export declare const defaultVariableType: () => VariableType;
export type VariableKind = QueryVariableKind | TextVariableKind | ConstantVariableKind | DatasourceVariableKind | IntervalVariableKind | CustomVariableKind | GroupByVariableKind | AdhocVariableKind;
export declare const defaultVariableKind: () => VariableKind;
export type VariableSort = "disabled" | "alphabeticalAsc" | "alphabeticalDesc" | "numericalAsc" | "numericalDesc" | "alphabeticalCaseInsensitiveAsc" | "alphabeticalCaseInsensitiveDesc" | "naturalAsc" | "naturalDesc";
export declare const defaultVariableSort: () => VariableSort;
export type VariableRefresh = "never" | "onDashboardLoad" | "onTimeRangeChanged";
export declare const defaultVariableRefresh: () => VariableRefresh;
export type VariableHide = "dontHide" | "hideLabel" | "hideVariable";
export declare const defaultVariableHide: () => VariableHide;
export interface VariableValueOption {
    label: string;
    value: VariableValueSingle;
    group?: string;
}
export declare const defaultVariableValueOption: () => VariableValueOption;
export interface VariableOption {
    selected?: boolean;
    text: string | string[];
    value: string | string[];
}
export declare const defaultVariableOption: () => VariableOption;
export interface QueryVariableSpec {
    name: string;
    current: VariableOption;
    label?: string;
    hide: VariableHide;
    refresh: VariableRefresh;
    skipUrlSync: boolean;
    description?: string;
    datasource?: DataSourceRef;
    query: string | DataQueryKind;
    regex: string;
    sort: VariableSort;
    definition?: string;
    options: VariableOption[];
    multi: boolean;
    includeAll: boolean;
    allValue?: string;
    placeholder?: string;
}
export declare const defaultQueryVariableSpec: () => QueryVariableSpec;
export interface QueryVariableKind {
    kind: "QueryVariable";
    spec: QueryVariableSpec;
}
export declare const defaultQueryVariableKind: () => QueryVariableKind;
export interface TextVariableSpec {
    name: string;
    current: VariableOption;
    query: string;
    label?: string;
    hide: VariableHide;
    skipUrlSync: boolean;
    description?: string;
}
export declare const defaultTextVariableSpec: () => TextVariableSpec;
export interface TextVariableKind {
    kind: "TextVariable";
    spec: TextVariableSpec;
}
export declare const defaultTextVariableKind: () => TextVariableKind;
export interface ConstantVariableSpec {
    name: string;
    query: string;
    current: VariableOption;
    label?: string;
    hide: VariableHide;
    skipUrlSync: boolean;
    description?: string;
}
export declare const defaultConstantVariableSpec: () => ConstantVariableSpec;
export interface ConstantVariableKind {
    kind: "ConstantVariable";
    spec: ConstantVariableSpec;
}
export declare const defaultConstantVariableKind: () => ConstantVariableKind;
export interface DatasourceVariableSpec {
    name: string;
    pluginId: string;
    refresh: VariableRefresh;
    regex: string;
    current: VariableOption;
    options: VariableOption[];
    multi: boolean;
    includeAll: boolean;
    allValue?: string;
    label?: string;
    hide: VariableHide;
    skipUrlSync: boolean;
    description?: string;
}
export declare const defaultDatasourceVariableSpec: () => DatasourceVariableSpec;
export interface DatasourceVariableKind {
    kind: "DatasourceVariable";
    spec: DatasourceVariableSpec;
}
export declare const defaultDatasourceVariableKind: () => DatasourceVariableKind;
export interface IntervalVariableSpec {
    name: string;
    query: string;
    current: VariableOption;
    options: VariableOption[];
    auto: boolean;
    auto_min: string;
    auto_count: number;
    refresh: VariableRefresh;
    label?: string;
    hide: VariableHide;
    skipUrlSync: boolean;
    description?: string;
}
export declare const defaultIntervalVariableSpec: () => IntervalVariableSpec;
export interface IntervalVariableKind {
    kind: "IntervalVariable";
    spec: IntervalVariableSpec;
}
export declare const defaultIntervalVariableKind: () => IntervalVariableKind;
export interface CustomVariableSpec {
    name: string;
    query: string;
    current: VariableOption;
    options: VariableOption[];
    multi: boolean;
    includeAll: boolean;
    allValue?: string;
    label?: string;
    hide: VariableHide;
    skipUrlSync: boolean;
    description?: string;
}
export declare const defaultCustomVariableSpec: () => CustomVariableSpec;
export interface CustomVariableKind {
    kind: "CustomVariable";
    spec: CustomVariableSpec;
}
export declare const defaultCustomVariableKind: () => CustomVariableKind;
export interface GroupByVariableSpec {
    name: string;
    datasource?: DataSourceRef;
    current: VariableOption;
    options: VariableOption[];
    multi: boolean;
    includeAll: boolean;
    allValue?: string;
    label?: string;
    hide: VariableHide;
    skipUrlSync: boolean;
    description?: string;
}
export declare const defaultGroupByVariableSpec: () => GroupByVariableSpec;
export interface GroupByVariableKind {
    kind: "GroupByVariable";
    spec: GroupByVariableSpec;
}
export declare const defaultGroupByVariableKind: () => GroupByVariableKind;
export interface AdhocVariableSpec {
    name: string;
    datasource?: DataSourceRef;
    baseFilters: AdHocFilterWithLabels[];
    filters: AdHocFilterWithLabels[];
    defaultKeys: MetricFindValue[];
    label?: string;
    hide: VariableHide;
    skipUrlSync: boolean;
    description?: string;
}
export declare const defaultAdhocVariableSpec: () => AdhocVariableSpec;
export interface MetricFindValue {
    text: string;
    value?: string | number;
    group?: string;
    expandable?: boolean;
}
export declare const defaultMetricFindValue: () => MetricFindValue;
export interface AdHocFilterWithLabels {
    key: string;
    operator: string;
    value: string;
    values?: string[];
    keyLabel?: string;
    valueLabels?: string[];
    forceEdit?: boolean;
    condition?: string;
}
export declare const defaultAdHocFilterWithLabels: () => AdHocFilterWithLabels;
export interface AdhocVariableKind {
    kind: "AdhocVariable";
    spec: AdhocVariableSpec;
}
export declare const defaultAdhocVariableKind: () => AdhocVariableKind;
