"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebVitalsBasic = void 0;
var web_vitals_1 = require("web-vitals");
var WebVitalsBasic = /** @class */ (function () {
    function WebVitalsBasic(pushMeasurement, webVitalConfig) {
        this.pushMeasurement = pushMeasurement;
        this.webVitalConfig = webVitalConfig;
    }
    WebVitalsBasic.prototype.initialize = function () {
        var _this = this;
        Object.entries(WebVitalsBasic.mapping).forEach(function (_a) {
            var _b;
            var indicator = _a[0], executor = _a[1];
            executor(function (metric) {
                var _a;
                _this.pushMeasurement({
                    type: 'web-vitals',
                    values: (_a = {},
                        _a[indicator] = metric.value,
                        _a),
                });
            }, { reportAllChanges: (_b = _this.webVitalConfig) === null || _b === void 0 ? void 0 : _b.reportAllChanges });
        });
    };
    WebVitalsBasic.mapping = {
        cls: web_vitals_1.onCLS,
        fcp: web_vitals_1.onFCP,
        fid: web_vitals_1.onFID,
        inp: web_vitals_1.onINP,
        lcp: web_vitals_1.onLCP,
        ttfb: web_vitals_1.onTTFB,
    };
    return WebVitalsBasic;
}());
exports.WebVitalsBasic = WebVitalsBasic;
//# sourceMappingURL=webVitalsBasic.js.map