"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isInternalFaroOnGlobalObject = exports.setInternalFaroOnGlobalObject = exports.getInternalFromGlobalObject = void 0;
var globalObject_1 = require("../globalObject");
var const_1 = require("./const");
function getInternalFromGlobalObject() {
    return globalObject_1.globalObject[const_1.internalGlobalObjectKey];
}
exports.getInternalFromGlobalObject = getInternalFromGlobalObject;
function setInternalFaroOnGlobalObject(faro) {
    if (!faro.config.isolate) {
        faro.internalLogger.debug('Registering internal Faro instance on global object');
        Object.defineProperty(globalObject_1.globalObject, const_1.internalGlobalObjectKey, {
            configurable: false,
            enumerable: false,
            writable: false,
            value: faro,
        });
    }
    else {
        faro.internalLogger.debug('Skipping registering internal Faro instance on global object');
    }
}
exports.setInternalFaroOnGlobalObject = setInternalFaroOnGlobalObject;
function isInternalFaroOnGlobalObject() {
    return const_1.internalGlobalObjectKey in globalObject_1.globalObject;
}
exports.isInternalFaroOnGlobalObject = isInternalFaroOnGlobalObject;
//# sourceMappingURL=internalFaroGlobalObject.js.map