"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeExceptionsAPI = void 0;
var transports_1 = require("../../transports");
var utils_1 = require("../../utils");
var date_1 = require("../../utils/date");
var utils_2 = require("../utils");
var const_1 = require("./const");
var stacktraceParser;
function initializeExceptionsAPI(_unpatchedConsole, internalLogger, config, metas, transports, tracesApi) {
    var _a;
    internalLogger.debug('Initializing exceptions API');
    var lastPayload = null;
    stacktraceParser = (_a = config.parseStacktrace) !== null && _a !== void 0 ? _a : stacktraceParser;
    var changeStacktraceParser = function (newStacktraceParser) {
        internalLogger.debug('Changing stacktrace parser');
        stacktraceParser = newStacktraceParser !== null && newStacktraceParser !== void 0 ? newStacktraceParser : stacktraceParser;
    };
    var getStacktraceParser = function () { return stacktraceParser; };
    var _b = config.ignoreErrors, ignoreErrors = _b === void 0 ? [] : _b;
    var pushError = function (error, _a) {
        var _b = _a === void 0 ? {} : _a, skipDedupe = _b.skipDedupe, stackFrames = _b.stackFrames, type = _b.type, context = _b.context, spanContext = _b.spanContext, timestampOverwriteMs = _b.timestampOverwriteMs;
        if (isErrorIgnored(ignoreErrors, error)) {
            return;
        }
        var item = {
            meta: metas.value,
            payload: {
                type: type || error.name || const_1.defaultExceptionType,
                value: error.message,
                timestamp: timestampOverwriteMs ? (0, date_1.timestampToIsoString)(timestampOverwriteMs) : (0, utils_1.getCurrentTimestamp)(),
                trace: spanContext
                    ? {
                        trace_id: spanContext.traceId,
                        span_id: spanContext.spanId,
                    }
                    : tracesApi.getTraceContext(),
                context: (0, utils_1.stringifyObjectValues)(__assign(__assign({}, parseCause(error)), (context !== null && context !== void 0 ? context : {}))),
            },
            type: transports_1.TransportItemType.EXCEPTION,
        };
        stackFrames = stackFrames !== null && stackFrames !== void 0 ? stackFrames : (error.stack ? stacktraceParser === null || stacktraceParser === void 0 ? void 0 : stacktraceParser(error).frames : undefined);
        if (stackFrames === null || stackFrames === void 0 ? void 0 : stackFrames.length) {
            item.payload.stacktrace = {
                frames: stackFrames,
            };
        }
        var testingPayload = {
            type: item.payload.type,
            value: item.payload.value,
            stackTrace: item.payload.stacktrace,
            context: item.payload.context,
        };
        if (!skipDedupe && config.dedupe && !(0, utils_1.isNull)(lastPayload) && (0, utils_1.deepEqual)(testingPayload, lastPayload)) {
            internalLogger.debug('Skipping error push because it is the same as the last one\n', item.payload);
            return;
        }
        lastPayload = testingPayload;
        internalLogger.debug('Pushing exception\n', item);
        transports.execute(item);
    };
    changeStacktraceParser(config.parseStacktrace);
    return {
        changeStacktraceParser: changeStacktraceParser,
        getStacktraceParser: getStacktraceParser,
        pushError: pushError,
    };
}
exports.initializeExceptionsAPI = initializeExceptionsAPI;
function parseCause(error) {
    var cause = error.cause;
    if ((0, utils_1.isError)(cause)) {
        cause = error.cause.toString();
        // typeof operator on null returns "object". This is a well-known quirk in JavaScript and is considered a bug that cannot be fixed due to backward compatibility issues.
        // MDN: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/typeof#typeof_null
    }
    else if (cause !== null && ((0, utils_1.isObject)(error.cause) || (0, utils_1.isArray)(error.cause))) {
        cause = (0, utils_1.stringifyExternalJson)(error.cause);
    }
    else if (cause != null) {
        cause = error.cause.toString();
    }
    return cause == null ? {} : { cause: cause };
}
function isErrorIgnored(ignoreErrors, error) {
    var message = error.message, name = error.name, stack = error.stack;
    return (0, utils_2.shouldIgnoreEvent)(ignoreErrors, message + ' ' + name + ' ' + stack);
}
//# sourceMappingURL=initialize.js.map