import { FieldType, TIME_SERIES_VALUE_FIELD_NAME } from '../types/dataFrame.js';
import { guessFieldTypeForField } from './processDataFrame.js';

class ArrayDataFrame {
  constructor(source, names) {
    this.fields = [];
    this.length = 0;
    return arrayToDataFrame(source, names);
  }
}
function arrayToDataFrame(source, names) {
  const df = {
    fields: [],
    length: source.length
  };
  if (!(source == null ? void 0 : source.length)) {
    return df;
  }
  if (names) {
    if (!isObjectArray(source)) {
      throw new Error("source is not an array of objects");
    }
    for (const name of names) {
      df.fields.push(
        makeFieldFromValues(
          name,
          source.map((v) => v ? v[name] : v)
        )
      );
    }
    return df;
  }
  const firstDefined = source.find((v) => v);
  if (firstDefined === null) {
    return df;
  }
  if (isObjectArray(source)) {
    const first = source.find((v) => v);
    df.fields = Object.keys(first || {}).map((name) => {
      return makeFieldFromValues(
        name,
        source.map((v) => v ? v[name] : v)
      );
    });
  } else {
    df.fields.push(makeFieldFromValues(TIME_SERIES_VALUE_FIELD_NAME, source));
  }
  return df;
}
function makeFieldFromValues(name, values) {
  var _a;
  const f = { name, config: {}, values, type: FieldType.other };
  f.type = (_a = guessFieldTypeForField(f)) != null ? _a : FieldType.other;
  return f;
}
function isObjectArray(arr) {
  const first = arr.find((v) => v);
  return arr.length > 0 && typeof first === "object";
}

export { ArrayDataFrame, arrayToDataFrame };
//# sourceMappingURL=ArrayDataFrame.js.map
