//
//Copyright 2024 Google LLC
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//https://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.23.4
// source: sharedprotos/configurablemetrics/configurablemetrics.proto

package configurablemetrics

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type OSVendor int32

const (
	OSVendor_OS_VENDOR_UNSPECIFIED OSVendor = 0
	OSVendor_ALL                   OSVendor = 1
	OSVendor_RHEL                  OSVendor = 2
	OSVendor_SLES                  OSVendor = 3
)

// Enum value maps for OSVendor.
var (
	OSVendor_name = map[int32]string{
		0: "OS_VENDOR_UNSPECIFIED",
		1: "ALL",
		2: "RHEL",
		3: "SLES",
	}
	OSVendor_value = map[string]int32{
		"OS_VENDOR_UNSPECIFIED": 0,
		"ALL":                   1,
		"RHEL":                  2,
		"SLES":                  3,
	}
)

func (x OSVendor) Enum() *OSVendor {
	p := new(OSVendor)
	*p = x
	return p
}

func (x OSVendor) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSVendor) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_enumTypes[0].Descriptor()
}

func (OSVendor) Type() protoreflect.EnumType {
	return &file_sharedprotos_configurablemetrics_configurablemetrics_proto_enumTypes[0]
}

func (x OSVendor) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSVendor.Descriptor instead.
func (OSVendor) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP(), []int{0}
}

type OutputSource int32

const (
	OutputSource_OUTPUT_SOURCE_UNSPECIFIED OutputSource = 0
	OutputSource_STDOUT                    OutputSource = 1
	OutputSource_STDERR                    OutputSource = 2
	OutputSource_EXIT_CODE                 OutputSource = 3
)

// Enum value maps for OutputSource.
var (
	OutputSource_name = map[int32]string{
		0: "OUTPUT_SOURCE_UNSPECIFIED",
		1: "STDOUT",
		2: "STDERR",
		3: "EXIT_CODE",
	}
	OutputSource_value = map[string]int32{
		"OUTPUT_SOURCE_UNSPECIFIED": 0,
		"STDOUT":                    1,
		"STDERR":                    2,
		"EXIT_CODE":                 3,
	}
)

func (x OutputSource) Enum() *OutputSource {
	p := new(OutputSource)
	*p = x
	return p
}

func (x OutputSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutputSource) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_enumTypes[1].Descriptor()
}

func (OutputSource) Type() protoreflect.EnumType {
	return &file_sharedprotos_configurablemetrics_configurablemetrics_proto_enumTypes[1]
}

func (x OutputSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutputSource.Descriptor instead.
func (OutputSource) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP(), []int{1}
}

type EvalMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	// Types that are assignable to EvalRuleTypes:
	//
	//	*EvalMetric_AndEvalRules
	//	*EvalMetric_OrEvalRules
	EvalRuleTypes isEvalMetric_EvalRuleTypes `protobuf_oneof:"eval_rule_types"`
}

func (x *EvalMetric) Reset() {
	*x = EvalMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvalMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvalMetric) ProtoMessage() {}

func (x *EvalMetric) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvalMetric.ProtoReflect.Descriptor instead.
func (*EvalMetric) Descriptor() ([]byte, []int) {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP(), []int{0}
}

func (x *EvalMetric) GetMetricInfo() *MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (m *EvalMetric) GetEvalRuleTypes() isEvalMetric_EvalRuleTypes {
	if m != nil {
		return m.EvalRuleTypes
	}
	return nil
}

func (x *EvalMetric) GetAndEvalRules() *EvalMetricRule {
	if x, ok := x.GetEvalRuleTypes().(*EvalMetric_AndEvalRules); ok {
		return x.AndEvalRules
	}
	return nil
}

func (x *EvalMetric) GetOrEvalRules() *OrEvalMetricRule {
	if x, ok := x.GetEvalRuleTypes().(*EvalMetric_OrEvalRules); ok {
		return x.OrEvalRules
	}
	return nil
}

type isEvalMetric_EvalRuleTypes interface {
	isEvalMetric_EvalRuleTypes()
}

type EvalMetric_AndEvalRules struct {
	AndEvalRules *EvalMetricRule `protobuf:"bytes,2,opt,name=and_eval_rules,json=andEvalRules,proto3,oneof"`
}

type EvalMetric_OrEvalRules struct {
	OrEvalRules *OrEvalMetricRule `protobuf:"bytes,3,opt,name=or_eval_rules,json=orEvalRules,proto3,oneof"`
}

func (*EvalMetric_AndEvalRules) isEvalMetric_EvalRuleTypes() {}

func (*EvalMetric_OrEvalRules) isEvalMetric_EvalRuleTypes() {}

type OSCommandMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricInfo *MetricInfo `protobuf:"bytes,1,opt,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty"`
	OsVendor   OSVendor    `protobuf:"varint,2,opt,name=os_vendor,json=osVendor,proto3,enum=workloadagentplatform.sharedprotos.configurablemetrics.OSVendor" json:"os_vendor,omitempty"`
	Command    string      `protobuf:"bytes,3,opt,name=command,proto3" json:"command,omitempty"`
	Args       []string    `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty"`
	// Types that are assignable to EvalRuleTypes:
	//
	//	*OSCommandMetric_AndEvalRules
	//	*OSCommandMetric_OrEvalRules
	EvalRuleTypes isOSCommandMetric_EvalRuleTypes `protobuf_oneof:"eval_rule_types"`
}

func (x *OSCommandMetric) Reset() {
	*x = OSCommandMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSCommandMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSCommandMetric) ProtoMessage() {}

func (x *OSCommandMetric) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSCommandMetric.ProtoReflect.Descriptor instead.
func (*OSCommandMetric) Descriptor() ([]byte, []int) {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP(), []int{1}
}

func (x *OSCommandMetric) GetMetricInfo() *MetricInfo {
	if x != nil {
		return x.MetricInfo
	}
	return nil
}

func (x *OSCommandMetric) GetOsVendor() OSVendor {
	if x != nil {
		return x.OsVendor
	}
	return OSVendor_OS_VENDOR_UNSPECIFIED
}

func (x *OSCommandMetric) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *OSCommandMetric) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (m *OSCommandMetric) GetEvalRuleTypes() isOSCommandMetric_EvalRuleTypes {
	if m != nil {
		return m.EvalRuleTypes
	}
	return nil
}

func (x *OSCommandMetric) GetAndEvalRules() *EvalMetricRule {
	if x, ok := x.GetEvalRuleTypes().(*OSCommandMetric_AndEvalRules); ok {
		return x.AndEvalRules
	}
	return nil
}

func (x *OSCommandMetric) GetOrEvalRules() *OrEvalMetricRule {
	if x, ok := x.GetEvalRuleTypes().(*OSCommandMetric_OrEvalRules); ok {
		return x.OrEvalRules
	}
	return nil
}

type isOSCommandMetric_EvalRuleTypes interface {
	isOSCommandMetric_EvalRuleTypes()
}

type OSCommandMetric_AndEvalRules struct {
	AndEvalRules *EvalMetricRule `protobuf:"bytes,6,opt,name=and_eval_rules,json=andEvalRules,proto3,oneof"`
}

type OSCommandMetric_OrEvalRules struct {
	OrEvalRules *OrEvalMetricRule `protobuf:"bytes,7,opt,name=or_eval_rules,json=orEvalRules,proto3,oneof"`
}

func (*OSCommandMetric_AndEvalRules) isOSCommandMetric_EvalRuleTypes() {}

func (*OSCommandMetric_OrEvalRules) isOSCommandMetric_EvalRuleTypes() {}

type MetricInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinVersion string `protobuf:"bytes,1,opt,name=min_version,json=minVersion,proto3" json:"min_version,omitempty"`
	Type       string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Label      string `protobuf:"bytes,3,opt,name=label,proto3" json:"label,omitempty"`
}

func (x *MetricInfo) Reset() {
	*x = MetricInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricInfo) ProtoMessage() {}

func (x *MetricInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricInfo.ProtoReflect.Descriptor instead.
func (*MetricInfo) Descriptor() ([]byte, []int) {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP(), []int{2}
}

func (x *MetricInfo) GetMinVersion() string {
	if x != nil {
		return x.MinVersion
	}
	return ""
}

func (x *MetricInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *MetricInfo) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

type OrEvalMetricRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OrEvalRules []*EvalMetricRule `protobuf:"bytes,1,rep,name=or_eval_rules,json=orEvalRules,proto3" json:"or_eval_rules,omitempty"`
}

func (x *OrEvalMetricRule) Reset() {
	*x = OrEvalMetricRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrEvalMetricRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrEvalMetricRule) ProtoMessage() {}

func (x *OrEvalMetricRule) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrEvalMetricRule.ProtoReflect.Descriptor instead.
func (*OrEvalMetricRule) Descriptor() ([]byte, []int) {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP(), []int{3}
}

func (x *OrEvalMetricRule) GetOrEvalRules() []*EvalMetricRule {
	if x != nil {
		return x.OrEvalRules
	}
	return nil
}

type EvalMetricRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EvalRules []*EvalRule `protobuf:"bytes,1,rep,name=eval_rules,json=evalRules,proto3" json:"eval_rules,omitempty"`
	IfTrue    *EvalResult `protobuf:"bytes,2,opt,name=if_true,json=ifTrue,proto3" json:"if_true,omitempty"`
	IfFalse   *EvalResult `protobuf:"bytes,3,opt,name=if_false,json=ifFalse,proto3" json:"if_false,omitempty"`
}

func (x *EvalMetricRule) Reset() {
	*x = EvalMetricRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvalMetricRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvalMetricRule) ProtoMessage() {}

func (x *EvalMetricRule) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvalMetricRule.ProtoReflect.Descriptor instead.
func (*EvalMetricRule) Descriptor() ([]byte, []int) {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP(), []int{4}
}

func (x *EvalMetricRule) GetEvalRules() []*EvalRule {
	if x != nil {
		return x.EvalRules
	}
	return nil
}

func (x *EvalMetricRule) GetIfTrue() *EvalResult {
	if x != nil {
		return x.IfTrue
	}
	return nil
}

func (x *EvalMetricRule) GetIfFalse() *EvalResult {
	if x != nil {
		return x.IfFalse
	}
	return nil
}

type EvalRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OutputSource OutputSource `protobuf:"varint,1,opt,name=output_source,json=outputSource,proto3,enum=workloadagentplatform.sharedprotos.configurablemetrics.OutputSource" json:"output_source,omitempty"`
	// Types that are assignable to EvalRuleTypes:
	//
	//	*EvalRule_OutputEquals
	//	*EvalRule_OutputNotEquals
	//	*EvalRule_OutputLessThan
	//	*EvalRule_OutputLessThanOrEqual
	//	*EvalRule_OutputGreaterThan
	//	*EvalRule_OutputGreaterThanOrEqual
	//	*EvalRule_OutputStartsWith
	//	*EvalRule_OutputEndsWith
	//	*EvalRule_OutputContains
	//	*EvalRule_OutputNotContains
	EvalRuleTypes isEvalRule_EvalRuleTypes `protobuf_oneof:"eval_rule_types"`
}

func (x *EvalRule) Reset() {
	*x = EvalRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvalRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvalRule) ProtoMessage() {}

func (x *EvalRule) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvalRule.ProtoReflect.Descriptor instead.
func (*EvalRule) Descriptor() ([]byte, []int) {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP(), []int{5}
}

func (x *EvalRule) GetOutputSource() OutputSource {
	if x != nil {
		return x.OutputSource
	}
	return OutputSource_OUTPUT_SOURCE_UNSPECIFIED
}

func (m *EvalRule) GetEvalRuleTypes() isEvalRule_EvalRuleTypes {
	if m != nil {
		return m.EvalRuleTypes
	}
	return nil
}

func (x *EvalRule) GetOutputEquals() string {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputEquals); ok {
		return x.OutputEquals
	}
	return ""
}

func (x *EvalRule) GetOutputNotEquals() string {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputNotEquals); ok {
		return x.OutputNotEquals
	}
	return ""
}

func (x *EvalRule) GetOutputLessThan() float64 {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputLessThan); ok {
		return x.OutputLessThan
	}
	return 0
}

func (x *EvalRule) GetOutputLessThanOrEqual() float64 {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputLessThanOrEqual); ok {
		return x.OutputLessThanOrEqual
	}
	return 0
}

func (x *EvalRule) GetOutputGreaterThan() float64 {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputGreaterThan); ok {
		return x.OutputGreaterThan
	}
	return 0
}

func (x *EvalRule) GetOutputGreaterThanOrEqual() float64 {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputGreaterThanOrEqual); ok {
		return x.OutputGreaterThanOrEqual
	}
	return 0
}

func (x *EvalRule) GetOutputStartsWith() string {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputStartsWith); ok {
		return x.OutputStartsWith
	}
	return ""
}

func (x *EvalRule) GetOutputEndsWith() string {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputEndsWith); ok {
		return x.OutputEndsWith
	}
	return ""
}

func (x *EvalRule) GetOutputContains() string {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputContains); ok {
		return x.OutputContains
	}
	return ""
}

func (x *EvalRule) GetOutputNotContains() string {
	if x, ok := x.GetEvalRuleTypes().(*EvalRule_OutputNotContains); ok {
		return x.OutputNotContains
	}
	return ""
}

type isEvalRule_EvalRuleTypes interface {
	isEvalRule_EvalRuleTypes()
}

type EvalRule_OutputEquals struct {
	OutputEquals string `protobuf:"bytes,2,opt,name=output_equals,json=outputEquals,proto3,oneof"`
}

type EvalRule_OutputNotEquals struct {
	OutputNotEquals string `protobuf:"bytes,3,opt,name=output_not_equals,json=outputNotEquals,proto3,oneof"`
}

type EvalRule_OutputLessThan struct {
	OutputLessThan float64 `protobuf:"fixed64,4,opt,name=output_less_than,json=outputLessThan,proto3,oneof"`
}

type EvalRule_OutputLessThanOrEqual struct {
	OutputLessThanOrEqual float64 `protobuf:"fixed64,5,opt,name=output_less_than_or_equal,json=outputLessThanOrEqual,proto3,oneof"`
}

type EvalRule_OutputGreaterThan struct {
	OutputGreaterThan float64 `protobuf:"fixed64,6,opt,name=output_greater_than,json=outputGreaterThan,proto3,oneof"`
}

type EvalRule_OutputGreaterThanOrEqual struct {
	OutputGreaterThanOrEqual float64 `protobuf:"fixed64,7,opt,name=output_greater_than_or_equal,json=outputGreaterThanOrEqual,proto3,oneof"`
}

type EvalRule_OutputStartsWith struct {
	OutputStartsWith string `protobuf:"bytes,8,opt,name=output_starts_with,json=outputStartsWith,proto3,oneof"`
}

type EvalRule_OutputEndsWith struct {
	OutputEndsWith string `protobuf:"bytes,9,opt,name=output_ends_with,json=outputEndsWith,proto3,oneof"`
}

type EvalRule_OutputContains struct {
	OutputContains string `protobuf:"bytes,10,opt,name=output_contains,json=outputContains,proto3,oneof"`
}

type EvalRule_OutputNotContains struct {
	OutputNotContains string `protobuf:"bytes,11,opt,name=output_not_contains,json=outputNotContains,proto3,oneof"`
}

func (*EvalRule_OutputEquals) isEvalRule_EvalRuleTypes() {}

func (*EvalRule_OutputNotEquals) isEvalRule_EvalRuleTypes() {}

func (*EvalRule_OutputLessThan) isEvalRule_EvalRuleTypes() {}

func (*EvalRule_OutputLessThanOrEqual) isEvalRule_EvalRuleTypes() {}

func (*EvalRule_OutputGreaterThan) isEvalRule_EvalRuleTypes() {}

func (*EvalRule_OutputGreaterThanOrEqual) isEvalRule_EvalRuleTypes() {}

func (*EvalRule_OutputStartsWith) isEvalRule_EvalRuleTypes() {}

func (*EvalRule_OutputEndsWith) isEvalRule_EvalRuleTypes() {}

func (*EvalRule_OutputContains) isEvalRule_EvalRuleTypes() {}

func (*EvalRule_OutputNotContains) isEvalRule_EvalRuleTypes() {}

type EvalResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to EvalResultTypes:
	//
	//	*EvalResult_ValueFromLiteral
	//	*EvalResult_ValueFromOutput
	//	*EvalResult_ValueFromRegex
	EvalResultTypes isEvalResult_EvalResultTypes `protobuf_oneof:"eval_result_types"`
	OutputSource    OutputSource                 `protobuf:"varint,4,opt,name=output_source,json=outputSource,proto3,enum=workloadagentplatform.sharedprotos.configurablemetrics.OutputSource" json:"output_source,omitempty"`
}

func (x *EvalResult) Reset() {
	*x = EvalResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvalResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvalResult) ProtoMessage() {}

func (x *EvalResult) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvalResult.ProtoReflect.Descriptor instead.
func (*EvalResult) Descriptor() ([]byte, []int) {
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP(), []int{6}
}

func (m *EvalResult) GetEvalResultTypes() isEvalResult_EvalResultTypes {
	if m != nil {
		return m.EvalResultTypes
	}
	return nil
}

func (x *EvalResult) GetValueFromLiteral() string {
	if x, ok := x.GetEvalResultTypes().(*EvalResult_ValueFromLiteral); ok {
		return x.ValueFromLiteral
	}
	return ""
}

func (x *EvalResult) GetValueFromOutput() bool {
	if x, ok := x.GetEvalResultTypes().(*EvalResult_ValueFromOutput); ok {
		return x.ValueFromOutput
	}
	return false
}

func (x *EvalResult) GetValueFromRegex() string {
	if x, ok := x.GetEvalResultTypes().(*EvalResult_ValueFromRegex); ok {
		return x.ValueFromRegex
	}
	return ""
}

func (x *EvalResult) GetOutputSource() OutputSource {
	if x != nil {
		return x.OutputSource
	}
	return OutputSource_OUTPUT_SOURCE_UNSPECIFIED
}

type isEvalResult_EvalResultTypes interface {
	isEvalResult_EvalResultTypes()
}

type EvalResult_ValueFromLiteral struct {
	ValueFromLiteral string `protobuf:"bytes,1,opt,name=value_from_literal,json=valueFromLiteral,proto3,oneof"`
}

type EvalResult_ValueFromOutput struct {
	ValueFromOutput bool `protobuf:"varint,2,opt,name=value_from_output,json=valueFromOutput,proto3,oneof"`
}

type EvalResult_ValueFromRegex struct {
	ValueFromRegex string `protobuf:"bytes,3,opt,name=value_from_regex,json=valueFromRegex,proto3,oneof"`
}

func (*EvalResult_ValueFromLiteral) isEvalResult_EvalResultTypes() {}

func (*EvalResult_ValueFromOutput) isEvalResult_EvalResultTypes() {}

func (*EvalResult_ValueFromRegex) isEvalResult_EvalResultTypes() {}

var File_sharedprotos_configurablemetrics_configurablemetrics_proto protoreflect.FileDescriptor

var file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x36, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x22, 0xe4, 0x02, 0x0a, 0x0a, 0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x12, 0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x6e, 0x0a, 0x0e, 0x61, 0x6e, 0x64, 0x5f,
	0x65, 0x76, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x46, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x52, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x6e, 0x64, 0x45,
	0x76, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x6e, 0x0a, 0x0d, 0x6f, 0x72, 0x5f, 0x65,
	0x76, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x48, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c,
	0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x6f, 0x72, 0x45,
	0x76, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x42, 0x11, 0x0a, 0x0f, 0x65, 0x76, 0x61, 0x6c,
	0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x22, 0xf6, 0x03, 0x0a, 0x0f,
	0x4f, 0x53, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12,
	0x63, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5d, 0x0a, 0x09, 0x6f, 0x73, 0x5f, 0x76, 0x65, 0x6e, 0x64, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x4f, 0x53, 0x56, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x52, 0x08, 0x6f, 0x73, 0x56, 0x65, 0x6e,
	0x64, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x67,
	0x73, 0x12, 0x6e, 0x0a, 0x0e, 0x61, 0x6e, 0x64, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x75, 0x6c,
	0x65, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x6e, 0x64, 0x45, 0x76, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x6e, 0x0a, 0x0d, 0x6f, 0x72, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x4f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x75,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x42, 0x11, 0x0a, 0x0f, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x22, 0x57, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x7e, 0x0a,
	0x10, 0x4f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x75, 0x6c,
	0x65, 0x12, 0x6a, 0x0a, 0x0d, 0x6f, 0x72, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x0b, 0x6f, 0x72, 0x45, 0x76, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xad, 0x02,
	0x0a, 0x0e, 0x45, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x5f, 0x0a, 0x0a, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x76,
	0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x09, 0x65, 0x76, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x5b, 0x0a, 0x07, 0x69, 0x66, 0x5f, 0x74, 0x72, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x76, 0x61, 0x6c,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x69, 0x66, 0x54, 0x72, 0x75, 0x65, 0x12, 0x5d,
	0x0a, 0x08, 0x69, 0x66, 0x5f, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x69, 0x66, 0x46, 0x61, 0x6c, 0x73, 0x65, 0x22, 0xf2, 0x04,
	0x0a, 0x08, 0x45, 0x76, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x69, 0x0a, 0x0d, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x44, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x45, 0x71, 0x75, 0x61, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x11,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x4e, 0x6f, 0x74, 0x45, 0x71, 0x75, 0x61, 0x6c, 0x73, 0x12, 0x2a, 0x0a, 0x10, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x65,
	0x73, 0x73, 0x54, 0x68, 0x61, 0x6e, 0x12, 0x3a, 0x0a, 0x19, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x5f, 0x6f, 0x72, 0x5f, 0x65, 0x71,
	0x75, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x15, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x4c, 0x65, 0x73, 0x73, 0x54, 0x68, 0x61, 0x6e, 0x4f, 0x72, 0x45, 0x71, 0x75,
	0x61, 0x6c, 0x12, 0x30, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x00, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x47, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x54, 0x68, 0x61, 0x6e, 0x12, 0x40, 0x0a, 0x1c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x5f, 0x6f, 0x72, 0x5f, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x18, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x47, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x54, 0x68, 0x61, 0x6e, 0x4f,
	0x72, 0x45, 0x71, 0x75, 0x61, 0x6c, 0x12, 0x2e, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x73, 0x57, 0x69, 0x74, 0x68, 0x12, 0x2a, 0x0a, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x65, 0x6e, 0x64, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x45, 0x6e, 0x64, 0x73, 0x57, 0x69,
	0x74, 0x68, 0x12, 0x29, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x30, 0x0a,
	0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x11, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x4e, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x42,
	0x11, 0x0a, 0x0f, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x22, 0x96, 0x02, 0x0a, 0x0a, 0x45, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x2e, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f,
	0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x10, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61,
	0x6c, 0x12, 0x2c, 0x0a, 0x11, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12,
	0x2a, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x72, 0x65,
	0x67, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x69, 0x0a, 0x0d, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x44, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2a, 0x42, 0x0a, 0x08, 0x4f,
	0x53, 0x56, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x53, 0x5f, 0x56, 0x45,
	0x4e, 0x44, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x52,
	0x48, 0x45, 0x4c, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x4c, 0x45, 0x53, 0x10, 0x03, 0x2a,
	0x54, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x54, 0x44, 0x4f, 0x55, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54,
	0x44, 0x45, 0x52, 0x52, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x58, 0x49, 0x54, 0x5f, 0x43,
	0x4f, 0x44, 0x45, 0x10, 0x03, 0x42, 0x57, 0x5a, 0x55, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescOnce sync.Once
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescData = file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDesc
)

func file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescGZIP() []byte {
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescOnce.Do(func() {
		file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescData = protoimpl.X.CompressGZIP(file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescData)
	})
	return file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDescData
}

var file_sharedprotos_configurablemetrics_configurablemetrics_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_sharedprotos_configurablemetrics_configurablemetrics_proto_goTypes = []interface{}{
	(OSVendor)(0),            // 0: workloadagentplatform.sharedprotos.configurablemetrics.OSVendor
	(OutputSource)(0),        // 1: workloadagentplatform.sharedprotos.configurablemetrics.OutputSource
	(*EvalMetric)(nil),       // 2: workloadagentplatform.sharedprotos.configurablemetrics.EvalMetric
	(*OSCommandMetric)(nil),  // 3: workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric
	(*MetricInfo)(nil),       // 4: workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	(*OrEvalMetricRule)(nil), // 5: workloadagentplatform.sharedprotos.configurablemetrics.OrEvalMetricRule
	(*EvalMetricRule)(nil),   // 6: workloadagentplatform.sharedprotos.configurablemetrics.EvalMetricRule
	(*EvalRule)(nil),         // 7: workloadagentplatform.sharedprotos.configurablemetrics.EvalRule
	(*EvalResult)(nil),       // 8: workloadagentplatform.sharedprotos.configurablemetrics.EvalResult
}
var file_sharedprotos_configurablemetrics_configurablemetrics_proto_depIdxs = []int32{
	4,  // 0: workloadagentplatform.sharedprotos.configurablemetrics.EvalMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	6,  // 1: workloadagentplatform.sharedprotos.configurablemetrics.EvalMetric.and_eval_rules:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.EvalMetricRule
	5,  // 2: workloadagentplatform.sharedprotos.configurablemetrics.EvalMetric.or_eval_rules:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OrEvalMetricRule
	4,  // 3: workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric.metric_info:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.MetricInfo
	0,  // 4: workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric.os_vendor:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OSVendor
	6,  // 5: workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric.and_eval_rules:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.EvalMetricRule
	5,  // 6: workloadagentplatform.sharedprotos.configurablemetrics.OSCommandMetric.or_eval_rules:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OrEvalMetricRule
	6,  // 7: workloadagentplatform.sharedprotos.configurablemetrics.OrEvalMetricRule.or_eval_rules:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.EvalMetricRule
	7,  // 8: workloadagentplatform.sharedprotos.configurablemetrics.EvalMetricRule.eval_rules:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.EvalRule
	8,  // 9: workloadagentplatform.sharedprotos.configurablemetrics.EvalMetricRule.if_true:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.EvalResult
	8,  // 10: workloadagentplatform.sharedprotos.configurablemetrics.EvalMetricRule.if_false:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.EvalResult
	1,  // 11: workloadagentplatform.sharedprotos.configurablemetrics.EvalRule.output_source:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OutputSource
	1,  // 12: workloadagentplatform.sharedprotos.configurablemetrics.EvalResult.output_source:type_name -> workloadagentplatform.sharedprotos.configurablemetrics.OutputSource
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_sharedprotos_configurablemetrics_configurablemetrics_proto_init() }
func file_sharedprotos_configurablemetrics_configurablemetrics_proto_init() {
	if File_sharedprotos_configurablemetrics_configurablemetrics_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvalMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSCommandMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrEvalMetricRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvalMetricRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvalRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvalResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*EvalMetric_AndEvalRules)(nil),
		(*EvalMetric_OrEvalRules)(nil),
	}
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*OSCommandMetric_AndEvalRules)(nil),
		(*OSCommandMetric_OrEvalRules)(nil),
	}
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*EvalRule_OutputEquals)(nil),
		(*EvalRule_OutputNotEquals)(nil),
		(*EvalRule_OutputLessThan)(nil),
		(*EvalRule_OutputLessThanOrEqual)(nil),
		(*EvalRule_OutputGreaterThan)(nil),
		(*EvalRule_OutputGreaterThanOrEqual)(nil),
		(*EvalRule_OutputStartsWith)(nil),
		(*EvalRule_OutputEndsWith)(nil),
		(*EvalRule_OutputContains)(nil),
		(*EvalRule_OutputNotContains)(nil),
	}
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*EvalResult_ValueFromLiteral)(nil),
		(*EvalResult_ValueFromOutput)(nil),
		(*EvalResult_ValueFromRegex)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sharedprotos_configurablemetrics_configurablemetrics_proto_goTypes,
		DependencyIndexes: file_sharedprotos_configurablemetrics_configurablemetrics_proto_depIdxs,
		EnumInfos:         file_sharedprotos_configurablemetrics_configurablemetrics_proto_enumTypes,
		MessageInfos:      file_sharedprotos_configurablemetrics_configurablemetrics_proto_msgTypes,
	}.Build()
	File_sharedprotos_configurablemetrics_configurablemetrics_proto = out.File
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_rawDesc = nil
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_goTypes = nil
	file_sharedprotos_configurablemetrics_configurablemetrics_proto_depIdxs = nil
}
