<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!-- $Id: NTP-FAQ.dsl,v 3.1 2000/08/12 21:23:01 windl Exp $ -->
<!-- Copyright (c) 1999, 2000 by Ulrich Windl.  All rights reserved. -->

<!ENTITY html-ss PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA dsssl>
<!ENTITY print-ss PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA dsssl>
]>

<style-sheet>
  <!-- HTML style sheet -->
  <style-specification id="html" use="html-stylesheet">
    <style-specification-body>
(define %honorific-punctuation% "") ; (1.42) don't add dot; add nothing
(define %generate-article-toc% #t)
(define %use-id-as-filename% #t)
;;; number sections
(define %section-autolabel% #t)
(define %stylesheet% "docbook.css")
(define %link-mailto-url% "mailto:Ulrich.Windl@rz.uni-regensburg.de")
(define (article-titlepage-recto-elements)
  (list (normalize "title")
        (normalize "subtitle")
        (normalize "graphic")
        (normalize "date")
        (normalize "corpauthor")
        (normalize "authorgroup")
        (normalize "author")
        (normalize "orgname")
        (normalize "editor")
	(normalize "releaseinfo")
        (normalize "copyright")
	(normalize "revhistory")
	(normalize "abstract")
        (normalize "legalnotice")))

;; Returns the depth of auto TOC that should be made at the nd-level
(define (toc-depth nd)
;  (if (string=? (gi nd) (normalize "book"))
;      3
;      1))
  3)

;; Suppress default attributes for BODY
(define %body-attr%
  '())
;;  (list
;;   (list "BGCOLOR" "#FFFFFF")
;;   (list "TEXT" "#000000")))
</style-specification-body>
  </style-specification>
  
  <!-- print style sheet -->
  <style-specification id="print" use="print-stylesheet">
    <style-specification-body>
;; Name of paper type
; (define %paper-type% "USletter")
(define %paper-type% "A4")

;; Is two-sided output being produced?
(define %two-side% #t)

;; Make "bottom-of-page" footnotes?
(define bop-footnotes #t)

;; Factor used to calculate leading
(define %line-spacing-factor% 1.2)

;; Smaller font scaling factor
(define %smaller-size-factor% 0.8333)

;; Verbatim font scaling factor
(define %verbatim-size-factor% 0.8333)

;; Footnote font scaling factor
(define %footnote-size-factor% 0.8333)

;; Specify rules before and after an Example
(define %example-rules% #t)

;; Do formal objects float?
(define formal-object-float #t)

(define %honorific-punctuation% "") ; (1.42) don't add dot; add nothing

;; Display URLs after ULinks?
(define %show-ulinks% #f)

;; Allow automatic hyphenation?
(define %hyphenation% #t)  

(define %generate-article-toc% #t)

;; Are sections enumerated?
(define %section-autolabel% #t)

(define (article-titlepage-recto-elements)
  (list (normalize "title")
        (normalize "subtitle")
        (normalize "graphic")
        (normalize "date")
        (normalize "corpauthor")
        (normalize "authorgroup")
        (normalize "author")
        (normalize "orgname")
        (normalize "editor")
	(normalize "releaseinfo")
        (normalize "copyright")
	(normalize "revhistory")
	(normalize "abstract")
        (normalize "legalnotice")))

;; Returns the depth of auto TOC that should be made at the nd-level
(define (toc-depth nd)
;  (if (string=? (gi nd) (normalize "book"))
;      3
;      1))
  3)
</style-specification-body>
  </style-specification>

  <external-specification id="html-stylesheet" document="html-ss">
  <external-specification id="print-stylesheet" document="print-ss">
</style-sheet>
