/*
 * livepatch_bsc1229275
 *
 * Fix for CVE-2024-41057, bsc#1229275
 *
 *  Upstream commit:
 *  5d8f80578907 ("cachefiles: fix slab-use-after-free in cachefiles_withdraw_cookie()")
 *
 *  SLE12-SP5 commit:
 *  Not affected
 *
 *  SLE15-SP2 and -SP3 commit:
 *  Not affected
 *
 *  SLE15-SP4 and -SP5 commit:
 *  Not affected
 *
 *  SLE15-SP6 commit:
 *  a80ddf37de593817782ba4e0f8fe406dfe538c46
 *
 *  Copyright (c) 2024 SUSE
 *  Author: Marcos Paulo de Souza <mpdesouza@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "livepatch_bsc1229275.h"

int livepatch_bsc1229275_init(void)
{
	int ret;

	ret = bsc1229275_fs_cachefiles_cache_init();
	if (ret)
		return ret;

	ret = bsc1229275_fs_cachefiles_volume_init();
	if (ret)
		bsc1229275_fs_cachefiles_cache_cleanup();

	ret =  bsc1229275_fs_fscache_volume_init();
	if (ret) {
		bsc1229275_fs_cachefiles_volume_cleanup();
		bsc1229275_fs_cachefiles_cache_cleanup();
	}

	return ret;
}

void livepatch_bsc1229275_cleanup(void)
{
	bsc1229275_fs_fscache_volume_cleanup();
	bsc1229275_fs_cachefiles_cache_cleanup();
	bsc1229275_fs_cachefiles_volume_cleanup();
}
