#ifndef _BSC1226324_sock_h
#define _BSC1226324_sock_h

void klpp_ipv4_negative_advice(struct sock *sk,
			       struct dst_entry *dst);
void klpp_ip6_negative_advice(struct sock *sk,
			      struct dst_entry *dst);
void klpp_xfrm_negative_advice(struct sock *sk,
			       struct dst_entry *dst);

static inline void klpp___dst_negative_advice(struct sock *sk);
static inline void klpp_dst_negative_advice(struct sock *sk);

extern void (*klpe_ipv4_negative_advice)(struct dst_entry *dst);
extern void (*klpe_ip6_negative_advice)(struct dst_entry *dst);
extern void (*klpe_xfrm_negative_advice)(struct dst_entry *dst);

static inline void klpp___dst_negative_advice(struct sock *sk)
{
	struct dst_entry *dst = __sk_dst_get(sk);
	void *orig;

	if (!dst || !dst->ops->negative_advice)
		return;

	orig = dst->ops->negative_advice;

	if (orig == klpe_ipv4_negative_advice) {
		klpp_ipv4_negative_advice(sk, dst);
	} else if (orig == klpe_ip6_negative_advice) {
		klpp_ip6_negative_advice(sk, dst);
	} else if (orig == klpe_xfrm_negative_advice) {
		klpp_xfrm_negative_advice(sk, dst);
	} else {
		struct dst_entry *ndst;

		ndst = dst->ops->negative_advice(dst);

		if (ndst != dst) {
			rcu_assign_pointer(sk->sk_dst_cache, ndst);
			sk_tx_queue_clear(sk);
			sk->sk_dst_pending_confirm = 0;
		}
	}
}

static inline void klpp_dst_negative_advice(struct sock *sk)
{
	sk_rethink_txhash(sk);
	klpp___dst_negative_advice(sk);
}

#endif /* _BSC1226324_SOCK_H */
