#ifndef _LIVEPATCH_BSC1225429_H
#define _LIVEPATCH_BSC1225429_H

#include <linux/types.h>
#include <linux/netdevice.h>

int livepatch_bsc1225429_init(void);
static inline void livepatch_bsc1225429_cleanup(void) {}

struct genl_info;
struct ethnl_reply_data;
struct ethnl_req_info;

int klpp_ethnl_act_cable_test(struct sk_buff *skb, struct genl_info *info);
int klpp_ethnl_act_cable_test_tdr(struct sk_buff *skb, struct genl_info *info);

int klpp_channels_prepare_data(const struct ethnl_req_info *req_base,
                               struct ethnl_reply_data *reply_base,
                               struct genl_info *info);
int klpp_ethnl_set_channels(struct sk_buff *skb, struct genl_info *info);

int klpp_coalesce_prepare_data(const struct ethnl_req_info *req_base,
                               struct ethnl_reply_data *reply_base,
                               struct genl_info *info);
int klpp_ethnl_set_coalesce(struct sk_buff *skb, struct genl_info *info);

int klpp_debug_prepare_data(const struct ethnl_req_info *req_base,
                            struct ethnl_reply_data *reply_base,
                            struct genl_info *info);
int klpp_ethnl_set_debug(struct sk_buff *skb, struct genl_info *info);

int klpp_eee_prepare_data(const struct ethnl_req_info *req_base,
                          struct ethnl_reply_data *reply_base,
                          struct genl_info *info);
int klpp_ethnl_set_eee(struct sk_buff *skb, struct genl_info *info);

int klpp_eeprom_prepare_data(const struct ethnl_req_info *req_base,
                             struct ethnl_reply_data *reply_base,
                             struct genl_info *info);

int klpp_fec_prepare_data(const struct ethnl_req_info *req_base,
                          struct ethnl_reply_data *reply_base,
                          struct genl_info *info);
int klpp_ethnl_set_fec(struct sk_buff *skb, struct genl_info *info);

int klpp_linkinfo_prepare_data(const struct ethnl_req_info *req_base,
                               struct ethnl_reply_data *reply_base,
                               struct genl_info *info);
int klpp_ethnl_set_linkinfo(struct sk_buff *skb, struct genl_info *info);

int klpp_linkmodes_prepare_data(const struct ethnl_req_info *req_base,
                                struct ethnl_reply_data *reply_base,
                                struct genl_info *info);
int klpp_ethnl_set_linkmodes(struct sk_buff *skb, struct genl_info *info);

int klpp_linkstate_prepare_data(const struct ethnl_req_info *req_base,
                                struct ethnl_reply_data *reply_base,
                                struct genl_info *info);

int klpp_ethnl_parse_header_dev_get(struct ethnl_req_info *req_info,
                                    const struct nlattr *header, struct net *net,
                                    struct netlink_ext_ack *extack, bool require_dev);

int klpp_pause_prepare_data(const struct ethnl_req_info *req_base,
                            struct ethnl_reply_data *reply_base,
                            struct genl_info *info);
int klpp_ethnl_set_pause(struct sk_buff *skb, struct genl_info *info);

int klpp_wol_prepare_data(const struct ethnl_req_info *req_base,
                          struct ethnl_reply_data *reply_base,
                          struct genl_info *info);
int klpp_ethnl_set_wol(struct sk_buff *skb, struct genl_info *info);

int klpp_phc_vclocks_prepare_data(const struct ethnl_req_info *req_base,
                                  struct ethnl_reply_data *reply_base,
                                  struct genl_info *info);

int klpp_privflags_prepare_data(const struct ethnl_req_info *req_base,
                                struct ethnl_reply_data *reply_base,
                                struct genl_info *info);
int klpp_ethnl_set_privflags(struct sk_buff *skb, struct genl_info *info);

int klpp_rings_prepare_data(const struct ethnl_req_info *req_base,
                            struct ethnl_reply_data *reply_base,
                            struct genl_info *info);
int klpp_ethnl_set_rings(struct sk_buff *skb, struct genl_info *info);

int klpp_stats_prepare_data(const struct ethnl_req_info *req_base,
                            struct ethnl_reply_data *reply_base,
                            struct genl_info *info);

int klpp_strset_prepare_data(const struct ethnl_req_info *req_base,
                             struct ethnl_reply_data *reply_base,
                             struct genl_info *info);

int klpp_tsinfo_prepare_data(const struct ethnl_req_info *req_base,
                             struct ethnl_reply_data *reply_base,
                             struct genl_info *info);

#endif /* _LIVEPATCH_BSC1225429_H */
