/*
 * livepatch_bsc1225429
 *
 * Fix for CVE-2021-47517, bsc#1225429
 *
 *  Upstream commit:
 *  c5ab51df03e2 ("ethtool: move implementation of ethnl_ops_begin/complete to netlink.c")
 *  41107ac22fcf ("ethtool: move netif_device_present check from ethnl_parse_header_dev_get to ethnl_ops_begin")
 *  d43c65b05b84 ("ethtool: runtime-resume netdev parent in ethnl_ops_begin")
 *  596690e9f4fc ("ethtool: return error from ethnl_ops_begin if dev is NULL")
 *  dde91ccfa25f ("ethtool: do not perform operations on net devices being unregistered")
 *
 *  SLE12-SP5 commit:
 *  Not affected
 *
 *  SLE15-SP2 and -SP3 commit:
 *  Not affected
 *
 *  SLE15-SP4 and -SP5 commit:
 *  Not affected
 *
 *  SLE15-SP6 commit:
 *  Not affected
 *
 *  Copyright (c) 2024 SUSE
 *  Author: Fernando Gonzalez <fernando.gonzalez@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "livepatch_bsc1225429.h"

int bsc1225429_net_ethtool_cabletest_init(void);
int bsc1225429_net_ethtool_channels_init(void);
int bsc1225429_net_ethtool_debug_init(void);
int bsc1225429_net_ethtool_eee_init(void);
int bsc1225429_net_ethtool_eeprom_init(void);
int bsc1225429_net_ethtool_fec_init(void);
int bsc1225429_net_ethtool_linkmodes_init(void);
int bsc1225429_net_ethtool_linkstate_init(void);
int bsc1225429_net_ethtool_privflags_init(void);
int bsc1225429_net_ethtool_strset_init(void);
int bsc1225429_net_ethtool_tsinfo_init(void);
int bsc1225429_net_ethtool_wol_init(void);

int livepatch_bsc1225429_init(void)
{
	return bsc1225429_net_ethtool_cabletest_init() |
	       bsc1225429_net_ethtool_channels_init() |
	       bsc1225429_net_ethtool_debug_init() |
	       bsc1225429_net_ethtool_eee_init() |
	       bsc1225429_net_ethtool_eeprom_init() |
	       bsc1225429_net_ethtool_fec_init() |
	       bsc1225429_net_ethtool_linkmodes_init() |
	       bsc1225429_net_ethtool_linkstate_init() |
	       bsc1225429_net_ethtool_privflags_init() |
	       bsc1225429_net_ethtool_strset_init() |
	       bsc1225429_net_ethtool_tsinfo_init() |
	       bsc1225429_net_ethtool_wol_init();
}
