/*
 * bsc1225429_net_ethtool_phc_vclocks
 *
 * Fix for CVE-2021-47517, bsc#1225429
 *
 *  Copyright (c) 2024 SUSE
 *  Author: Fernando Gonzalez <fernando.gonzalez@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/* klp-ccp: from net/ethtool/netlink.h */
#include <linux/ethtool_netlink.h>

/* klp-ccp: from include/net/genetlink.h */
struct genl_info;
struct ethnl_req_info;

/* klp-ccp: from net/ethtool/netlink.h */

struct ethnl_reply_data {
	struct net_device		*dev;
};

void ethnl_ops_complete(struct net_device *dev);
int ethnl_ops_begin(struct net_device *dev);

/* klp-ccp: from net/ethtool/common.h */
#include <linux/ethtool.h>

/* klp-ccp: from net/ethtool/phc_vclocks.c */
struct phc_vclocks_reply_data {
	struct ethnl_reply_data		base;
	int				num;
	int				*index;
};

#define PHC_VCLOCKS_REPDATA(__reply_base) \
	container_of(__reply_base, struct phc_vclocks_reply_data, base)

int klpp_phc_vclocks_prepare_data(const struct ethnl_req_info *req_base,
				    struct ethnl_reply_data *reply_base,
				    struct genl_info *info)
{
	struct phc_vclocks_reply_data *data = PHC_VCLOCKS_REPDATA(reply_base);
	struct net_device *dev = reply_base->dev;
	int ret;

	ret = ethnl_ops_begin(dev);
	if (ret < 0)
		return ret;
	data->num = ethtool_get_phc_vclocks(dev, &data->index);
	ethnl_ops_complete(dev);

	return ret;
}
