/*
 * Unix SMB/CIFS implementation.
 *
 * mgmt RPC handlers
 *
 * Copyright (C) David Disseldorp	2013
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "includes.h"
#include "ntdomain.h"
#include "include/messages.h"
#include "include/auth.h"
#include "../libcli/security/security.h"
#include "../lib/tsocket/tsocket.h"
#include "../lib/util/tevent_ntstatus.h"
#include "../lib/smbconf/smbconf.h"
#include "smbd/proto.h"
#include "lib/smbconf/smbconf_init.h"
#include "librpc/gen_ndr/srv_mgmt.h"

#undef DBGC_CLASS
#define DBGC_CLASS DBGC_RPC_SRV

WERROR _mgmt_inq_if_ids(struct pipes_struct *p,
			struct mgmt_inq_if_ids *r)
{
	p->fault_state = DCERPC_FAULT_OP_RNG_ERROR;
	return WERR_NOT_SUPPORTED;
}

WERROR _mgmt_inq_stats(struct pipes_struct *p,
		       struct mgmt_inq_stats *r)
{
	p->fault_state = DCERPC_FAULT_OP_RNG_ERROR;
	return WERR_NOT_SUPPORTED;
}

uint32_t _mgmt_is_server_listening(struct pipes_struct *p,
				   struct mgmt_is_server_listening *r)
{
	*r->out.status = 0;
	return 1;
}

WERROR _mgmt_stop_server_listening(struct pipes_struct *p,
				   struct mgmt_stop_server_listening *r)
{
	p->fault_state = DCERPC_FAULT_OP_RNG_ERROR;
	return WERR_NOT_SUPPORTED;
}

WERROR _mgmt_inq_princ_name(struct pipes_struct *p,
			    struct mgmt_inq_princ_name *r)
{
	char *princ_name = discard_const_p(char, r->out.princ_name);
	/*
	 * Windows responds to WINNT with an empty string, and only handles
	 * GSS_NEG and GSS_KERBEROS as an AD member.
	 */

	if (r->in.authn_proto == DCERPC_AUTH_TYPE_NTLMSSP) {
		if (r->in.princ_name_size < 1) {
			return WERR_INSUFFICIENT_BUFFER;
		}
		princ_name = '\0';
	} else if ((lp_security() == SEC_ADS)
			&& ((r->in.authn_proto == DCERPC_AUTH_TYPE_SPNEGO)
			   || (r->in.authn_proto == DCERPC_AUTH_TYPE_KRB5))) {
		int ret;
		ret = snprintf(princ_name, r->in.princ_name_size, "%s$@%s",
			       lp_netbios_name(), lp_realm());
		if ((ret < 0) || (ret >= r->in.princ_name_size)) {
			return WERR_INSUFFICIENT_BUFFER;
		}
	} else {
		DEBUG(0, ("unsupported authn_proto %u\n",
			  (unsigned)r->in.authn_proto));
		return WERR_RPC_S_UNKNOWN_AUTHN_SERVICE;
	}

	DEBUG(6, ("returning principle name: %s\n", princ_name));

	return WERR_OK;
}
