/* from include/linux/tracepoint.h */

#include <linux/tracepoint.h>

#define KLPR___DECLARE_TRACE(name, proto, args, cond, data_proto, data_args) \
	static struct tracepoint (*klpe___tracepoint_##name); \
	static inline void klpr_trace_##name(proto) \
	{ \
		if (unlikely(static_key_enabled(&(*klpe___tracepoint_##name).key))) \
			__DO_TRACE(&(*klpe___tracepoint_##name), \
				TP_PROTO(data_proto), \
				TP_ARGS(data_args), \
				TP_CONDITION(cond), 0); \
		if (IS_ENABLED(CONFIG_LOCKDEP) && (cond)) { \
			rcu_read_lock_sched_notrace(); \
			rcu_dereference_sched((*klpe___tracepoint_##name).funcs); \
			rcu_read_unlock_sched_notrace(); \
		} \
	} \

#define KLPR_DECLARE_TRACE(name, proto, args) \
	KLPR___DECLARE_TRACE(name, PARAMS(proto), PARAMS(args), \
		cpu_online(raw_smp_processor_id()), \
		PARAMS(void *__data, proto), \
		PARAMS(__data, args))

#define KLPR_TRACE_EVENT(name, proto, args) \
	KLPR_DECLARE_TRACE(name, PARAMS(proto), PARAMS(args))

/* klp-ccp: from fs/nfsd/nfs4proc.c */
#define KLPR_NFSDDBG_FACILITY  NFSDDBG_PROC

#undef klpr_ifdebug
# define klpr_ifdebug(fac) if (unlikely((*klpe_nfsd_debug) & KLPR_NFSDDBG_##fac))

# define klpr_dfprintk(fac, fmt, ...)          \
do {                           \
	klpr_ifdebug(fac)               \
	printk(KERN_DEFAULT fmt, ##__VA_ARGS__);    \
} while (0)

#define klpr_dprintk(fmt, ...) \
	klpr_dfprintk(FACILITY, fmt, ##__VA_ARGS__)
