/*
 * livepatch_bsc1203067
 *
 * Fix for CVE-2022-39189, bsc#1203067
 *
 *  Upstream commit:
 *  6cd88243c7e0 ("KVM: x86: do not report a vCPU as preempted outside
 *                 instruction boundaries")
 *
 *  SLE12-SP4, SLE12-SP5, SLE15 and SLE15-SP1 commit:
 *  not affected
 *
 *  SLE15-SP2 and -SP3 commit:
 *  none yet
 *
 *  SLE15-SP4 commit:
 *  c89b7e4a1013683ee859abf761c754a4da16426e
 *
 *
 *  Copyright (c) 2022 SUSE
 *  Author: Nicolai Stange <nstange@suse.de>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#if IS_ENABLED(CONFIG_X86_64)

#include "livepatch_bsc1203067.h"
#include "bsc1203067_common.h"

int livepatch_bsc1203067_init(void)
{
	int ret;

	ret = bsc1203067_kvm_x86_init();
	if (ret)
		return ret;

	ret = bsc1203067_svm_init();
	if (ret) {
		bsc1203067_kvm_x86_cleanup();
		return ret;
	}

	ret = bsc1203067_vmx_init();
	if (ret) {
		bsc1203067_svm_cleanup();
		bsc1203067_kvm_x86_cleanup();
		return ret;
	}

	return 0;
}

void livepatch_bsc1203067_cleanup(void)
{
	bsc1203067_vmx_cleanup();
	bsc1203067_svm_cleanup();
	bsc1203067_kvm_x86_cleanup();
}

#endif /* IS_ENABLED(CONFIG_X86_64) */
