#ifndef _BSC1203067_COMMON_H
#define _BSC1203067_COMMON_H

int bsc1203067_kvm_x86_init(void);
void bsc1203067_kvm_x86_cleanup(void);

int bsc1203067_svm_init(void);
void bsc1203067_svm_cleanup(void);

int bsc1203067_vmx_init(void);
void bsc1203067_vmx_cleanup(void);

/* from include/linux/tracepoint.h */
#include <linux/tracepoint.h>
#define KLPR___DECLARE_TRACE(name, proto, args, cond, data_proto, data_args) \
	static struct tracepoint (*klpe___tracepoint_##name);		\
	static inline void klpr_trace_##name(proto)			\
	{								\
		if (unlikely(static_key_enabled(&(*klpe___tracepoint_##name).key))) \
			__DO_TRACE(&(*klpe___tracepoint_##name),	\
				TP_PROTO(data_proto),			\
				TP_ARGS(data_args),			\
				TP_CONDITION(cond), 0);		\
		if (IS_ENABLED(CONFIG_LOCKDEP) && (cond)) {		\
			rcu_read_lock_sched_notrace();			\
			rcu_dereference_sched((*klpe___tracepoint_##name).funcs); \
			rcu_read_unlock_sched_notrace();		\
		}							\
	}								\

#define KLPR_DECLARE_TRACE(name, proto, args)				\
	KLPR___DECLARE_TRACE(name, PARAMS(proto), PARAMS(args),		\
			cpu_online(raw_smp_processor_id()),		\
			PARAMS(void *__data, proto),			\
			PARAMS(__data, args))

#define KLPR_DEFINE_EVENT(template, name, proto, args)          \
	KLPR_DECLARE_TRACE(name, PARAMS(proto), PARAMS(args))

#define KLPR_TRACE_EVENT(name, proto, args)			\
	KLPR_DECLARE_TRACE(name, PARAMS(proto), PARAMS(args))

/* klp-ccp: from arch/x86/include/asm/kvm_host.h */
#define KLPP_HF_AT_INSN_BOUNDARY_MASK (1u << 30)

#endif /* _BSC1203067_COMMON_H */
