#ifndef _LIVEPATCH_BSC1200059_H
#define _LIVEPATCH_BSC1200059_H

#if IS_ENABLED(CONFIG_KGDB)

int livepatch_bsc1200059_init(void);
void livepatch_bsc1200059_cleanup(void);


#include <linux/kdb.h>

struct kgdb_state;
struct pt_regs;

typedef enum {
	KDB_DB_BPT,	/* Breakpoint */
	KDB_DB_SS,	/* Single-step trap */
	KDB_DB_SSBPT,	/* Single step over breakpoint */
	KDB_DB_NOBPT	/* Spurious breakpoint */
} kdb_dbtrap_t;

int klpp_kgdb_cpu_enter(struct kgdb_state *ks, struct pt_regs *regs,
		int exception_state);

int klpp_kdb_main_loop(kdb_reason_t, kdb_reason_t,
			 int, kdb_dbtrap_t, struct pt_regs *);;

#else /* !IS_ENABLED(CONFIG_KGDB) */

static inline int livepatch_bsc1200059_init(void) { return 0; }
static inline void livepatch_bsc1200059_cleanup(void) {}

#endif /* IS_ENABLED(CONFIG_KGDB) */
#endif /* _LIVEPATCH_BSC1200059_H */
