# Kickstart file automatically generated by anaconda.

install
nfs --server=shell.boston.redhat.com --dir=/mnt/redhat/iso/f7-64
lang en_US.UTF-8
keyboard us
xconfig --startxonboot
network --device eth0 --bootproto dhcp --hostname manus.boston.redhat.com
rootpw --iscrypted $1$XfFmKil8$NyKJOMScsYgSE53j8/Lq51
firewall --enabled --port=22:tcp
authconfig --enableshadow --enablemd5
selinux --enforcing
timezone --utc America/New_York
bootloader --location=mbr --driveorder=sda,sdb --append="rhgb quiet"
# The following is the partition information you requested
# Note that any partitions you deleted are not expressed
# here so unless you clear all partitions first, this is
# not guaranteed to work
#clearpart --linux --drives=sda,sdb
#part /boot --fstype ext3 --size=100 --ondisk=sda
#part pv.27 --size=0 --grow --ondisk=sdb
#part pv.26 --size=0 --grow --ondisk=sda
#volgroup VolGroup00 --pesize=32768 pv.27 pv.26
#logvol / --fstype ext3 --name=LogVol00 --vgname=VolGroup00 --size=1024 --grow
#logvol swap --fstype swap --name=LogVol01 --vgname=VolGroup00 --size=1000 --grow --maxsize=1984

%packages
@office
@admin-tools
@editors
@system-tools
@japanese-support
@gnome-software-development
@text-internet
@x-software-development
@virtualization
@gnome-desktop
@core
@authoring-and-publishing
@irish-support
@base
@hardware-support
@games
@java
@java-development
@base-x
@graphics
@web-server
@ruby
@printing
@server-cfg
@development-libs
@development-tools
@sound-and-video
@graphical-internet
createrepo
festival
fuse
audit
perl-NKF
anthy
lynx
mesa-libGLU-devel
scribus
pax
bridge-utils
fonts-chinese
fonts-korean
fonts-japanese
libsane-hpaio
netpbm-progs
kdegraphics
apachetop
awstats
imake
jack-audio-connection-kit
-zsh
-zisofs-tools
-xdelta
-slrn
-ipw2200-firmware
-ipw2100-firmware
-zd1211-firmware
-iwlwifi-firmware
-synaptics
-dcraw
-gimp-help
-tux
-squid
-httpd-manual
-lockdev-devel
-expat-devel
-cyrus-sasl-devel
-gpm-devel
-pciutils-devel
-kudzu-devel
-openldap-devel
-db4-devel
-gmp-devel
-openssl-devel
-curl-devel
-coolkey-devel
-boost-devel
-libcap-devel
-gdbm-devel
-libacl-devel
-libattr-devel
-binutils-devel
-krb5-devel
-libuser-devel
-hesiod-devel
-libogg-devel
-pcsc-lite-devel
-libvorbis-devel
-krbafs-devel
-ltrace
-python-ldap
-byacc
-frysk
-gcc-gfortran
-rcs
-ccache
-swig
-pstack
-cscope
-icedax
-sox

%pre

#!/bin/sh

hds=""
mymedia=""

for file in /proc/ide/h*
do
  mymedia=`cat $file/media`
  if [ $mymedia == "disk" ] ; then
      hds="$hds `basename $file`"
  fi
done

set $hds
numhd=`echo $#`

drive1=`echo $hds | cut -d' ' -f1`
drive2=`echo $hds | cut -d' ' -f2`

#Write out partition scheme based on whether there are 1 or 2 hard drives

if [ $numhd == "2" ] ; then
  #2 drives
  echo "#partitioning scheme generated in %pre for 2 drives" > /tmp/part-include
  echo "clearpart --all" >> /tmp/part-include
  echo "part /boot --fstype ext3 --size 75 --ondisk hda" >> /tmp/part-include
  echo "part / --fstype ext3 --size 1 --grow --ondisk hda" >> /tmp/part-include
  echo "part swap --recommended --ondisk $drive1" >> /tmp/part-include
  echo "part /home --fstype ext3 --size 1 --grow --ondisk hdb" >> /tmp/part-include
else
  #1 drive
  echo "#partitioning scheme generated in %pre for 1 drive" > /tmp/part-include
  echo "clearpart --all" >> /tmp/part-include
  echo "part /boot --fstype ext3 --size 75" >> /tmp/part-includ
  echo "part swap --recommended" >> /tmp/part-include
  echo "part / --fstype ext3 --size 2048" >> /tmp/part-include
  echo "part /home --fstype ext3 --size 2048 --grow" >> /tmp/part-include
fi