/**
 * Copyright (c) 2009--2010 Red Hat, Inc.
 *
 * This software is licensed to you under the GNU General Public License,
 * version 2 (GPLv2). There is NO WARRANTY for this software, express or
 * implied, including the implied warranties of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. You should have received a copy of GPLv2
 * along with this software; if not, see
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt.
 *
 * Red Hat trademarks are not licensed under GPLv2. No permission is
 * granted to use or replicate Red Hat trademarks that are incorporated
 * in this software or its documentation.
 */
package com.redhat.rhn.frontend.action.user;

import com.redhat.rhn.domain.user.User;
import com.redhat.rhn.frontend.struts.RequestContext;
import com.redhat.rhn.frontend.struts.RhnAction;
import com.redhat.rhn.frontend.struts.RhnHelper;
import com.redhat.rhn.frontend.struts.StrutsDelegate;
import com.redhat.rhn.manager.user.UserManager;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Change e-mail
 * @version $Rev: 1202 $
 */
public class ChangeEmailAction extends RhnAction {
    /** {@inheritDoc} */
    public ActionForward execute(ActionMapping mapping,
                                 ActionForm formIn,
                                 HttpServletRequest request,
                                 HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)formIn;

        ActionErrors errors = new ActionErrors();
        RequestContext requestContext = new RequestContext(request);
        StrutsDelegate strutsDelegate = getStrutsDelegate();

        User user = UserManager.lookupUser(requestContext.getCurrentUser(),
                requestContext.getParamAsLong("uid"));
        request.setAttribute(RhnHelper.TARGET_USER, user);
        if (user == null) {
            user = requestContext.getCurrentUser();
        }

        String email = user.getEmail();
        String newEmail = (String)form.get("email");

        if (!email.equals(newEmail)) {
            try {
                validateAddress(newEmail, errors);
                if (errors.isEmpty()) {
                    user.setEmail(newEmail);
                    UserManager.storeUser(user);
                    ActionMessages msgs = new ActionMessages();
                    msgs.add(ActionMessages.GLOBAL_MESSAGE,
                        new ActionMessage("email.verified"));
                    strutsDelegate.saveMessages(request, msgs);

                    return strutsDelegate.forwardParam(mapping.findForward("updated"),
                        "uid", user.getId().toString());
               }
            }
            catch (AddressException e) {
                errors.add(ActionMessages.GLOBAL_MESSAGE,
                           new ActionMessage("error.addr_invalid", newEmail));
            }
        }
        else if (email.equals(newEmail)) {
            errors.add(ActionMessages.GLOBAL_MESSAGE,
                       new ActionMessage("error.same_email"));
        }

        //If it got this far, something went wrong
        addErrors(request, errors);
        return strutsDelegate.forwardParam(mapping.findForward("failure"),
                "uid", user.getId().toString());
    }

    /**
     * Validates the given email.
     * @param email Email address to be validated
     * @see javax.mail.internet.InternetAddress
     * @exception AddressException thrown if email does not pass validation.
     */
    private void validateAddress(String email, ActionErrors errors)
                             throws AddressException {
        try {
            new InternetAddress(email).validate();
        }
        catch (AddressException e) {
            errors.add(ActionMessages.GLOBAL_MESSAGE,
                    new ActionMessage("error.addr_invalid", email));
        }
    }
}
