/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.helpers;

import com.mockobjects.helpers.AbstractServletTestHelper;
import com.mockobjects.servlet.MockBodyContent;
import com.mockobjects.servlet.MockJspWriter;
import com.mockobjects.servlet.MockPageContext;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;
import junit.framework.Assert;

public class TagTestHelper
extends AbstractServletTestHelper {
    private final MockPageContext pageContext = new MockPageContext();
    private final MockBodyContent bodyContent = new MockBodyContent();
    private final MockJspWriter outWriter = new MockJspWriter();
    private final MockJspWriter enclosingWriter = new MockJspWriter();
    private final Tag testSubject;

    private final String getReturnValueName(int returnValue) {
        switch (returnValue) {
            case 1: {
                return "EVAL_BODY_INCLUDE";
            }
            case 6: {
                return "EVAL_PAGE";
            }
            case 0: {
                return "SKIP_BODY";
            }
            case 5: {
                return "SKIP_PAGE";
            }
            case 2: {
                return "EVAL_BODY_BUFFERED|EVAL_BODY_AGAIN";
            }
        }
        return "Unknown return value (" + returnValue + ")";
    }

    public TagTestHelper(Tag testSubject) {
        this.testSubject = testSubject;
        this.pageContext.setRequest((ServletRequest)this.getRequest());
        this.pageContext.setServletContext(this.getServletContext());
        this.pageContext.setSession(this.getHttpSession());
        this.pageContext.setJspWriter(this.outWriter);
        this.bodyContent.setupGetEnclosingWriter(this.enclosingWriter);
    }

    public MockJspWriter getOutWriter() {
        return this.outWriter;
    }

    public MockPageContext getPageContext() {
        return this.pageContext;
    }

    public void assertDoStartTag(int expectedValue) throws JspException {
        this.testSubject.setPageContext((PageContext)this.pageContext);
        this.checkReturnValue("doStartTag", expectedValue, this.testSubject.doStartTag());
    }

    private final void checkReturnValue(String methodName, int expectedValue, int returnValue) {
        Assert.assertEquals((String)(methodName + " expected value " + this.getReturnValueName(expectedValue) + " but was " + this.getReturnValueName(returnValue)), (int)expectedValue, (int)returnValue);
    }

    public void testDoInitBody() throws JspException {
        Assert.assertTrue((String)"doInitBody should not be called as test subject not an instance of BodyTag", (boolean)(this.testSubject instanceof BodyTag));
        ((BodyTag)this.testSubject).setBodyContent((BodyContent)this.bodyContent);
        ((BodyTag)this.testSubject).doInitBody();
    }

    public void assertDoAfterBody(int expectedValue) throws JspException {
        Assert.assertTrue((String)"doAfterTag should not be called as test subject not an instance of IterationTag", (boolean)(this.testSubject instanceof IterationTag));
        this.checkReturnValue("doAfterTag", expectedValue, ((IterationTag)this.testSubject).doAfterBody());
    }

    public void assertDoEndTag(int expectedValue) throws JspException {
        Assert.assertEquals((String)("doEndTag returned unexpected value" + this.getReturnValueName(expectedValue)), (int)expectedValue, (int)this.testSubject.doEndTag());
    }
}

