/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects;

import com.mockobjects.AbstractExpectation;
import com.mockobjects.ExpectationCollection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractExpectationCollection
extends AbstractExpectation
implements ExpectationCollection {
    public AbstractExpectationCollection(String name) {
        super(name);
    }

    public void addActual(Object actualItem) {
        this.getActualCollection().add(actualItem);
        if (this.shouldCheckImmediately()) {
            this.checkImmediateValues(actualItem);
        }
    }

    public void addActual(int actualItem) {
        this.addActual(new Integer(actualItem));
    }

    public void addActualMany(Object[] items) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            this.addActual(items[i]);
        }
    }

    public void addActualMany(Enumeration items) {
        while (items.hasMoreElements()) {
            this.addActual(items.nextElement());
        }
    }

    public void addActualMany(Iterator items) {
        while (items.hasNext()) {
            this.addActual(items.next());
        }
    }

    public void addExpected(int expectedItem) {
        this.addExpected(new Integer(expectedItem));
    }

    public void addExpected(Object expectedItem) {
        this.getExpectedCollection().add(expectedItem);
        this.setHasExpectations();
    }

    public void addExpectedMany(Object[] expectedItems) {
        for (int i = 0; i < expectedItems.length; ++i) {
            this.addExpected(expectedItems[i]);
        }
        this.setHasExpectations();
    }

    public void addExpectedMany(Enumeration expectedItems) {
        while (expectedItems.hasMoreElements()) {
            this.addExpected(expectedItems.nextElement());
        }
        this.setHasExpectations();
    }

    public void addExpectedMany(Iterator expectedItems) {
        while (expectedItems.hasNext()) {
            this.addExpected(expectedItems.next());
        }
        this.setHasExpectations();
    }

    protected abstract void checkImmediateValues(Object var1);

    public void clearActual() {
        this.getActualCollection().clear();
    }

    protected void clearExpectation() {
        this.getExpectedCollection().clear();
    }

    protected abstract Collection getActualCollection();

    protected abstract Collection getExpectedCollection();

    public void setExpectNothing() {
        this.clearExpectation();
        this.setHasExpectations();
    }

    public void verify() {
        this.assertEquals("did not receive the expected collection items.", new HashSet(this.getExpectedCollection()), new HashSet(this.getActualCollection()));
    }
}

