/*
 * livepatch_bsc1195308
 *
 * Fix for CVE-2022-0435, bsc#1195308
 *
 *  Upstream commit:
 *  None yet
 *
 *  SLE12-SP3 commit:
 *  Not affected
 *
 *  SLE12-SP4, SLE12-SP5, SLE15 and SLE15-SP1 commit:
 *  eff4836bb29f91c4769857e032cbf019162cfdec
 *
 *  SLE15-SP2 and -SP3 commit:
 *  5e4e31ed176ccf5463049d4f4fa9eac9412667d7
 *
 *
 *  Copyright (c) 2022 SUSE
 *  Author: Nicolai Stange <nstange@suse.de>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#if !IS_MODULE(CONFIG_TIPC)
#error "Live patch supports only CONFIG_TIPC=m"
#endif

#include <linux/kernel.h>
#include <linux/module.h>
#include "livepatch_bsc1195308.h"
#include "bsc1195308_common.h"

int livepatch_bsc1195308_init(void)
{
	int ret;

	ret = livepatch_bsc1195308_monitor_init();
	if (ret)
		return ret;

	ret = livepatch_bsc1195308_link_init();
	if (ret) {
		livepatch_bsc1195308_monitor_cleanup();
		return ret;
	}

	return 0;
}

void livepatch_bsc1195308_cleanup(void)
{
	livepatch_bsc1195308_link_cleanup();
	livepatch_bsc1195308_monitor_cleanup();
}
