#ifndef BSC1195308_COMMON_H
#define BSC1195308_COMMON_H

int livepatch_bsc1195308_monitor_init(void);
void livepatch_bsc1195308_monitor_cleanup(void);

int livepatch_bsc1195308_link_init(void);
void livepatch_bsc1195308_link_cleanup(void);


/* klp-ccp: from net/tipc/core.h */
#include <linux/tipc.h>
#include <linux/string.h>
#include <linux/tipc_config.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/mm.h>
#include <linux/timer.h>
#include <linux/string.h>
#include <linux/uaccess.h>
#include <linux/interrupt.h>
#include <linux/atomic.h>
#include <linux/netdevice.h>
#include <linux/in.h>
#include <linux/list.h>
#include <linux/slab.h>
#include <linux/vmalloc.h>
#include <linux/rtnetlink.h>
#include <linux/etherdevice.h>
#include <net/netns/generic.h>
#include <net/genetlink.h>

#define NODE_HTABLE_SIZE       512
#define MAX_BEARERS	         3

#define NODE_ID_LEN             16
#define NODE_ID_STR_LEN        (NODE_ID_LEN * 2 + 1)

struct tipc_net {
	u8  node_id[NODE_ID_LEN];
	u32 node_addr;
	u32 trial_addr;
	unsigned long addr_trial_end;
	char node_id_string[NODE_ID_STR_LEN];
	int net_id;
	int random;
	bool legacy_addr_format;

	/* Node table and node list */
	spinlock_t node_list_lock;
	struct hlist_head node_htable[NODE_HTABLE_SIZE];
	struct list_head node_list;
	u32 num_nodes;
	u32 num_links;

	/* Neighbor monitoring list */
	struct tipc_monitor *monitors[MAX_BEARERS];
	int mon_threshold;

	/* Bearer list */
	struct tipc_bearer __rcu *bearer_list[MAX_BEARERS + 1];

	/* Broadcast link */
	spinlock_t bclock;
	struct tipc_bc_base *bcbase;
	struct tipc_link *bcl;

	/* Socket hash table */
	struct rhashtable sk_rht;

	/* Name table */
	spinlock_t nametbl_lock;
	struct name_table *nametbl;

	/* Name dist queue */
	struct list_head dist_queue;

	/* Topology subscription server */
	struct tipc_topsrv *topsrv;
	atomic_t subscription_count;

	/* Cluster capabilities */
	u16 capabilities;
};

static inline unsigned int tipc_hashfn(u32 addr)
{
	return addr & (NODE_HTABLE_SIZE - 1);
}

static inline u16 mod(u16 x)
{
	return x & 0xffffu;
}

static inline int less_eq(u16 left, u16 right)
{
	return mod(right - left) < 32768u;
}

static inline int more(u16 left, u16 right)
{
	return !less_eq(left, right);
}

static inline int less(u16 left, u16 right)
{
	return less_eq(left, right) && (mod(right) != mod(left));
}

static inline int in_range(u16 val, u16 min, u16 max)
{
	return !less(val, min) && !more(val, max);
}

/* klp-ccp: from net/tipc/link.h */
#include <net/genetlink.h>
/* klp-ccp: from net/tipc/msg.h */
#include <linux/tipc.h>

#define TIPC_MCAST_MSG          1

#define TIPC_GRP_MEMBER_EVT     4
#define TIPC_GRP_BCAST_MSG      5
#define TIPC_GRP_MCAST_MSG      6
#define TIPC_GRP_UCAST_MSG      7

#define  BCAST_PROTOCOL       5
#define  MSG_BUNDLER          6
#define  LINK_PROTOCOL        7
#define  CONN_MANAGER         8
#define  GROUP_PROTOCOL       9
#define  TUNNEL_PROTOCOL      10
#define  NAME_DISTRIBUTOR     11
#define  MSG_FRAGMENTER       12

#define MIN_H_SIZE                24	/* Smallest legal TIPC header size */

struct tipc_skb_cb {
	struct sk_buff *tail;
	unsigned long nxt_retr;
	unsigned long retr_stamp;
	u32 bytes_read;
	u32 orig_member;
	u16 chain_imp;
	u16 ackers;
	u16 retr_cnt;
	bool validated;
};

#define TIPC_SKB_CB(__skb) ((struct tipc_skb_cb *)&((__skb)->cb[0]))

struct tipc_msg {
	__be32 hdr[15];
};

struct tipc_gap_ack {
	__be16 ack;
	__be16 gap;
};

struct tipc_gap_ack_blks {
	__be16 len;
	u8 gack_cnt;
	u8 reserved;
	struct tipc_gap_ack gacks[];
};

#define tipc_gap_ack_blks_sz(n) (sizeof(struct tipc_gap_ack_blks) + \
				 sizeof(struct tipc_gap_ack) * (n))

static inline struct tipc_msg *buf_msg(struct sk_buff *skb)
{
	return (struct tipc_msg *)skb->data;
}

static inline u32 msg_word(struct tipc_msg *m, u32 pos)
{
	return ntohl(m->hdr[pos]);
}

static inline u32 msg_bits(struct tipc_msg *m, u32 w, u32 pos, u32 mask)
{
	return (msg_word(m, w) >> pos) & mask;
}

static inline void msg_set_bits(struct tipc_msg *m, u32 w,
				u32 pos, u32 mask, u32 val)
{
	val = (val & mask) << pos;
	mask = mask << pos;
	m->hdr[w] &= ~htonl(mask);
	m->hdr[w] |= htonl(val);
}

static inline u32 msg_user(struct tipc_msg *m)
{
	return msg_bits(m, 0, 25, 0xf);
}

static inline u32 msg_hdr_sz(struct tipc_msg *m)
{
	return msg_bits(m, 0, 21, 0xf) << 2;
}

static inline u32 msg_size(struct tipc_msg *m)
{
	return msg_bits(m, 0, 0, 0x1ffff);
}

static inline u32 msg_data_sz(struct tipc_msg *m)
{
	return msg_size(m) - msg_hdr_sz(m);
}

static inline unchar *msg_data(struct tipc_msg *m)
{
	return ((unchar *)m) + msg_hdr_sz(m);
}

static inline u32 msg_type(struct tipc_msg *m)
{
	return msg_bits(m, 1, 29, 0x7);
}

static inline int msg_in_group(struct tipc_msg *m)
{
	int mtyp = msg_type(m);

	return mtyp >= TIPC_GRP_MEMBER_EVT && mtyp <= TIPC_GRP_UCAST_MSG;
}

static inline u32 msg_mcast(struct tipc_msg *m)
{
	int mtyp = msg_type(m);

	return ((mtyp == TIPC_MCAST_MSG) || (mtyp == TIPC_GRP_BCAST_MSG) ||
		(mtyp == TIPC_GRP_MCAST_MSG));
}

static inline void msg_set_bcast_ack(struct tipc_msg *m, u16 n)
{
	msg_set_bits(m, 1, 0, 0xffff, n);
}

static inline bool msg_dest_session_valid(struct tipc_msg *m)
{
	return msg_bits(m, 1, 16, 0x1);
}

static inline u16 msg_dest_session(struct tipc_msg *m)
{
	return msg_bits(m, 1, 0, 0xffff);
}

static inline u16 msg_ack(struct tipc_msg *m)
{
	return msg_bits(m, 2, 16, 0xffff);
}

static inline void msg_set_ack(struct tipc_msg *m, u16 n)
{
	msg_set_bits(m, 2, 16, 0xffff, n);
}

static inline u16 msg_seqno(struct tipc_msg *m)
{
	return msg_bits(m, 2, 0, 0xffff);
}

static inline u32 msg_prevnode(struct tipc_msg *m)
{
	return msg_word(m, 3);
}

#define STATE_MSG		0
#define RESET_MSG		1
#define ACTIVATE_MSG		2

#define SYNCH_MSG		0

static inline u32 msg_seq_gap(struct tipc_msg *m)
{
	return msg_bits(m, 1, 16, 0x1fff);
}

static inline u16 msg_next_sent(struct tipc_msg *m)
{
	return msg_bits(m, 4, 0, 0xffff);
}

static inline u16 msg_session(struct tipc_msg *m)
{
	return msg_bits(m, 5, 16, 0xffff);
}

static inline u32 msg_probe(struct tipc_msg *m)
{
	return msg_bits(m, 5, 0, 1);
}

static inline char msg_net_plane(struct tipc_msg *m)
{
	return msg_bits(m, 5, 1, 7) + 'A';
}

static inline u32 msg_linkprio(struct tipc_msg *m)
{
	return msg_bits(m, 5, 4, 0x1f);
}

static inline u32 msg_bearer_id(struct tipc_msg *m)
{
	return msg_bits(m, 5, 9, 0x7);
}

static inline u32 msg_peer_stopping(struct tipc_msg *m)
{
	return msg_bits(m, 5, 13, 0x1);
}

static inline u32 msg_max_pkt(struct tipc_msg *m)
{
	return msg_bits(m, 9, 16, 0xffff) * 4;
}

static inline u32 msg_link_tolerance(struct tipc_msg *m)
{
	return msg_bits(m, 9, 0, 0xffff);
}

static inline u16 buf_seqno(struct sk_buff *skb)
{
	return msg_seqno(buf_msg(skb));
}

static inline struct sk_buff *__tipc_skb_dequeue(struct sk_buff_head *list,
						 u16 seqno)
{
	struct sk_buff *skb = skb_peek(list);

	if (skb && less_eq(buf_seqno(skb), seqno)) {
		__skb_unlink(skb, list);
		return skb;
	}
	return NULL;
}

/* klp-ccp: from net/tipc/addr.h */
#include <linux/types.h>
#include <linux/tipc.h>
#include <net/net_namespace.h>
#include <net/netns/generic.h>

/* klp-ccp: from net/tipc/net.h */
#include <net/genetlink.h>
/* klp-ccp: from net/tipc/netlink.h */
#include <net/netlink.h>
/* klp-ccp: from net/tipc/bearer.h */
#include <net/genetlink.h>

/* klp-ccp: from net/tipc/node.h */
enum {
	TIPC_SYN_BIT          = (1),
	TIPC_BCAST_SYNCH      = (1 << 1),
	TIPC_BCAST_STATE_NACK = (1 << 2),
	TIPC_BLOCK_FLOWCTL    = (1 << 3),
	TIPC_BCAST_RCAST      = (1 << 4),
	TIPC_NODE_ID128       = (1 << 5),
	TIPC_LINK_PROTO_SEQNO = (1 << 6),
	TIPC_MCAST_RBCTL      = (1 << 7),
	TIPC_GAP_ACK_BLOCK    = (1 << 8)
};

enum {
	LINK_ESTABLISH_EVT       = 0xec1ab1e,
	LINK_PEER_RESET_EVT      = 0x9eed0e,
	LINK_FAILURE_EVT         = 0xfa110e,
	LINK_RESET_EVT           = 0x10ca1d0e,
	LINK_FAILOVER_BEGIN_EVT  = 0xfa110bee,
	LINK_FAILOVER_END_EVT    = 0xfa110ede,
	LINK_SYNCH_BEGIN_EVT     = 0xc1ccbee,
	LINK_SYNCH_END_EVT       = 0xc1ccede
};

enum {
	TIPC_LINK_UP_EVT       = 1,
	TIPC_LINK_DOWN_EVT     = (1 << 1),
	TIPC_LINK_SND_STATE    = (1 << 2)
};

/* klp-ccp: from net/tipc/socket.h */
#include <net/sock.h>
#include <net/genetlink.h>

/* klp-ccp: from net/tipc/monitor.h */
struct tipc_mon_state {
	u16 list_gen;
	u16 peer_gen;
	u16 acked_gen;
	bool monitoring :1;
	bool probing    :1;
	bool reset      :1;
	bool synched    :1;
};

void klpp_tipc_mon_rcv(struct net *net, void *data, u16 dlen, u32 addr,
		  struct tipc_mon_state *state, int bearer_id);

#endif
