#ifndef _BSC1191813_COMMON_H
#define _BSC1191813_COMMON_H

#include <net/ip_fib.h>
#include <net/ip6_fib.h>

int livepatch_bsc1191813_ipv4_route_init(void);
void livepatch_bsc1191813_ipv4_route_cleanup(void);

int livepatch_bsc1191813_ipv6_route_init(void);
void livepatch_bsc1191813_ipv6_route_cleanup(void);


#define KLPP_EVICTION_HISTORY_SIZE 32

/*
 * Ringbuffer for recording the history of recent evictions for each
 * exception hash bucket.
 */
struct klpp_ipv4_eviction_history
{
	struct klpp_ipv4_history_entry {
		unsigned long expires;
		__be32 daddr;
	} entries[KLPP_EVICTION_HISTORY_SIZE];
	unsigned int head, tail;
};

struct klpp_ipv6_eviction_history
{
	struct klpp_ipv6_history_entry {
		unsigned long expires;
		struct in6_addr daddr;
	} entries[KLPP_EVICTION_HISTORY_SIZE];
	unsigned int head, tail;
};

struct klp_bsc1191813_shared_state
{
	unsigned long refcount;

	struct klpp_ipv4_eviction_history (*ipv4_eviction_history)[FNHE_HASH_SIZE];
	struct klpp_ipv6_eviction_history (*ipv6_eviction_history)[FIB6_EXCEPTION_BUCKET_SIZE];
};

extern struct klp_bsc1191813_shared_state *klp_bsc1191813_shared_state;

#endif
