#ifndef _LIVEPATCH_BSC1189418_H
#define _LIVEPATCH_BSC1189418_H

#if IS_ENABLED(CONFIG_KVM_AMD)

int livepatch_bsc1189418_init(void);
void livepatch_bsc1189418_cleanup(void);


struct vcpu_svm;
struct kvm_vcpu;
struct vmcb;
struct page;

void klpp_init_vmcb(struct vcpu_svm *svm);
void klpp_svm_set_cr0(struct kvm_vcpu *vcpu, unsigned long cr0);
void klpp_update_bp_intercept(struct kvm_vcpu *vcpu);
void klpp_svm_sync_dirty_debug_regs(struct kvm_vcpu *vcpu);
void klpp_enter_svm_guest_mode(struct vcpu_svm *svm, u64 vmcb_gpa,
				 struct vmcb *nested_vmcb, struct page *page);
int klpp_stgi_interception(struct vcpu_svm *svm);
int klpp_clgi_interception(struct vcpu_svm *svm);
int klpp_iret_interception(struct vcpu_svm *svm);
int klpp_dr_interception(struct vcpu_svm *svm);
int klpp_interrupt_window_interception(struct vcpu_svm *svm);
void klpp_svm_inject_nmi(struct kvm_vcpu *vcpu);
void klpp_update_cr8_intercept(struct kvm_vcpu *vcpu, int tpr, int irr);
void klpp_svm_set_nmi_mask(struct kvm_vcpu *vcpu, bool masked);
void klpp_enable_irq_window(struct kvm_vcpu *vcpu);
void klpp_enable_nmi_window(struct kvm_vcpu *vcpu);
int klpp_enable_smi_window(struct kvm_vcpu *vcpu);

#else /* !IS_ENABLED(CONFIG_KVM_AMD) */

static inline int livepatch_bsc1189418_init(void) { return 0; }

static inline void livepatch_bsc1189418_cleanup(void) {}

#endif /* IS_ENABLED(CONFIG_KVM_AMD) */
#endif /* _LIVEPATCH_BSC1189418_H */
