#!/bin/bash

# This script goes through all .crt files in this directory and stores
# them in EFI signature database format.

OUTPUT=vendor-dbx.bin

mkdir tmp

for cert in *.crt
do
	BASENAME=`basename $cert .crt`
	openssl x509 -in $cert -outform der -out tmp/${BASENAME}.der
	efisiglist -a -c tmp/${BASENAME}.der -o tmp/${BASENAME}.bin
done

cat tmp/*bin > $OUTPUT
rm -rf tmp
