/*
 * kgraft_patch_bsc1186235
 *
 * Fix for bsc#1186235
 *
 *  Upstream commit:
 *  not affected
 *
 *  SLE12-SP3 commit:
 *  none yet
 *
 *  SLE12-SP4, SLE12-SP5, SLE15 and SLE15-SP1 commit:
 *  not affected
 *
 *  SLE15-SP2 commit:
 *  not affected
 *
 *
 *  Copyright (c) 2021 SUSE
 *  Author: Nicolai Stange <nstange@suse.de>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/* klp-ccp: from kernel/kgraft_files.c */
#define pr_fmt(fmt) "kgr: " fmt

#include <linux/kernel.h>
#include <linux/kgraft.h>
#include <linux/kobject.h>
#include <linux/sysfs.h>

static inline struct kgr_patch *kobj_to_patch(struct kobject *kobj)
{
	return container_of(kobj, struct kgr_patch, kobj);
}

ssize_t kgrp_state_show(struct kobject *kobj, struct kobj_attribute *attr,
		char *buf)
{
	struct kgr_patch *p = kobj_to_patch(kobj);
	const struct kgr_patch_fun *pf;
	ssize_t size;
	/*
	 * Fix bsc#1186235
	 *  +1 line
	 */
	ssize_t needed;

	size = snprintf(buf, PAGE_SIZE, "%-20s  %-20s  Sympos  State\n",
		"Function", "Object");

	kgr_for_each_patch_fun(p, pf) {
		/*
		 * Fix bsc#1186235
		 *  -1 line, +1 line
		 */
		needed = snprintf(buf + size, PAGE_SIZE - size,
				"%-20s  %-20s  %6lu  %5d\n", pf->name,
				pf->objname ? pf->objname : "vmlinux",
				pf->sympos, pf->state);
		/*
		 * Fix bsc#1186235
		 *  +3 lines
		 */
		if (needed >= PAGE_SIZE - size)
			break;
		size += needed;
	}

	return size;
}
