CREATE OR REPLACE VIEW RHNSHAREDCHANNELVIEW
AS
SELECT 
   CH.ID,
   CH.PARENT_CHANNEL,
   CH.ORG_ID,
   CH.CHANNEL_ARCH_ID,
   CH.LABEL,
   CH.BASEDIR,
   CH.NAME,
   CH.SUMMARY,
   CH.DESCRIPTION,
   CH.PRODUCT_NAME_ID,
   CH.GPG_KEY_URL,
   CH.GPG_KEY_ID,
   CH.GPG_KEY_FP,
   CH.END_OF_LIFE,
   CH.RECEIVING_UPDATES,
   CH.LAST_MODIFIED,
   CH.CHANNEL_PRODUCT_ID,
   CH.CREATED,
   CH.MODIFIED,
   CH.CHANNEL_ACCESS,
   TR.ORG_TRUST_ID
FROM RHNCHANNEL CH,
     RHNTRUSTEDORGS TR
WHERE CH.ORG_ID = TR.ORG_ID AND
      CH.CHANNEL_ACCESS = 'public'
UNION
SELECT
   CH.ID,
   CH.PARENT_CHANNEL,
   CH.ORG_ID,
   CH.CHANNEL_ARCH_ID,
   CH.LABEL,
   CH.BASEDIR,
   CH.NAME,
   CH.SUMMARY,
   CH.DESCRIPTION,
   CH.PRODUCT_NAME_ID,
   CH.GPG_KEY_URL,
   CH.GPG_KEY_ID,
   CH.GPG_KEY_FP,
   CH.END_OF_LIFE,
   CH.RECEIVING_UPDATES,
   CH.LAST_MODIFIED,
   CH.CHANNEL_PRODUCT_ID,
   CH.CREATED,
   CH.MODIFIED,
   CH.CHANNEL_ACCESS,
   TR.ORG_TRUST_ID
FROM RHNCHANNEL CH,
     RHNCHANNELTRUST TR
WHERE CH.ID = TR.CHANNEL_ID
/
