// document.ready handler for cve-audit.jsp
$(document).on("ready", function() {
  // Init the popover help
  $("#cve-popover").popover({
    html: "true",
    delay: { show: 100, hide: 100 }
  }).click(function () {
    setTimeout(function () {
      $("#cve-popover").popover('hide');
    }, 10000);
  });

  // Add paste event handler
  $("#cveIdentifierId").on("paste", handlePasteEvent);
});

// Handle paste events
function handlePasteEvent() {
  // Empty the textfield first
  var idElem = document.getElementById("cveIdentifierId");
  idElem.value = "";

  // Get pasted text after it actually happened
  setTimeout(function () {
    var text = idElem.value;
    // See if it matches the regex
    var cveRegEx = /(\d{4})-(\d+)/i;
    var arr;
    if (arr = cveRegEx.exec(text)) {
      var yearElem = document.getElementById("cveIdentifierYear");
      var year = parseInt(arr[1]);
      var currentYear = new Date().getFullYear();
      // CVE identifiers exist since 1999
      if (year < 1999) {
        year = 1999;
      } else if (year > currentYear) {
        year = currentYear;
      }
      yearElem.value = year;
      idElem.value = arr[2];
    }
  }, 100);
}

