<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://rhn.redhat.com/rhn" prefix="rhn" %>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<html>
<body>

  <rhn:toolbar base="h1" icon="header-system-groups"
	           helpUrl="/rhn/help/user/en-US/s2-sm-monitor-psuites.jsp">
    <bean:message key="probesuitesystemsedit.jsp.header1" arg0="${probeSuite.suiteName}" />
  </rhn:toolbar>

<rhn:dialogmenu mindepth="0" maxdepth="1"
    definition="/WEB-INF/nav/probesuite_detail_edit.xml"
    renderer="com.redhat.rhn.frontend.nav.DialognavRenderer" />

<div>
  <p>
    <bean:message key="probesuitesystemsedit.jsp.summary"/>

    <form method="POST" name="rhn_list" action="/rhn/monitoring/config/ProbeSuiteSystemsEditSubmit.do">
    <rhn:csrf />
    <rhn:list pageList="${requestScope.pageList}" noDataText="probesuitesystemsedit.jsp.nosystems">
      <rhn:listdisplay filterBy="probesuitesystemsedit.jsp.systemname"
            set="${requestScope.set}"
        hiddenvars="${requestScope.newset}" >
        <rhn:set value="${current.id}" />
        <rhn:column header="probesuitesystems.jsp.system">
            <a href="/rhn/systems/details/probes/ProbesList.do?sid=${current.id}">${fn:escapeXml(current.name)}</a>
        </rhn:column>
      </rhn:listdisplay>
    </rhn:list>
    <html:hidden property="suite_id" value="${probeSuite.id}"/>
    <c:if test="${not empty pageList}">
      <div class="text-right">
        <hr /><bean:message key="probesuitesystemsedit.jsp.monscouttouse"/>
        <select name="satCluster">
          <c:forEach items="${satClusters}" var="cluster">
            <option value="${cluster.id}">${cluster.description}</option>
          </c:forEach>
        </select>&nbsp;
        <html:submit styleClass="btn btn-default" property="dispatch">
          <bean:message key="probesuitesystemsedit.jsp.addsystem"/>
        </html:submit>
      </div>
    </c:if>
    </form>
  </p>
</div>


</body>
</html>

