/**
 * Copyright (c) 2009--2013 Red Hat, Inc.
 *
 * This software is licensed to you under the GNU General Public License,
 * version 2 (GPLv2). There is NO WARRANTY for this software, express or
 * implied, including the implied warranties of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. You should have received a copy of GPLv2
 * along with this software; if not, see
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt.
 *
 * Red Hat trademarks are not licensed under GPLv2. No permission is
 * granted to use or replicate Red Hat trademarks that are incorporated
 * in this software or its documentation.
 */
package com.redhat.rhn.manager.task.test;

import com.redhat.rhn.domain.channel.Channel;
import com.redhat.rhn.domain.channel.test.ChannelFactoryTest;
import com.redhat.rhn.domain.errata.Errata;
import com.redhat.rhn.domain.errata.test.ErrataFactoryTest;
import com.redhat.rhn.domain.org.Org;
import com.redhat.rhn.domain.task.Task;
import com.redhat.rhn.domain.task.TaskFactory;
import com.redhat.rhn.manager.errata.ErrataManager;
import com.redhat.rhn.manager.task.TaskScheduler;
import com.redhat.rhn.testing.RhnBaseTestCase;
import com.redhat.rhn.testing.UserTestUtils;

import java.util.Date;
import java.util.Iterator;
import java.util.List;

/**
 * TaskSchedulerTest
 * @version $Rev$
 */
public class TaskSchedulerTest extends RhnBaseTestCase {

    public void testNull() throws Exception {
        // A null test until the one below is fixed.
    }

    public void aTestUpdateByChannel() throws Exception {
        Org org = UserTestUtils.findNewOrg("testorg");
        Errata e = ErrataFactoryTest.createTestErrata(org.getId());

        //add some channels
        Channel c1 = ChannelFactoryTest.createTestChannel(org);
        Channel c2 = ChannelFactoryTest.createTestChannel(org);
        e.addChannel(c1);
        e.addChannel(c2);

        ErrataManager.storeErrata(e);

        assertEquals(2, e.getChannels().size());

        List tasks = TaskFactory.getTaskListByChannel(org);

        TaskScheduler scheduler = new TaskScheduler(e, org);
        scheduler.updateByChannels();


        //Ok, we should have stuff in our list now...
        tasks = TaskFactory.getTaskListByChannel(org);
        assertTrue(tasks.size() >= 2);

        Task t = null;
        Date initialDate = null;
        Long data = null;

        // Need to loop through and find the right
        // task.  There may be others for other channels
        // sitting in the DB.
        Iterator i = tasks.iterator();
        while (i.hasNext()) {
            Task itask = (Task) i.next();
            if (itask.getData().equals(c1.getId())) {
                t = itask;
                initialDate = t.getEarliest();
                data = t.getData();
            }
        }

        //Now check the update part of the if clause in the updateByChannels method
        Thread.sleep(1000);
        scheduler.updateByChannels();


        tasks = TaskFactory.getTaskListByChannel(org);

        assertTrue(tasks.size() >= 2);

        t = (Task) tasks.toArray()[0];

        boolean found = false;
        i = tasks.iterator();
        while (i.hasNext()) {
            t = (Task) i.next();
            Date finalDate = t.getEarliest();
            if (t.getData().equals(data)) {
                found = true;
                // TODO: fix when we turn on errata post 410
                //assertTrue(finalDate.after(initialDate));
            }
        }
        assertTrue(found);

        /*
         * Now we can test the runChannelTasksNow method by running it and making sure
         * that both of the tasks earliest attribute are equal.
         */
        scheduler.runTasksByChannelNow();

        tasks = TaskFactory.getTaskListByChannel(org);

        Task t1 = (Task) tasks.toArray()[0];
        Task t2 = (Task) tasks.toArray()[1];

        assertNotNull(t1);
        assertNotNull(t2);
        // fixing build.  This test needs a little work :)  It's a problem
        // with the test not the code.
        //assertEquals(t1.getEarliest(), t2.getEarliest());
    }
}
