/**
 * Copyright (c) 2009--2011 Red Hat, Inc.
 *
 * This software is licensed to you under the GNU General Public License,
 * version 2 (GPLv2). There is NO WARRANTY for this software, express or
 * implied, including the implied warranties of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. You should have received a copy of GPLv2
 * along with this software; if not, see
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt.
 *
 * Red Hat trademarks are not licensed under GPLv2. No permission is
 * granted to use or replicate Red Hat trademarks that are incorporated
 * in this software or its documentation.
 */
package com.redhat.rhn.manager.system;

import com.redhat.rhn.common.RhnRuntimeException;
import com.redhat.rhn.domain.channel.ChannelArch;
import com.redhat.rhn.domain.rhnpackage.PackageArch;
import com.redhat.rhn.domain.server.ServerArch;

import java.util.List;

/**
 * IncompatibleArchException
 * @version $Rev$
 */
public class IncompatibleArchException extends RhnRuntimeException {

    // I long for the days of old when exceptions were autogenerated
    // and I didn't have to remember to fix javadoc comments.

    /**
     * Default ctor.
     * @param message exception message.
     */
    public IncompatibleArchException(String message) {
        super(message);
    }

    /**
     * Ctor
     * @param sa ServerArch which is incompatible with ChannelArch.
     * @param ca ChannelArch which is incompatible with ServerArch.
     */
    public IncompatibleArchException(ServerArch sa, ChannelArch ca) {
        this("The server architecture (" + sa.getName() + ") is incompatible " +
                "with the channel architecture (" + ca.getName() + ")");
    }

    /**
     * Ctor
     * @param pa PackageArch which is incompatible with ChannelArch.
     * @param ca ChannelArch which is incompatible with PackageArch.
     */
    public IncompatibleArchException(PackageArch pa, ChannelArch ca) {
        this("The package architecture (" + pa.getName() + ") is incompatible " +
                "with the channel architecture (" + ca.getName() + ")");
    }

    /**
     * Ctor
     * @param ca ChannelArch which is incompatible with PackageArch.
     * @param packageIds package ids incompatible with ChannelArch.
     */
    public IncompatibleArchException(ChannelArch ca, List<Long> packageIds) {
        this("Following package ids: " + packageIds + " are incompatible " +
                "with channel architecture (" + ca.getName() + ")");
    }
}
