/**
 * Copyright (c) 2014 SUSE LLC
 *
 * This software is licensed to you under the GNU General Public License,
 * version 2 (GPLv2). There is NO WARRANTY for this software, express or
 * implied, including the implied warranties of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. You should have received a copy of GPLv2
 * along with this software; if not, see
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt.
 *
 * Red Hat trademarks are not licensed under GPLv2. No permission is
 * granted to use or replicate Red Hat trademarks that are incorporated
 * in this software or its documentation.
 */
package com.redhat.rhn.frontend.action.renderers.setupwizard;

import com.redhat.rhn.common.validator.ValidatorError;
import com.redhat.rhn.domain.user.User;
import com.redhat.rhn.frontend.struts.RequestContext;
import com.redhat.rhn.manager.setup.ProxySettingsDto;
import com.redhat.rhn.manager.setup.ProxySettingsManager;
import com.redhat.rhn.manager.setup.SetupWizardSessionCache;

import org.apache.log4j.Logger;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;

import javax.servlet.http.HttpServletRequest;

/**
 * Exposes AJAX methods to work with proxy settings.
 */
public class ProxySettingsRenderer {

    /** Logger instance */
    private static Logger log = Logger.getLogger(ProxySettingsRenderer.class);

    /**
     * Save the given proxy settings to the configuration.
     * @param settings map with the keys hostname, username, password
     * @return saved settings
     */
    public ProxySettingsDto saveProxySettings(ProxySettingsDto settings) {
        ProxySettingsDto oldSettings = retrieveProxySettings();
        if (oldSettings.equals(settings)) {
            return settings;
        }

        // Find the current user
        WebContext webContext = WebContextFactory.get();
        HttpServletRequest request = webContext.getHttpServletRequest();
        RequestContext rhnContext = new RequestContext(request);
        User webUser = rhnContext.getCurrentUser();

        if (log.isDebugEnabled()) {
            log.debug("Saving proxy settings: " + settings.toString());
        }

        // TODO: Handle errors
        ValidatorError[] errors =
                ProxySettingsManager.storeProxySettings(settings, webUser, request);
        if (errors != null) {
            for (ValidatorError error : errors) {
                log.error("error: " + error.toString());
            }
        }
        return settings;
    }

    /**
     * Retrieve the proxy settings from configuration.
     * @return The current configured proxy settings
     */
    public ProxySettingsDto retrieveProxySettings() {
        return ProxySettingsManager.getProxySettings();
    }

    /**
     * Verify the configured proxy settings with NCC.
     * @param refreshCache used to force a cache refresh
     * @return true if the proxy works, false otherwise.
     */
    public boolean verifyProxySettings(boolean refreshCache) {
        WebContext webContext = WebContextFactory.get();
        HttpServletRequest request = webContext.getHttpServletRequest();
        return SetupWizardSessionCache.getProxyStatus(refreshCache, request);
    }
}
