#ifndef _KGR_PATCH_BSC1133191_MM_H
#define _KGR_PATCH_BSC1133191_MM_H

#include <linux/mm.h>

/* New */
static inline int kgr_page_ref_count(struct page *page)
{
	return atomic_read(&page->_count);
}

/* New */
static inline __must_check bool kgr_try_get_page(struct page *page)
{
	struct page *head = compound_head(page);

	/*
	 * get_page() increases always head page's refcount, either directly or
	 * via __get_page_tail() for tail page, so we check that
	 */
	if (WARN_ON_ONCE(kgr_page_ref_count(head) <= 0))
		return false;

	get_page(page);
	return true;
}

#endif /* _KGR_PATCH_BSC1133191_MM_H */
