; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=riscv32 | FileCheck %s --check-prefixes=RV32
; RUN: llc < %s -mtriple=riscv64 | FileCheck %s --check-prefixes=RV64

define signext i32 @test1(i32 signext %x) {
; RV32-LABEL: test1:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    ret
;
; RV64-LABEL: test1:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 1
; RV64-NEXT:    addi a0, a0, 1
; RV64-NEXT:    ret
  %a = shl i32 %x, 1
  %b = or i32 %a, 1
  ret i32 %b
}

define i64 @test2(i64 %x) {
; RV32-LABEL: test2:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a0, a0, -4
; RV32-NEXT:    addi a0, a0, 2
; RV32-NEXT:    ret
;
; RV64-LABEL: test2:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a0, a0, -4
; RV64-NEXT:    addi a0, a0, 2
; RV64-NEXT:    ret
  %a = and i64 %x, -4
  %b = or i64 %a, 2
  ret i64 %b
}

define signext i32 @test3(i32 signext %x) {
; RV32-LABEL: test3:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 3
; RV32-NEXT:    addi a0, a0, 6
; RV32-NEXT:    ret
;
; RV64-LABEL: test3:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 3
; RV64-NEXT:    addi a0, a0, 6
; RV64-NEXT:    ret
  %a = shl i32 %x, 3
  %b = add i32 %a, 6
  ret i32 %b
}

define i64 @test4(i64 %x) {
; RV32-LABEL: test4:
; RV32:       # %bb.0:
; RV32-NEXT:    srli a2, a0, 28
; RV32-NEXT:    slli a1, a1, 4
; RV32-NEXT:    or a1, a1, a2
; RV32-NEXT:    slli a0, a0, 4
; RV32-NEXT:    addi a0, a0, 13
; RV32-NEXT:    ret
;
; RV64-LABEL: test4:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 4
; RV64-NEXT:    addi a0, a0, 13
; RV64-NEXT:    ret
  %a = shl i64 %x, 4
  %b = add i64 %a, 13
  ret i64 %b
}

define signext i32 @test5(i32 signext %x) {
; RV32-LABEL: test5:
; RV32:       # %bb.0:
; RV32-NEXT:    srli a0, a0, 24
; RV32-NEXT:    addi a0, a0, 256
; RV32-NEXT:    ret
;
; RV64-LABEL: test5:
; RV64:       # %bb.0:
; RV64-NEXT:    srliw a0, a0, 24
; RV64-NEXT:    addi a0, a0, 256
; RV64-NEXT:    ret
  %a = lshr i32 %x, 24
  %b = xor i32 %a, 256
  ret i32 %b
}

define i64 @test6(i64 %x) {
; RV32-LABEL: test6:
; RV32:       # %bb.0:
; RV32-NEXT:    srli a1, a1, 22
; RV32-NEXT:    addi a0, a1, 1024
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test6:
; RV64:       # %bb.0:
; RV64-NEXT:    srli a0, a0, 54
; RV64-NEXT:    addi a0, a0, 1024
; RV64-NEXT:    ret
  %a = lshr i64 %x, 54
  %b = xor i64 %a, 1024
  ret i64 %b
}
