; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -global-isel=0 -mcpu=gfx1010 < %s | FileCheck %s --check-prefixes=CHECK,DAGISEL
; RUN: llc -march=amdgcn -global-isel=0 -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 < %s | FileCheck %s --check-prefixes=CHECK,DAGISEL
; RUN: llc -march=amdgcn -global-isel -mcpu=gfx1010 < %s | FileCheck %s --check-prefixes=CHECK,GISEL
; RUN: llc -march=amdgcn -global-isel -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 < %s | FileCheck %s --check-prefixes=CHECK,GISEL

declare i64 @llvm.amdgcn.ballot.i64(i1)
declare i64 @llvm.ctpop.i64(i64)

; Test ballot(0)

define amdgpu_cs i64 @constant_false() {
; CHECK-LABEL: constant_false:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_mov_b32 s0, 0
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    ; return to shader part epilog
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 0)
  ret i64 %ballot
}

; Test ballot(1)

define amdgpu_cs i64 @constant_true() {
; DAGISEL-LABEL: constant_true:
; DAGISEL:       ; %bb.0:
; DAGISEL-NEXT:    s_mov_b32 s0, exec_lo
; DAGISEL-NEXT:    s_mov_b32 s1, exec_hi
; DAGISEL-NEXT:    ; return to shader part epilog
;
; GISEL-LABEL: constant_true:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_mov_b32 s0, exec_lo
; GISEL-NEXT:    s_mov_b32 s1, 0
; GISEL-NEXT:    ; return to shader part epilog
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 1)
  ret i64 %ballot
}

; Test ballot of a non-comparison operation

define amdgpu_cs i64 @non_compare(i32 %x) {
; CHECK-LABEL: non_compare:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    v_and_b32_e32 v0, 1, v0
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    v_cmp_ne_u32_e64 s0, 0, v0
; CHECK-NEXT:    ; return to shader part epilog
  %trunc = trunc i32 %x to i1
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %trunc)
  ret i64 %ballot
}

; Test ballot of comparisons

define amdgpu_cs i64 @compare_ints(i32 %x, i32 %y) {
; CHECK-LABEL: compare_ints:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    v_cmp_eq_u32_e64 s0, v0, v1
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    ; return to shader part epilog
  %cmp = icmp eq i32 %x, %y
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %cmp)
  ret i64 %ballot
}

define amdgpu_cs i64 @compare_int_with_constant(i32 %x) {
; DAGISEL-LABEL: compare_int_with_constant:
; DAGISEL:       ; %bb.0:
; DAGISEL-NEXT:    v_cmp_lt_i32_e64 s0, 0x62, v0
; DAGISEL-NEXT:    s_mov_b32 s1, 0
; DAGISEL-NEXT:    ; return to shader part epilog
;
; GISEL-LABEL: compare_int_with_constant:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    v_cmp_le_i32_e64 s0, 0x63, v0
; GISEL-NEXT:    s_mov_b32 s1, 0
; GISEL-NEXT:    ; return to shader part epilog
  %cmp = icmp sge i32 %x, 99
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %cmp)
  ret i64 %ballot
}

define amdgpu_cs i64 @compare_floats(float %x, float %y) {
; CHECK-LABEL: compare_floats:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    v_cmp_gt_f32_e64 s0, v0, v1
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    ; return to shader part epilog
  %cmp = fcmp ogt float %x, %y
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %cmp)
  ret i64 %ballot
}

define amdgpu_cs i64 @ctpop_of_ballot(float %x, float %y) {
; CHECK-LABEL: ctpop_of_ballot:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    v_cmp_gt_f32_e64 s0, v0, v1
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; CHECK-NEXT:    ; return to shader part epilog
  %cmp = fcmp ogt float %x, %y
  %ballot = call i64 @llvm.amdgcn.ballot.i64(i1 %cmp)
  %bcnt = call i64 @llvm.ctpop.i64(i64 %ballot)
  ret i64 %bcnt
}
