; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu %s -o - | FileCheck %s

; When lowering the LLVM IR to MIR, transient COPY instructions are generated
; to copy parameters from physical registers to virtual registers. Wrong
; handling of transient instructions in MachineCombiner can fail the forllowing
; transformation.
;     A - (B + C)  ==>   (A - B) - C

; 32 bit version.
define i32 @test1(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: test1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub w8, w2, w0
; CHECK-NEXT:    eor w9, w1, w0, lsl #8
; CHECK-NEXT:    sub w8, w8, w9
; CHECK-NEXT:    eor w0, w8, w9, asr #13
; CHECK-NEXT:    ret
entry:
  %shl = shl i32 %a, 8
  %xor = xor i32 %shl, %b
  %add = add i32 %xor, %a
  %sub = sub i32 %c, %add
  %shr = ashr i32 %xor, 13
  %xor2 = xor i32 %sub, %shr
  ret i32 %xor2
}

; 64 bit version.
define i64 @test2(i64 %a, i64 %b, i64 %c) {
; CHECK-LABEL: test2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub x8, x2, x0
; CHECK-NEXT:    eor x9, x1, x0, lsl #8
; CHECK-NEXT:    sub x8, x8, x9
; CHECK-NEXT:    eor x0, x8, x9, asr #13
; CHECK-NEXT:    ret
entry:
  %shl = shl i64 %a, 8
  %xor = xor i64 %shl, %b
  %add = add i64 %xor, %a
  %sub = sub i64 %c, %add
  %shr = ashr i64 %xor, 13
  %xor2 = xor i64 %sub, %shr
  ret i64 %xor2
}
