// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(any(unix, feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(unix)))]
use crate::UnixFDList;
use crate::{
    AsyncInitable, AsyncResult, Cancellable, Credentials, DBusAuthObserver, DBusCallFlags,
    DBusCapabilityFlags, DBusConnectionFlags, DBusMessage, DBusSendMessageFlags, IOStream,
    Initable,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute, pin::Pin, ptr};

glib::wrapper! {
    #[doc(alias = "GDBusConnection")]
    pub struct DBusConnection(Object<ffi::GDBusConnection>) @implements AsyncInitable, Initable;

    match fn {
        type_ => || ffi::g_dbus_connection_get_type(),
    }
}

impl DBusConnection {
    #[doc(alias = "g_dbus_connection_new_for_address_sync")]
    #[doc(alias = "new_for_address_sync")]
    pub fn for_address_sync(
        address: &str,
        flags: DBusConnectionFlags,
        observer: Option<&DBusAuthObserver>,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<DBusConnection, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_connection_new_for_address_sync(
                address.to_glib_none().0,
                flags.into_glib(),
                observer.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_connection_new_sync")]
    pub fn new_sync(
        stream: &impl IsA<IOStream>,
        guid: Option<&str>,
        flags: DBusConnectionFlags,
        observer: Option<&DBusAuthObserver>,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<DBusConnection, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_connection_new_sync(
                stream.as_ref().to_glib_none().0,
                guid.to_glib_none().0,
                flags.into_glib(),
                observer.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_connection_call")]
    pub fn call<P: FnOnce(Result<glib::Variant, glib::Error>) + 'static>(
        &self,
        bus_name: Option<&str>,
        object_path: &str,
        interface_name: &str,
        method_name: &str,
        parameters: Option<&glib::Variant>,
        reply_type: Option<&glib::VariantTy>,
        flags: DBusCallFlags,
        timeout_msec: i32,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn call_trampoline<
            P: FnOnce(Result<glib::Variant, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_connection_call_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = call_trampoline::<P>;
        unsafe {
            ffi::g_dbus_connection_call(
                self.to_glib_none().0,
                bus_name.to_glib_none().0,
                object_path.to_glib_none().0,
                interface_name.to_glib_none().0,
                method_name.to_glib_none().0,
                parameters.to_glib_none().0,
                reply_type.to_glib_none().0,
                flags.into_glib(),
                timeout_msec,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn call_future(
        &self,
        bus_name: Option<&str>,
        object_path: &str,
        interface_name: &str,
        method_name: &str,
        parameters: Option<&glib::Variant>,
        reply_type: Option<&glib::VariantTy>,
        flags: DBusCallFlags,
        timeout_msec: i32,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<glib::Variant, glib::Error>> + 'static>>
    {
        let bus_name = bus_name.map(ToOwned::to_owned);
        let object_path = String::from(object_path);
        let interface_name = String::from(interface_name);
        let method_name = String::from(method_name);
        let parameters = parameters.map(ToOwned::to_owned);
        let reply_type = reply_type.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.call(
                    bus_name.as_ref().map(::std::borrow::Borrow::borrow),
                    &object_path,
                    &interface_name,
                    &method_name,
                    parameters.as_ref().map(::std::borrow::Borrow::borrow),
                    reply_type.as_ref().map(::std::borrow::Borrow::borrow),
                    flags,
                    timeout_msec,
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    #[doc(alias = "g_dbus_connection_call_sync")]
    pub fn call_sync(
        &self,
        bus_name: Option<&str>,
        object_path: &str,
        interface_name: &str,
        method_name: &str,
        parameters: Option<&glib::Variant>,
        reply_type: Option<&glib::VariantTy>,
        flags: DBusCallFlags,
        timeout_msec: i32,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<glib::Variant, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_connection_call_sync(
                self.to_glib_none().0,
                bus_name.to_glib_none().0,
                object_path.to_glib_none().0,
                interface_name.to_glib_none().0,
                method_name.to_glib_none().0,
                parameters.to_glib_none().0,
                reply_type.to_glib_none().0,
                flags.into_glib(),
                timeout_msec,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(unix, feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(unix)))]
    #[doc(alias = "g_dbus_connection_call_with_unix_fd_list")]
    pub fn call_with_unix_fd_list<
        P: FnOnce(Result<(glib::Variant, UnixFDList), glib::Error>) + 'static,
    >(
        &self,
        bus_name: Option<&str>,
        object_path: &str,
        interface_name: &str,
        method_name: &str,
        parameters: Option<&glib::Variant>,
        reply_type: Option<&glib::VariantTy>,
        flags: DBusCallFlags,
        timeout_msec: i32,
        fd_list: Option<&impl IsA<UnixFDList>>,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn call_with_unix_fd_list_trampoline<
            P: FnOnce(Result<(glib::Variant, UnixFDList), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let mut out_fd_list = ptr::null_mut();
            let ret = ffi::g_dbus_connection_call_with_unix_fd_list_finish(
                _source_object as *mut _,
                &mut out_fd_list,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok((from_glib_full(ret), from_glib_full(out_fd_list)))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = call_with_unix_fd_list_trampoline::<P>;
        unsafe {
            ffi::g_dbus_connection_call_with_unix_fd_list(
                self.to_glib_none().0,
                bus_name.to_glib_none().0,
                object_path.to_glib_none().0,
                interface_name.to_glib_none().0,
                method_name.to_glib_none().0,
                parameters.to_glib_none().0,
                reply_type.to_glib_none().0,
                flags.into_glib(),
                timeout_msec,
                fd_list.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg(any(unix, feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(unix)))]
    pub fn call_with_unix_fd_list_future(
        &self,
        bus_name: Option<&str>,
        object_path: &str,
        interface_name: &str,
        method_name: &str,
        parameters: Option<&glib::Variant>,
        reply_type: Option<&glib::VariantTy>,
        flags: DBusCallFlags,
        timeout_msec: i32,
        fd_list: Option<&(impl IsA<UnixFDList> + Clone + 'static)>,
    ) -> Pin<
        Box_<
            dyn std::future::Future<Output = Result<(glib::Variant, UnixFDList), glib::Error>>
                + 'static,
        >,
    > {
        let bus_name = bus_name.map(ToOwned::to_owned);
        let object_path = String::from(object_path);
        let interface_name = String::from(interface_name);
        let method_name = String::from(method_name);
        let parameters = parameters.map(ToOwned::to_owned);
        let reply_type = reply_type.map(ToOwned::to_owned);
        let fd_list = fd_list.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.call_with_unix_fd_list(
                    bus_name.as_ref().map(::std::borrow::Borrow::borrow),
                    &object_path,
                    &interface_name,
                    &method_name,
                    parameters.as_ref().map(::std::borrow::Borrow::borrow),
                    reply_type.as_ref().map(::std::borrow::Borrow::borrow),
                    flags,
                    timeout_msec,
                    fd_list.as_ref().map(::std::borrow::Borrow::borrow),
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    #[cfg(any(unix, feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(unix)))]
    #[doc(alias = "g_dbus_connection_call_with_unix_fd_list_sync")]
    pub fn call_with_unix_fd_list_sync(
        &self,
        bus_name: Option<&str>,
        object_path: &str,
        interface_name: &str,
        method_name: &str,
        parameters: Option<&glib::Variant>,
        reply_type: Option<&glib::VariantTy>,
        flags: DBusCallFlags,
        timeout_msec: i32,
        fd_list: Option<&impl IsA<UnixFDList>>,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<(glib::Variant, UnixFDList), glib::Error> {
        unsafe {
            let mut out_fd_list = ptr::null_mut();
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_connection_call_with_unix_fd_list_sync(
                self.to_glib_none().0,
                bus_name.to_glib_none().0,
                object_path.to_glib_none().0,
                interface_name.to_glib_none().0,
                method_name.to_glib_none().0,
                parameters.to_glib_none().0,
                reply_type.to_glib_none().0,
                flags.into_glib(),
                timeout_msec,
                fd_list.map(|p| p.as_ref()).to_glib_none().0,
                &mut out_fd_list,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok((from_glib_full(ret), from_glib_full(out_fd_list)))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_connection_close")]
    pub fn close<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn close_trampoline<P: FnOnce(Result<(), glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_dbus_connection_close_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = close_trampoline::<P>;
        unsafe {
            ffi::g_dbus_connection_close(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn close_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.close(Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    #[doc(alias = "g_dbus_connection_close_sync")]
    pub fn close_sync(
        &self,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::g_dbus_connection_close_sync(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_connection_emit_signal")]
    pub fn emit_signal(
        &self,
        destination_bus_name: Option<&str>,
        object_path: &str,
        interface_name: &str,
        signal_name: &str,
        parameters: Option<&glib::Variant>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::g_dbus_connection_emit_signal(
                self.to_glib_none().0,
                destination_bus_name.to_glib_none().0,
                object_path.to_glib_none().0,
                interface_name.to_glib_none().0,
                signal_name.to_glib_none().0,
                parameters.to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_connection_flush")]
    pub fn flush<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn flush_trampoline<P: FnOnce(Result<(), glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_dbus_connection_flush_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = flush_trampoline::<P>;
        unsafe {
            ffi::g_dbus_connection_flush(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn flush_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.flush(Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    #[doc(alias = "g_dbus_connection_flush_sync")]
    pub fn flush_sync(
        &self,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::g_dbus_connection_flush_sync(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_connection_get_capabilities")]
    #[doc(alias = "get_capabilities")]
    pub fn capabilities(&self) -> DBusCapabilityFlags {
        unsafe {
            from_glib(ffi::g_dbus_connection_get_capabilities(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_connection_get_exit_on_close")]
    #[doc(alias = "get_exit_on_close")]
    pub fn exits_on_close(&self) -> bool {
        unsafe {
            from_glib(ffi::g_dbus_connection_get_exit_on_close(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v2_60", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_60")))]
    #[doc(alias = "g_dbus_connection_get_flags")]
    #[doc(alias = "get_flags")]
    pub fn flags(&self) -> DBusConnectionFlags {
        unsafe { from_glib(ffi::g_dbus_connection_get_flags(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_connection_get_guid")]
    #[doc(alias = "get_guid")]
    pub fn guid(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::g_dbus_connection_get_guid(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_connection_get_last_serial")]
    #[doc(alias = "get_last_serial")]
    pub fn last_serial(&self) -> u32 {
        unsafe { ffi::g_dbus_connection_get_last_serial(self.to_glib_none().0) }
    }

    #[doc(alias = "g_dbus_connection_get_peer_credentials")]
    #[doc(alias = "get_peer_credentials")]
    pub fn peer_credentials(&self) -> Option<Credentials> {
        unsafe {
            from_glib_none(ffi::g_dbus_connection_get_peer_credentials(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_connection_get_stream")]
    #[doc(alias = "get_stream")]
    pub fn stream(&self) -> IOStream {
        unsafe { from_glib_none(ffi::g_dbus_connection_get_stream(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_connection_get_unique_name")]
    #[doc(alias = "get_unique_name")]
    pub fn unique_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_dbus_connection_get_unique_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_connection_is_closed")]
    pub fn is_closed(&self) -> bool {
        unsafe { from_glib(ffi::g_dbus_connection_is_closed(self.to_glib_none().0)) }
    }

    //#[doc(alias = "g_dbus_connection_register_object")]
    //pub fn register_object(&self, object_path: &str, interface_info: &DBusInterfaceInfo, vtable: /*Ignored*/Option<&DBusInterfaceVTable>, user_data: /*Unimplemented*/Option<Basic: Pointer>) -> Result<(), glib::Error> {
    //    unsafe { TODO: call ffi:g_dbus_connection_register_object() }
    //}

    #[doc(alias = "g_dbus_connection_send_message")]
    pub fn send_message(
        &self,
        message: &DBusMessage,
        flags: DBusSendMessageFlags,
    ) -> Result<u32, glib::Error> {
        unsafe {
            let mut out_serial = mem::MaybeUninit::uninit();
            let mut error = ptr::null_mut();
            let is_ok = ffi::g_dbus_connection_send_message(
                self.to_glib_none().0,
                message.to_glib_none().0,
                flags.into_glib(),
                out_serial.as_mut_ptr(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(out_serial.assume_init())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_connection_send_message_with_reply")]
    pub fn send_message_with_reply<P: FnOnce(Result<DBusMessage, glib::Error>) + 'static>(
        &self,
        message: &DBusMessage,
        flags: DBusSendMessageFlags,
        timeout_msec: i32,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) -> u32 {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn send_message_with_reply_trampoline<
            P: FnOnce(Result<DBusMessage, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_connection_send_message_with_reply_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = send_message_with_reply_trampoline::<P>;
        unsafe {
            let mut out_serial = mem::MaybeUninit::uninit();
            ffi::g_dbus_connection_send_message_with_reply(
                self.to_glib_none().0,
                message.to_glib_none().0,
                flags.into_glib(),
                timeout_msec,
                out_serial.as_mut_ptr(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
            out_serial.assume_init()
        }
    }

    pub fn send_message_with_reply_future(
        &self,
        message: &DBusMessage,
        flags: DBusSendMessageFlags,
        timeout_msec: i32,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<DBusMessage, glib::Error>> + 'static>>
    {
        let message = message.clone();
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.send_message_with_reply(
                    &message,
                    flags,
                    timeout_msec,
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    #[doc(alias = "g_dbus_connection_send_message_with_reply_sync")]
    pub fn send_message_with_reply_sync(
        &self,
        message: &DBusMessage,
        flags: DBusSendMessageFlags,
        timeout_msec: i32,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<(DBusMessage, u32), glib::Error> {
        unsafe {
            let mut out_serial = mem::MaybeUninit::uninit();
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_connection_send_message_with_reply_sync(
                self.to_glib_none().0,
                message.to_glib_none().0,
                flags.into_glib(),
                timeout_msec,
                out_serial.as_mut_ptr(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok((from_glib_full(ret), out_serial.assume_init()))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_connection_set_exit_on_close")]
    pub fn set_exit_on_close(&self, exit_on_close: bool) {
        unsafe {
            ffi::g_dbus_connection_set_exit_on_close(
                self.to_glib_none().0,
                exit_on_close.into_glib(),
            );
        }
    }

    #[doc(alias = "g_dbus_connection_start_message_processing")]
    pub fn start_message_processing(&self) {
        unsafe {
            ffi::g_dbus_connection_start_message_processing(self.to_glib_none().0);
        }
    }

    pub fn get_property_flags(&self) -> DBusConnectionFlags {
        glib::ObjectExt::property(self, "flags")
    }

    #[doc(alias = "g_dbus_connection_new")]
    pub fn new<P: FnOnce(Result<DBusConnection, glib::Error>) + 'static>(
        stream: &impl IsA<IOStream>,
        guid: Option<&str>,
        flags: DBusConnectionFlags,
        observer: Option<&DBusAuthObserver>,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn new_trampoline<
            P: FnOnce(Result<DBusConnection, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_connection_new_finish(res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = new_trampoline::<P>;
        unsafe {
            ffi::g_dbus_connection_new(
                stream.as_ref().to_glib_none().0,
                guid.to_glib_none().0,
                flags.into_glib(),
                observer.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn new_future(
        stream: &(impl IsA<IOStream> + Clone + 'static),
        guid: Option<&str>,
        flags: DBusConnectionFlags,
        observer: Option<&DBusAuthObserver>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<DBusConnection, glib::Error>> + 'static>>
    {
        let stream = stream.clone();
        let guid = guid.map(ToOwned::to_owned);
        let observer = observer.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            &(),
            move |_obj, cancellable, send| {
                Self::new(
                    &stream,
                    guid.as_ref().map(::std::borrow::Borrow::borrow),
                    flags,
                    observer.as_ref().map(::std::borrow::Borrow::borrow),
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    #[doc(alias = "g_dbus_connection_new_for_address")]
    #[doc(alias = "new_for_address")]
    pub fn for_address<P: FnOnce(Result<DBusConnection, glib::Error>) + 'static>(
        address: &str,
        flags: DBusConnectionFlags,
        observer: Option<&DBusAuthObserver>,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn for_address_trampoline<
            P: FnOnce(Result<DBusConnection, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_connection_new_for_address_finish(res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = for_address_trampoline::<P>;
        unsafe {
            ffi::g_dbus_connection_new_for_address(
                address.to_glib_none().0,
                flags.into_glib(),
                observer.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn for_address_future(
        address: &str,
        flags: DBusConnectionFlags,
        observer: Option<&DBusAuthObserver>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<DBusConnection, glib::Error>> + 'static>>
    {
        let address = String::from(address);
        let observer = observer.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            &(),
            move |_obj, cancellable, send| {
                Self::for_address(
                    &address,
                    flags,
                    observer.as_ref().map(::std::borrow::Borrow::borrow),
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    #[doc(alias = "closed")]
    pub fn connect_closed<F: Fn(&Self, bool, Option<&glib::Error>) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn closed_trampoline<
            F: Fn(&DBusConnection, bool, Option<&glib::Error>) + Send + Sync + 'static,
        >(
            this: *mut ffi::GDBusConnection,
            remote_peer_vanished: glib::ffi::gboolean,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                from_glib(remote_peer_vanished),
                Option::<glib::Error>::from_glib_borrow(error)
                    .as_ref()
                    .as_ref(),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"closed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    closed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "capabilities")]
    pub fn connect_capabilities_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_capabilities_trampoline<
            F: Fn(&DBusConnection) + Send + Sync + 'static,
        >(
            this: *mut ffi::GDBusConnection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::capabilities\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_capabilities_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "closed")]
    pub fn connect_closed_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_closed_trampoline<
            F: Fn(&DBusConnection) + Send + Sync + 'static,
        >(
            this: *mut ffi::GDBusConnection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::closed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_closed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "exit-on-close")]
    pub fn connect_exit_on_close_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_exit_on_close_trampoline<
            F: Fn(&DBusConnection) + Send + Sync + 'static,
        >(
            this: *mut ffi::GDBusConnection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::exit-on-close\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_exit_on_close_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "unique-name")]
    pub fn connect_unique_name_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_unique_name_trampoline<
            F: Fn(&DBusConnection) + Send + Sync + 'static,
        >(
            this: *mut ffi::GDBusConnection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::unique-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_unique_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

unsafe impl Send for DBusConnection {}
unsafe impl Sync for DBusConnection {}

impl fmt::Display for DBusConnection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DBusConnection")
    }
}
