#
# spec file for package bonnie (Version 1.5)
#
# Copyright (c) 2008 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild


Name:           bonnie
Url:            http://www.garloff.de/kurt/linux/bonnie/
License:        GPL v2 or later
Group:          System/Benchmark
AutoReqProv:    on
Summary:        File System Benchmark
Version:        1.5
Release:        1
Source0:        %{name}-%{version}.tar.bz2
Source1:        ctcstools.tar.bz2
#Patch:  %{name}-%{version}.diff
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#BuildRequires:	linux-kernel-headers  - fails on SLES-10-SP2
#BuildRequires:  kernel-source

%description
Bonnie is a popular performance benchmark that targets various aspects
of Unix file systems.



Authors:
--------
    Tim Bray <tbray@textuality.com>
    Kurt Garloff <garloff@suse.de>

#%package ctcs2-glue
#License:        GPL v2 or later
#Summary:        File System Benchmark
#Group:          System/Benchmark
#Requires:       bonnie ctcs2 >= 0.1.1
##BuildArchitectures: noarch
#
#%description ctcs2-glue
#Bonnie is a popular performance benchmark that targets various aspects
#of Unix file systems.
#
#
#
#Authors:
#--------
#    Tim Bray <tbray@textuality.com>
#    Kurt Garloff <garloff@suse.de>

%prep
%setup -n bonnie -a1

%build
make CC=gcc CFLAGS="$RPM_OPT_FLAGS"

%install
make install DESTDIR=$RPM_BUILD_ROOT MANDIR=%{_mandir}
#cd ctcstools
#mkdir -p $RPM_BUILD_ROOT/usr/share/qa/bonnie/tcf
#mkdir -p $RPM_BUILD_ROOT/usr/share/qa/tcf
#mkdir -p $RPM_BUILD_ROOT/usr/lib/ctcs2/tools
#install -m 744 do_bonnie $RPM_BUILD_ROOT/usr/share/qa/bonnie/
#install -m 644 *.tcf $RPM_BUILD_ROOT/usr/share/qa/bonnie/tcf/
#for A in *.tcf; do ln -s ../../../../usr/share/qa/bonnie/tcf/$A $RPM_BUILD_ROOT/usr/share/qa/tcf/; done
#install -m 744 bonnie-run $RPM_BUILD_ROOT/usr/lib/ctcs2/tools/ 

%files
%defattr(-, root, root)
%doc bonnie.doc README
/usr/bin/bonnie
%{_mandir}/man1/bonnie.1*

#%files ctcs2-glue
#%defattr(-, root, root)
#/usr/share/qa
#/usr/lib/ctcs2

%changelog
* Fri Feb 3 2012 kurt@garloff.de
- Version 1.5: Minor fixes
* Fri Sep 26 2008 vmarsik@suse.cz
- added subpackage for CTCS2 integration
* Sat Apr 26 2008 coolo@suse.de
- remove unused header file
* Mon May 22 2006 schwab@suse.de
- Don't build as root.
- Don't strip binaries.
* Fri May 19 2006 ro@suse.de
- fix build on ppc64 (define PAGE_MASK if not done)
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Thu Apr 04 2002 garloff@suse.de
- Version-1.4:
  * Fix seek benchmark: 1.3 read too large chunks (1MB instead
  of 16k) after every seek, resulting in too low seek numbers.
  bug #15642
* Sun Feb 24 2002 garloff@suse.de
- Compile fix for archs not supporting O_DIRECT (typo)
- Use O_DIRECT from fcntl.h if present.
* Wed Feb 20 2002 garloff@suse.de
- Update to bonnie-1.3:
  * Fixed HTML output (thanks to Rupert Kolb for notfying/patch)
  * Optionally use O_DIRECT (patch by Chris Mason / Andrea Arc.)
* Wed Aug 30 2000 garloff@suse.de
- Update to 1.2:
  * New option -u for getc_/putc_unlocked.
  * Fixed CPU percentage reports if equal or in excess of 100%%.
  * Machine name defaults to hostname now.
- Use BuildRoot.
* Mon Feb 14 2000 garloff@suse.de
- Moved manpage to /usr/share/man
- new options -y, -S, -p
- Add warning if test-size smaller memsize
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Tue Jul 20 1999 garloff@suse.de
- Initial check in of Big Bonnie.
- Added breakhandler to remove temporary files.
