; RUN: opt %loadPolly -basic-aa -polly-print-ast -polly-ast-detect-parallel -disable-output < %s | FileCheck %s
;
; This loopnest contains a reduction which imposes the same dependences as the
; accesses to the array A. We need to ensure we do __not__ parallelize anything
; here.
;
; CHECK: #pragma minimal dependence distance: 1
; CHECK-NOT: pragma
; CHECK-NOT: reduction
;
;    void AandSum(int *restrict sum, int *restrict A) {
;      for (int i = 0; i < 1024; i++) {
;        A[i] = A[i] + A[i - 1];
;        A[i - 1] = A[i] + A[i - 2];
;        *sum += i;
;      }
;    }
;
target datalayout = "e-m:e-p:32:32-i64:64-v128:64:128-n32-S64"

define void @AandSum(ptr noalias %sum, ptr noalias %A) {
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.inc, %entry
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.inc ]
  %exitcond = icmp ne i32 %i.0, 1024
  br i1 %exitcond, label %for.body, label %for.end

for.body:                                         ; preds = %for.cond
  %arrayidx = getelementptr inbounds i32, ptr %A, i32 %i.0
  %tmp = load i32, ptr %arrayidx, align 4
  %sub = add nsw i32 %i.0, -1
  %arrayidx1 = getelementptr inbounds i32, ptr %A, i32 %sub
  %tmp1 = load i32, ptr %arrayidx1, align 4
  %add = add nsw i32 %tmp, %tmp1
  %arrayidx2 = getelementptr inbounds i32, ptr %A, i32 %i.0
  store i32 %add, ptr %arrayidx2, align 4
  %sub4 = add nsw i32 %i.0, -2
  %arrayidx5 = getelementptr inbounds i32, ptr %A, i32 %sub4
  %tmp2 = load i32, ptr %arrayidx5, align 4
  %add6 = add nsw i32 %add, %tmp2
  %sub7 = add nsw i32 %i.0, -1
  %arrayidx8 = getelementptr inbounds i32, ptr %A, i32 %sub7
  store i32 %add6, ptr %arrayidx8, align 4
  %tmp3 = load i32, ptr %sum, align 4
  %add9 = add nsw i32 %tmp3, %i.0
  store i32 %add9, ptr %sum, align 4
  br label %for.inc

for.inc:                                          ; preds = %for.body
  %inc = add nsw i32 %i.0, 1
  br label %for.cond

for.end:                                          ; preds = %for.cond
  ret void
}
