; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2     | FileCheck %s --check-prefixes=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx      | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f  | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq | FileCheck %s --check-prefixes=AVX,AVX512,AVX512DQ
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx        | FileCheck %s --check-prefixes=X86

declare float @llvm.maximum.f32(float, float)
declare double @llvm.maximum.f64(double, double)
declare float @llvm.minimum.f32(float, float)
declare double @llvm.minimum.f64(double, double)
declare <2 x double> @llvm.minimum.v2f64(<2 x double>, <2 x double>)
declare <4 x float> @llvm.maximum.v4f32(<4 x float>, <4 x float>)

;
; fmaximum
;

define float @test_fmaximum(float %x, float %y) nounwind {
; SSE2-LABEL: test_fmaximum:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    js .LBB0_2
; SSE2-NEXT:  # %bb.1:
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:  .LBB0_2:
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    cmpunordss %xmm3, %xmm0
; SSE2-NEXT:    movaps %xmm0, %xmm4
; SSE2-NEXT:    andps %xmm3, %xmm4
; SSE2-NEXT:    js .LBB0_4
; SSE2-NEXT:  # %bb.3:
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:  .LBB0_4:
; SSE2-NEXT:    maxss %xmm1, %xmm3
; SSE2-NEXT:    andnps %xmm3, %xmm0
; SSE2-NEXT:    orps %xmm4, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fmaximum:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    js .LBB0_1
; AVX1-NEXT:  # %bb.2:
; AVX1-NEXT:    vmovdqa %xmm0, %xmm2
; AVX1-NEXT:    jmp .LBB0_3
; AVX1-NEXT:  .LBB0_1:
; AVX1-NEXT:    vmovdqa %xmm1, %xmm2
; AVX1-NEXT:    vmovdqa %xmm0, %xmm1
; AVX1-NEXT:  .LBB0_3:
; AVX1-NEXT:    vmaxss %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    vcmpunordss %xmm1, %xmm1, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_fmaximum:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd %xmm0, %eax
; AVX512-NEXT:    testl %eax, %eax
; AVX512-NEXT:    sets %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa %xmm0, %xmm2
; AVX512-NEXT:    vmovss %xmm1, %xmm2, %xmm2 {%k1}
; AVX512-NEXT:    vmovss %xmm0, %xmm1, %xmm1 {%k1}
; AVX512-NEXT:    vmaxss %xmm2, %xmm1, %xmm0
; AVX512-NEXT:    vcmpunordss %xmm1, %xmm1, %k1
; AVX512-NEXT:    vmovss %xmm1, %xmm0, %xmm0 {%k1}
; AVX512-NEXT:    retq
;
; X86-LABEL: test_fmaximum:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X86-NEXT:    vmovd %xmm2, %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    js .LBB0_1
; X86-NEXT:  # %bb.2:
; X86-NEXT:    vmovdqa %xmm2, %xmm1
; X86-NEXT:    jmp .LBB0_3
; X86-NEXT:  .LBB0_1:
; X86-NEXT:    vmovdqa %xmm0, %xmm1
; X86-NEXT:    vmovdqa %xmm2, %xmm0
; X86-NEXT:  .LBB0_3:
; X86-NEXT:    vmaxss %xmm1, %xmm0, %xmm1
; X86-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm2
; X86-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
  %1 = tail call float @llvm.maximum.f32(float %x, float %y)
  ret float %1
}

define <4 x float> @test_fmaximum_scalarize(<4 x float> %x, <4 x float> %y) "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" {
; SSE2-LABEL: test_fmaximum_scalarize:
; SSE2:       # %bb.0:
; SSE2-NEXT:    maxps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fmaximum_scalarize:
; AVX:       # %bb.0:
; AVX-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fmaximum_scalarize:
; X86:       # %bb.0:
; X86-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X86-NEXT:    retl
  %r = call <4 x float> @llvm.maximum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %r
}

define float @test_fmaximum_nan0(float %x, float %y) {
; SSE2-LABEL: test_fmaximum_nan0:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fmaximum_nan0:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    retq
;
; X86-LABEL: test_fmaximum_nan0:
; X86:       # %bb.0:
; X86-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X86-NEXT:    retl
  %1 = tail call float @llvm.maximum.f32(float 0x7fff000000000000, float %y)
  ret float %1
}

define float @test_fmaximum_nan1(float %x, float %y) {
; SSE2-LABEL: test_fmaximum_nan1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fmaximum_nan1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    retq
;
; X86-LABEL: test_fmaximum_nan1:
; X86:       # %bb.0:
; X86-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X86-NEXT:    retl
  %1 = tail call float @llvm.maximum.f32(float %x, float 0x7fff000000000000)
  ret float %1
}

define float @test_fmaximum_nnan(float %x, float %y) nounwind {
; SSE2-LABEL: test_fmaximum_nnan:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    addss %xmm1, %xmm2
; SSE2-NEXT:    subss %xmm1, %xmm0
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    js .LBB4_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    maxss %xmm2, %xmm0
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB4_1:
; SSE2-NEXT:    movaps %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    maxss %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fmaximum_nnan:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vaddss %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm2, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    js .LBB4_1
; AVX1-NEXT:  # %bb.2:
; AVX1-NEXT:    vmaxss %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB4_1:
; AVX1-NEXT:    vmovaps %xmm0, %xmm1
; AVX1-NEXT:    vmaxss %xmm1, %xmm2, %xmm0
; AVX1-NEXT:    retq
;
; AVX512F-LABEL: test_fmaximum_nnan:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vaddss %xmm1, %xmm0, %xmm2
; AVX512F-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vmovd %xmm2, %eax
; AVX512F-NEXT:    testl %eax, %eax
; AVX512F-NEXT:    sets %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovaps %xmm2, %xmm1
; AVX512F-NEXT:    vmovss %xmm0, %xmm1, %xmm1 {%k1}
; AVX512F-NEXT:    vmovss %xmm2, %xmm0, %xmm0 {%k1}
; AVX512F-NEXT:    vmaxss %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512DQ-LABEL: test_fmaximum_nnan:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vaddss %xmm1, %xmm0, %xmm2
; AVX512DQ-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX512DQ-NEXT:    vfpclassss $3, %xmm0, %k0
; AVX512DQ-NEXT:    kmovw %k0, %k1
; AVX512DQ-NEXT:    vmovaps %xmm2, %xmm1
; AVX512DQ-NEXT:    vmovss %xmm0, %xmm1, %xmm1 {%k1}
; AVX512DQ-NEXT:    vmovss %xmm2, %xmm0, %xmm0 {%k1}
; AVX512DQ-NEXT:    vmaxss %xmm1, %xmm0, %xmm0
; AVX512DQ-NEXT:    retq
;
; X86-LABEL: test_fmaximum_nnan:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X86-NEXT:    vaddss %xmm0, %xmm2, %xmm1
; X86-NEXT:    vsubss %xmm0, %xmm2, %xmm0
; X86-NEXT:    vmovd %xmm1, %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    js .LBB4_1
; X86-NEXT:  # %bb.2:
; X86-NEXT:    vmovaps %xmm1, %xmm2
; X86-NEXT:    jmp .LBB4_3
; X86-NEXT:  .LBB4_1:
; X86-NEXT:    vmovaps %xmm0, %xmm2
; X86-NEXT:    vmovaps %xmm1, %xmm0
; X86-NEXT:  .LBB4_3:
; X86-NEXT:    vmaxss %xmm2, %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
  %1 = fadd nnan float %x, %y
  %2 = fsub nnan float %x, %y
  %3 = tail call float @llvm.maximum.f32(float %1, float %2)
  ret float %3
}

define double @test_fmaximum_zero0(double %x, double %y) nounwind {
; SSE2-LABEL: test_fmaximum_zero0:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    cmpunordsd %xmm1, %xmm0
; SSE2-NEXT:    movapd %xmm0, %xmm2
; SSE2-NEXT:    andpd %xmm1, %xmm2
; SSE2-NEXT:    xorpd %xmm3, %xmm3
; SSE2-NEXT:    maxsd %xmm3, %xmm1
; SSE2-NEXT:    andnpd %xmm1, %xmm0
; SSE2-NEXT:    orpd %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fmaximum_zero0:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorpd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmaxsd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vcmpunordsd %xmm1, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_fmaximum_zero0:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vxorpd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmaxsd %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vcmpunordsd %xmm1, %xmm1, %k1
; AVX512-NEXT:    vmovsd %xmm1, %xmm0, %xmm0 {%k1}
; AVX512-NEXT:    retq
;
; X86-LABEL: test_fmaximum_zero0:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; X86-NEXT:    vmaxsd %xmm1, %xmm0, %xmm1
; X86-NEXT:    vcmpunordsd %xmm0, %xmm0, %xmm2
; X86-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovlpd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %1 = tail call double @llvm.maximum.f64(double 0.0, double %y)
  ret double %1
}

define double @test_fmaximum_zero1(double %x, double %y) nounwind {
; SSE2-LABEL: test_fmaximum_zero1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movapd %xmm0, %xmm1
; SSE2-NEXT:    cmpunordsd %xmm0, %xmm1
; SSE2-NEXT:    movapd %xmm1, %xmm2
; SSE2-NEXT:    andpd %xmm0, %xmm2
; SSE2-NEXT:    xorpd %xmm3, %xmm3
; SSE2-NEXT:    maxsd %xmm3, %xmm0
; SSE2-NEXT:    andnpd %xmm0, %xmm1
; SSE2-NEXT:    orpd %xmm2, %xmm1
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fmaximum_zero1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vmaxsd %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vcmpunordsd %xmm0, %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_fmaximum_zero1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vmaxsd %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    vcmpunordsd %xmm0, %xmm0, %k1
; AVX512-NEXT:    vmovsd %xmm0, %xmm1, %xmm1 {%k1}
; AVX512-NEXT:    vmovapd %xmm1, %xmm0
; AVX512-NEXT:    retq
;
; X86-LABEL: test_fmaximum_zero1:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; X86-NEXT:    vmaxsd %xmm1, %xmm0, %xmm1
; X86-NEXT:    vcmpunordsd %xmm0, %xmm0, %xmm2
; X86-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovlpd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %1 = tail call double @llvm.maximum.f64(double %x, double 0.0)
  ret double %1
}

define double @test_fmaximum_zero2(double %x, double %y) {
; SSE2-LABEL: test_fmaximum_zero2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fmaximum_zero2:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fmaximum_zero2:
; X86:       # %bb.0:
; X86-NEXT:    fldz
; X86-NEXT:    retl
  %1 = tail call double @llvm.maximum.f64(double 0.0, double -0.0)
  ret double %1
}

define float @test_fmaximum_nsz(float %x, float %y) "no-signed-zeros-fp-math"="true" nounwind {
; SSE2-LABEL: test_fmaximum_nsz:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    cmpunordss %xmm0, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm3
; SSE2-NEXT:    andps %xmm0, %xmm3
; SSE2-NEXT:    maxss %xmm1, %xmm0
; SSE2-NEXT:    andnps %xmm0, %xmm2
; SSE2-NEXT:    orps %xmm3, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fmaximum_nsz:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmaxss %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_fmaximum_nsz:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmaxss %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    vcmpunordss %xmm0, %xmm0, %k1
; AVX512-NEXT:    vmovss %xmm0, %xmm1, %xmm1 {%k1}
; AVX512-NEXT:    vmovaps %xmm1, %xmm0
; AVX512-NEXT:    retq
;
; X86-LABEL: test_fmaximum_nsz:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm1
; X86-NEXT:    vmaxss {{[0-9]+}}(%esp), %xmm0, %xmm2
; X86-NEXT:    vblendvps %xmm1, %xmm0, %xmm2, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
  %1 = tail call float @llvm.maximum.f32(float %x, float %y)
  ret float %1
}

define float @test_fmaximum_combine_cmps(float %x, float %y) nounwind {
; SSE2-LABEL: test_fmaximum_combine_cmps:
; SSE2:       # %bb.0:
; SSE2-NEXT:    divss %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    movaps %xmm0, %xmm3
; SSE2-NEXT:    js .LBB9_2
; SSE2-NEXT:  # %bb.1:
; SSE2-NEXT:    movaps %xmm1, %xmm3
; SSE2-NEXT:  .LBB9_2:
; SSE2-NEXT:    movaps %xmm3, %xmm2
; SSE2-NEXT:    cmpunordss %xmm3, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm4
; SSE2-NEXT:    andps %xmm3, %xmm4
; SSE2-NEXT:    js .LBB9_4
; SSE2-NEXT:  # %bb.3:
; SSE2-NEXT:    movaps %xmm0, %xmm1
; SSE2-NEXT:  .LBB9_4:
; SSE2-NEXT:    maxss %xmm1, %xmm3
; SSE2-NEXT:    andnps %xmm3, %xmm2
; SSE2-NEXT:    orps %xmm4, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fmaximum_combine_cmps:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vdivss %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    js .LBB9_1
; AVX1-NEXT:  # %bb.2:
; AVX1-NEXT:    vmovaps %xmm0, %xmm2
; AVX1-NEXT:    jmp .LBB9_3
; AVX1-NEXT:  .LBB9_1:
; AVX1-NEXT:    vmovaps %xmm1, %xmm2
; AVX1-NEXT:    vmovaps %xmm0, %xmm1
; AVX1-NEXT:  .LBB9_3:
; AVX1-NEXT:    vmaxss %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    vcmpunordss %xmm1, %xmm1, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX512F-LABEL: test_fmaximum_combine_cmps:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vdivss %xmm0, %xmm1, %xmm1
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    testl %eax, %eax
; AVX512F-NEXT:    sets %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovaps %xmm0, %xmm2
; AVX512F-NEXT:    vmovss %xmm1, %xmm2, %xmm2 {%k1}
; AVX512F-NEXT:    vmovss %xmm0, %xmm1, %xmm1 {%k1}
; AVX512F-NEXT:    vmaxss %xmm2, %xmm1, %xmm0
; AVX512F-NEXT:    vcmpunordss %xmm1, %xmm1, %k1
; AVX512F-NEXT:    vmovss %xmm1, %xmm0, %xmm0 {%k1}
; AVX512F-NEXT:    retq
;
; AVX512DQ-LABEL: test_fmaximum_combine_cmps:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vdivss %xmm0, %xmm1, %xmm1
; AVX512DQ-NEXT:    vfpclassss $3, %xmm0, %k0
; AVX512DQ-NEXT:    kmovw %k0, %k1
; AVX512DQ-NEXT:    vmovaps %xmm1, %xmm2
; AVX512DQ-NEXT:    vmovss %xmm0, %xmm2, %xmm2 {%k1}
; AVX512DQ-NEXT:    vmovss %xmm1, %xmm0, %xmm0 {%k1}
; AVX512DQ-NEXT:    vmaxss %xmm2, %xmm0, %xmm0
; AVX512DQ-NEXT:    retq
;
; X86-LABEL: test_fmaximum_combine_cmps:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vdivss %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovd %xmm1, %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    js .LBB9_1
; X86-NEXT:  # %bb.2:
; X86-NEXT:    vmovaps %xmm1, %xmm2
; X86-NEXT:    jmp .LBB9_3
; X86-NEXT:  .LBB9_1:
; X86-NEXT:    vmovaps %xmm0, %xmm2
; X86-NEXT:    vmovaps %xmm1, %xmm0
; X86-NEXT:  .LBB9_3:
; X86-NEXT:    vmaxss %xmm2, %xmm0, %xmm1
; X86-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm2
; X86-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
  %1 = fdiv nnan float %y, %x
  %2 = tail call float @llvm.maximum.f32(float %x, float %1)
  ret float %2
}

;
; fminimum
;

define float @test_fminimum(float %x, float %y) nounwind {
; SSE2-LABEL: test_fminimum:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    js .LBB10_2
; SSE2-NEXT:  # %bb.1:
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:  .LBB10_2:
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    cmpunordss %xmm3, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm4
; SSE2-NEXT:    andps %xmm3, %xmm4
; SSE2-NEXT:    js .LBB10_4
; SSE2-NEXT:  # %bb.3:
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:  .LBB10_4:
; SSE2-NEXT:    minss %xmm0, %xmm3
; SSE2-NEXT:    andnps %xmm3, %xmm2
; SSE2-NEXT:    orps %xmm4, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fminimum:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    js .LBB10_1
; AVX1-NEXT:  # %bb.2:
; AVX1-NEXT:    vmovdqa %xmm1, %xmm2
; AVX1-NEXT:    jmp .LBB10_3
; AVX1-NEXT:  .LBB10_1:
; AVX1-NEXT:    vmovdqa %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa %xmm1, %xmm0
; AVX1-NEXT:  .LBB10_3:
; AVX1-NEXT:    vminss %xmm2, %xmm0, %xmm1
; AVX1-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_fminimum:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd %xmm0, %eax
; AVX512-NEXT:    testl %eax, %eax
; AVX512-NEXT:    sets %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovaps %xmm1, %xmm2
; AVX512-NEXT:    vmovss %xmm0, %xmm2, %xmm2 {%k1}
; AVX512-NEXT:    vmovss %xmm1, %xmm0, %xmm0 {%k1}
; AVX512-NEXT:    vminss %xmm2, %xmm0, %xmm1
; AVX512-NEXT:    vcmpunordss %xmm0, %xmm0, %k1
; AVX512-NEXT:    vmovss %xmm0, %xmm1, %xmm1 {%k1}
; AVX512-NEXT:    vmovaps %xmm1, %xmm0
; AVX512-NEXT:    retq
;
; X86-LABEL: test_fminimum:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    js .LBB10_1
; X86-NEXT:  # %bb.2:
; X86-NEXT:    vmovdqa %xmm1, %xmm2
; X86-NEXT:    jmp .LBB10_3
; X86-NEXT:  .LBB10_1:
; X86-NEXT:    vmovdqa %xmm0, %xmm2
; X86-NEXT:    vmovdqa %xmm1, %xmm0
; X86-NEXT:  .LBB10_3:
; X86-NEXT:    vminss %xmm2, %xmm0, %xmm1
; X86-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm2
; X86-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
  %1 = tail call float @llvm.minimum.f32(float %x, float %y)
  ret float %1
}

define <2 x double> @test_fminimum_scalarize(<2 x double> %x, <2 x double> %y) "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" {
; SSE2-LABEL: test_fminimum_scalarize:
; SSE2:       # %bb.0:
; SSE2-NEXT:    minpd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_scalarize:
; AVX:       # %bb.0:
; AVX-NEXT:    vminpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_scalarize:
; X86:       # %bb.0:
; X86-NEXT:    vminpd %xmm1, %xmm0, %xmm0
; X86-NEXT:    retl
  %r = call <2 x double> @llvm.minimum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %r
}

define float @test_fminimum_nan0(float %x, float %y) {
; SSE2-LABEL: test_fminimum_nan0:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_nan0:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_nan0:
; X86:       # %bb.0:
; X86-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X86-NEXT:    retl
  %1 = tail call float @llvm.minimum.f32(float 0x7fff000000000000, float %y)
  ret float %1
}

define float @test_fminimum_nan1(float %x, float %y) {
; SSE2-LABEL: test_fminimum_nan1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_nan1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_nan1:
; X86:       # %bb.0:
; X86-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; X86-NEXT:    retl
  %1 = tail call float @llvm.minimum.f32(float %x, float 0x7fff000000000000)
  ret float %1
}

define double @test_fminimum_nnan(double %x, double %y) "no-nans-fp-math"="true" nounwind {
; SSE2-LABEL: test_fminimum_nnan:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB14_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    minsd %xmm1, %xmm0
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB14_1:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    minsd %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fminimum_nnan:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    testq %rax, %rax
; AVX1-NEXT:    js .LBB14_1
; AVX1-NEXT:  # %bb.2:
; AVX1-NEXT:    vminsd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB14_1:
; AVX1-NEXT:    vmovdqa %xmm0, %xmm2
; AVX1-NEXT:    vminsd %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX512F-LABEL: test_fminimum_nnan:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    testq %rax, %rax
; AVX512F-NEXT:    sets %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovapd %xmm1, %xmm2
; AVX512F-NEXT:    vmovsd %xmm0, %xmm2, %xmm2 {%k1}
; AVX512F-NEXT:    vmovsd %xmm1, %xmm0, %xmm0 {%k1}
; AVX512F-NEXT:    vminsd %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512DQ-LABEL: test_fminimum_nnan:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vfpclasssd $5, %xmm1, %k0
; AVX512DQ-NEXT:    kmovw %k0, %k1
; AVX512DQ-NEXT:    vmovapd %xmm0, %xmm2
; AVX512DQ-NEXT:    vmovsd %xmm1, %xmm2, %xmm2 {%k1}
; AVX512DQ-NEXT:    vmovsd %xmm0, %xmm1, %xmm1 {%k1}
; AVX512DQ-NEXT:    vminsd %xmm2, %xmm1, %xmm0
; AVX512DQ-NEXT:    retq
;
; X86-LABEL: test_fminimum_nnan:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; X86-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; X86-NEXT:    vextractps $1, %xmm2, %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    js .LBB14_1
; X86-NEXT:  # %bb.2:
; X86-NEXT:    vmovapd %xmm1, %xmm2
; X86-NEXT:    jmp .LBB14_3
; X86-NEXT:  .LBB14_1:
; X86-NEXT:    vmovapd %xmm0, %xmm2
; X86-NEXT:    vmovapd %xmm1, %xmm0
; X86-NEXT:  .LBB14_3:
; X86-NEXT:    vminsd %xmm2, %xmm0, %xmm0
; X86-NEXT:    vmovsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %1 = tail call double @llvm.minimum.f64(double %x, double %y)
  ret double %1
}

define double @test_fminimum_zero0(double %x, double %y) nounwind {
; SSE2-LABEL: test_fminimum_zero0:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    cmpunordsd %xmm1, %xmm0
; SSE2-NEXT:    movapd %xmm0, %xmm2
; SSE2-NEXT:    andpd %xmm1, %xmm2
; SSE2-NEXT:    minsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    andnpd %xmm1, %xmm0
; SSE2-NEXT:    orpd %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fminimum_zero0:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpunordsd %xmm1, %xmm1, %xmm0
; AVX1-NEXT:    vminsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm0, %xmm1, %xmm2, %xmm0
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_fminimum_zero0:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpunordsd %xmm1, %xmm1, %k1
; AVX512-NEXT:    vminsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm0
; AVX512-NEXT:    vmovsd %xmm1, %xmm0, %xmm0 {%k1}
; AVX512-NEXT:    retq
;
; X86-LABEL: test_fminimum_zero0:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vcmpunordsd %xmm0, %xmm0, %xmm1
; X86-NEXT:    vminsd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm2
; X86-NEXT:    vblendvpd %xmm1, %xmm0, %xmm2, %xmm0
; X86-NEXT:    vmovlpd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %1 = tail call double @llvm.minimum.f64(double -0.0, double %y)
  ret double %1
}

define double @test_fminimum_zero1(double %x, double %y) nounwind {
; SSE2-LABEL: test_fminimum_zero1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movapd %xmm0, %xmm1
; SSE2-NEXT:    cmpunordsd %xmm0, %xmm1
; SSE2-NEXT:    movapd %xmm1, %xmm2
; SSE2-NEXT:    andpd %xmm0, %xmm2
; SSE2-NEXT:    minsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    andnpd %xmm0, %xmm1
; SSE2-NEXT:    orpd %xmm2, %xmm1
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fminimum_zero1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpunordsd %xmm0, %xmm0, %xmm1
; AVX1-NEXT:    vminsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm1, %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_fminimum_zero1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpunordsd %xmm0, %xmm0, %k1
; AVX512-NEXT:    vminsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512-NEXT:    vmovsd %xmm0, %xmm1, %xmm1 {%k1}
; AVX512-NEXT:    vmovapd %xmm1, %xmm0
; AVX512-NEXT:    retq
;
; X86-LABEL: test_fminimum_zero1:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vcmpunordsd %xmm0, %xmm0, %xmm1
; X86-NEXT:    vminsd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm2
; X86-NEXT:    vblendvpd %xmm1, %xmm0, %xmm2, %xmm0
; X86-NEXT:    vmovlpd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %1 = tail call double @llvm.minimum.f64(double %x, double -0.0)
  ret double %1
}

define double @test_fminimum_zero2(double %x, double %y) {
; SSE2-LABEL: test_fminimum_zero2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_zero2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_zero2:
; X86:       # %bb.0:
; X86-NEXT:    fldz
; X86-NEXT:    fchs
; X86-NEXT:    retl
  %1 = tail call double @llvm.minimum.f64(double -0.0, double 0.0)
  ret double %1
}

define float @test_fminimum_nsz(float %x, float %y) nounwind {
; SSE2-LABEL: test_fminimum_nsz:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    cmpunordss %xmm0, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm3
; SSE2-NEXT:    andps %xmm0, %xmm3
; SSE2-NEXT:    minss %xmm1, %xmm0
; SSE2-NEXT:    andnps %xmm0, %xmm2
; SSE2-NEXT:    orps %xmm3, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fminimum_nsz:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vminss %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_fminimum_nsz:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vminss %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    vcmpunordss %xmm0, %xmm0, %k1
; AVX512-NEXT:    vmovss %xmm0, %xmm1, %xmm1 {%k1}
; AVX512-NEXT:    vmovaps %xmm1, %xmm0
; AVX512-NEXT:    retq
;
; X86-LABEL: test_fminimum_nsz:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm1
; X86-NEXT:    vminss {{[0-9]+}}(%esp), %xmm0, %xmm2
; X86-NEXT:    vblendvps %xmm1, %xmm0, %xmm2, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
  %1 = tail call nsz float @llvm.minimum.f32(float %x, float %y)
  ret float %1
}

define float @test_fminimum_combine_cmps(float %x, float %y) nounwind {
; SSE2-LABEL: test_fminimum_combine_cmps:
; SSE2:       # %bb.0:
; SSE2-NEXT:    divss %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    movaps %xmm1, %xmm3
; SSE2-NEXT:    js .LBB19_2
; SSE2-NEXT:  # %bb.1:
; SSE2-NEXT:    movaps %xmm0, %xmm3
; SSE2-NEXT:  .LBB19_2:
; SSE2-NEXT:    movaps %xmm3, %xmm2
; SSE2-NEXT:    cmpunordss %xmm3, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm4
; SSE2-NEXT:    andps %xmm3, %xmm4
; SSE2-NEXT:    js .LBB19_4
; SSE2-NEXT:  # %bb.3:
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:  .LBB19_4:
; SSE2-NEXT:    minss %xmm0, %xmm3
; SSE2-NEXT:    andnps %xmm3, %xmm2
; SSE2-NEXT:    orps %xmm4, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; AVX1-LABEL: test_fminimum_combine_cmps:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vdivss %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    js .LBB19_1
; AVX1-NEXT:  # %bb.2:
; AVX1-NEXT:    vmovaps %xmm2, %xmm1
; AVX1-NEXT:    jmp .LBB19_3
; AVX1-NEXT:  .LBB19_1:
; AVX1-NEXT:    vmovaps %xmm0, %xmm1
; AVX1-NEXT:    vmovaps %xmm2, %xmm0
; AVX1-NEXT:  .LBB19_3:
; AVX1-NEXT:    vminss %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX512F-LABEL: test_fminimum_combine_cmps:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vdivss %xmm0, %xmm1, %xmm1
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    testl %eax, %eax
; AVX512F-NEXT:    sets %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovaps %xmm1, %xmm2
; AVX512F-NEXT:    vmovss %xmm0, %xmm2, %xmm2 {%k1}
; AVX512F-NEXT:    vmovss %xmm1, %xmm0, %xmm0 {%k1}
; AVX512F-NEXT:    vminss %xmm2, %xmm0, %xmm1
; AVX512F-NEXT:    vcmpunordss %xmm0, %xmm0, %k1
; AVX512F-NEXT:    vmovss %xmm0, %xmm1, %xmm1 {%k1}
; AVX512F-NEXT:    vmovaps %xmm1, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512DQ-LABEL: test_fminimum_combine_cmps:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vdivss %xmm0, %xmm1, %xmm1
; AVX512DQ-NEXT:    vfpclassss $5, %xmm0, %k0
; AVX512DQ-NEXT:    kmovw %k0, %k1
; AVX512DQ-NEXT:    vmovaps %xmm1, %xmm2
; AVX512DQ-NEXT:    vmovss %xmm0, %xmm2, %xmm2 {%k1}
; AVX512DQ-NEXT:    vmovss %xmm1, %xmm0, %xmm0 {%k1}
; AVX512DQ-NEXT:    vminss %xmm2, %xmm0, %xmm0
; AVX512DQ-NEXT:    retq
;
; X86-LABEL: test_fminimum_combine_cmps:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    vdivss %xmm0, %xmm1, %xmm2
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    js .LBB19_1
; X86-NEXT:  # %bb.2:
; X86-NEXT:    vmovaps %xmm2, %xmm1
; X86-NEXT:    jmp .LBB19_3
; X86-NEXT:  .LBB19_1:
; X86-NEXT:    vmovaps %xmm0, %xmm1
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:  .LBB19_3:
; X86-NEXT:    vminss %xmm1, %xmm0, %xmm1
; X86-NEXT:    vcmpunordss %xmm0, %xmm0, %xmm2
; X86-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
  %1 = fdiv nnan float %y, %x
  %2 = tail call float @llvm.minimum.f32(float %x, float %1)
  ret float %2
}

define <2 x double> @test_fminimum_vector(<2 x double> %x, <2 x double> %y) {
; SSE2-LABEL: test_fminimum_vector:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm0[3,3]
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    pandn %xmm0, %xmm4
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    minpd %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    cmpunordpd %xmm3, %xmm0
; SSE2-NEXT:    andpd %xmm0, %xmm3
; SSE2-NEXT:    andnpd %xmm1, %xmm0
; SSE2-NEXT:    orpd %xmm3, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendvpd %xmm0, %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vblendvpd %xmm0, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vminpd %xmm2, %xmm0, %xmm1
; AVX-NEXT:    vcmpunordpd %xmm0, %xmm0, %xmm2
; AVX-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_vector:
; X86:       # %bb.0:
; X86-NEXT:    vblendvpd %xmm0, %xmm0, %xmm1, %xmm2
; X86-NEXT:    vblendvpd %xmm0, %xmm1, %xmm0, %xmm0
; X86-NEXT:    vminpd %xmm2, %xmm0, %xmm1
; X86-NEXT:    vcmpunordpd %xmm0, %xmm0, %xmm2
; X86-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-NEXT:    retl
  %r = call <2 x double> @llvm.minimum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %r
}

define <4 x float> @test_fmaximum_vector(<4 x float> %x, <4 x float> %y) "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" {
; SSE2-LABEL: test_fmaximum_vector:
; SSE2:       # %bb.0:
; SSE2-NEXT:    maxps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fmaximum_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fmaximum_vector:
; X86:       # %bb.0:
; X86-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X86-NEXT:    retl
  %r = call <4 x float> @llvm.maximum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %r
}

define <2 x double> @test_fminimum_vector_zero(<2 x double> %x) {
; SSE2-LABEL: test_fminimum_vector_zero:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    minpd %xmm0, %xmm1
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_vector_zero:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vminpd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_vector_zero:
; X86:       # %bb.0:
; X86-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; X86-NEXT:    vminpd %xmm0, %xmm1, %xmm0
; X86-NEXT:    retl
  %r = call <2 x double> @llvm.minimum.v2f64(<2 x double> %x, <2 x double> <double 0., double 0.>)
  ret <2 x double> %r
}

define <4 x float> @test_fmaximum_vector_signed_zero(<4 x float> %x) {
; SSE2-LABEL: test_fmaximum_vector_signed_zero:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; SSE2-NEXT:    maxps %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fmaximum_vector_signed_zero:
; AVX:       # %bb.0:
; AVX-NEXT:    vbroadcastss {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX-NEXT:    vmaxps %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fmaximum_vector_signed_zero:
; X86:       # %bb.0:
; X86-NEXT:    vbroadcastss {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-NEXT:    vmaxps %xmm0, %xmm1, %xmm0
; X86-NEXT:    retl
  %r = call <4 x float> @llvm.maximum.v4f32(<4 x float> %x, <4 x float> <float -0., float -0., float -0., float -0.>)
  ret <4 x float> %r
}

define <2 x double> @test_fminimum_vector_partially_zero(<2 x double> %x) {
; SSE2-LABEL: test_fminimum_vector_partially_zero:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE2-NEXT:    minpd %xmm0, %xmm1
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_vector_partially_zero:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX-NEXT:    vminpd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_vector_partially_zero:
; X86:       # %bb.0:
; X86-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; X86-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; X86-NEXT:    vminpd %xmm0, %xmm1, %xmm0
; X86-NEXT:    retl
  %r = call <2 x double> @llvm.minimum.v2f64(<2 x double> %x, <2 x double> <double 0., double 5.>)
  ret <2 x double> %r
}

define <2 x double> @test_fminimum_vector_different_zeros(<2 x double> %x) {
; SSE2-LABEL: test_fminimum_vector_different_zeros:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm0, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[3,3]
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    movhps {{.*#+}} xmm2 = xmm2[0,1],mem[0,1]
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    pandn %xmm2, %xmm1
; SSE2-NEXT:    movaps %xmm0, %xmm4
; SSE2-NEXT:    andps %xmm3, %xmm4
; SSE2-NEXT:    orps %xmm1, %xmm4
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pandn %xmm0, %xmm3
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    minpd %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    cmpunordpd %xmm3, %xmm0
; SSE2-NEXT:    andpd %xmm0, %xmm3
; SSE2-NEXT:    andnpd %xmm1, %xmm0
; SSE2-NEXT:    orpd %xmm3, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_vector_different_zeros:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX-NEXT:    vblendvpd %xmm0, %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vblendvpd %xmm0, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vminpd %xmm2, %xmm0, %xmm1
; AVX-NEXT:    vcmpunordpd %xmm0, %xmm0, %xmm2
; AVX-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_vector_different_zeros:
; X86:       # %bb.0:
; X86-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; X86-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; X86-NEXT:    vblendvpd %xmm0, %xmm0, %xmm1, %xmm2
; X86-NEXT:    vblendvpd %xmm0, %xmm1, %xmm0, %xmm0
; X86-NEXT:    vminpd %xmm2, %xmm0, %xmm1
; X86-NEXT:    vcmpunordpd %xmm0, %xmm0, %xmm2
; X86-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-NEXT:    retl
  %r = call <2 x double> @llvm.minimum.v2f64(<2 x double> %x, <2 x double> <double 0., double -0.>)
  ret <2 x double> %r
}

define <4 x float> @test_fmaximum_vector_non_zero(<4 x float> %x) {
; SSE2-LABEL: test_fmaximum_vector_non_zero:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps {{.*#+}} xmm1 = [5.0E+0,4.0E+0,3.0E+0,2.0E+0]
; SSE2-NEXT:    maxps %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fmaximum_vector_non_zero:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} xmm1 = [5.0E+0,4.0E+0,3.0E+0,2.0E+0]
; AVX-NEXT:    vmaxps %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fmaximum_vector_non_zero:
; X86:       # %bb.0:
; X86-NEXT:    vmovaps {{.*#+}} xmm1 = [5.0E+0,4.0E+0,3.0E+0,2.0E+0]
; X86-NEXT:    vmaxps %xmm0, %xmm1, %xmm0
; X86-NEXT:    retl
  %r = call <4 x float> @llvm.maximum.v4f32(<4 x float> %x, <4 x float> <float 5., float 4., float 3., float 2.>)
  ret <4 x float> %r
}

define <2 x double> @test_fminimum_vector_nan(<2 x double> %x) {
; SSE2-LABEL: test_fminimum_vector_nan:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE2-NEXT:    minpd %xmm0, %xmm1
; SSE2-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_vector_nan:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; AVX-NEXT:    vminpd %xmm0, %xmm2, %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_vector_nan:
; X86:       # %bb.0:
; X86-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; X86-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; X86-NEXT:    vminpd %xmm0, %xmm1, %xmm0
; X86-NEXT:    vcmpunordpd %xmm1, %xmm1, %xmm2
; X86-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; X86-NEXT:    retl
  %r = call <2 x double> @llvm.minimum.v2f64(<2 x double> %x, <2 x double> <double 0., double 0x7fff000000000000>)
  ret <2 x double> %r
}

define <2 x double> @test_fminimum_vector_zero_first(<2 x double> %x) {
; SSE2-LABEL: test_fminimum_vector_zero_first:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    minpd %xmm0, %xmm1
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_vector_zero_first:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vminpd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_vector_zero_first:
; X86:       # %bb.0:
; X86-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; X86-NEXT:    vminpd %xmm0, %xmm1, %xmm0
; X86-NEXT:    retl
  %r = call <2 x double> @llvm.minimum.v2f64(<2 x double> <double 0., double 0.>, <2 x double> %x)
  ret <2 x double> %r
}

define <2 x double> @test_fminimum_vector_signed_zero(<2 x double> %x) {
; SSE2-LABEL: test_fminimum_vector_signed_zero:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movapd %xmm0, %xmm1
; SSE2-NEXT:    minpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    movapd %xmm0, %xmm2
; SSE2-NEXT:    cmpunordpd %xmm0, %xmm2
; SSE2-NEXT:    andpd %xmm2, %xmm0
; SSE2-NEXT:    andnpd %xmm1, %xmm2
; SSE2-NEXT:    orpd %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fminimum_vector_signed_zero:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpunordpd %xmm0, %xmm0, %xmm1
; AVX-NEXT:    vminpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; AVX-NEXT:    vblendvpd %xmm1, %xmm0, %xmm2, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fminimum_vector_signed_zero:
; X86:       # %bb.0:
; X86-NEXT:    vcmpunordpd %xmm0, %xmm0, %xmm1
; X86-NEXT:    vminpd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm2
; X86-NEXT:    vblendvpd %xmm1, %xmm0, %xmm2, %xmm0
; X86-NEXT:    retl
  %r = call <2 x double> @llvm.minimum.v2f64(<2 x double> %x, <2 x double> <double -0., double -0.>)
  ret <2 x double> %r
}

define <4 x float> @test_fmaximum_vector_signed_zero_first(<4 x float> %x) {
; SSE2-LABEL: test_fmaximum_vector_signed_zero_first:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; SSE2-NEXT:    maxps %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fmaximum_vector_signed_zero_first:
; AVX:       # %bb.0:
; AVX-NEXT:    vbroadcastss {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX-NEXT:    vmaxps %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fmaximum_vector_signed_zero_first:
; X86:       # %bb.0:
; X86-NEXT:    vbroadcastss {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-NEXT:    vmaxps %xmm0, %xmm1, %xmm0
; X86-NEXT:    retl
  %r = call <4 x float> @llvm.maximum.v4f32(<4 x float> <float -0., float -0., float -0., float -0.>, <4 x float> %x)
  ret <4 x float> %r
}

define <4 x float> @test_fmaximum_vector_zero(<4 x float> %x) {
; SSE2-LABEL: test_fmaximum_vector_zero:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    maxps %xmm1, %xmm2
; SSE2-NEXT:    movaps %xmm0, %xmm1
; SSE2-NEXT:    cmpunordps %xmm0, %xmm1
; SSE2-NEXT:    andps %xmm1, %xmm0
; SSE2-NEXT:    andnps %xmm2, %xmm1
; SSE2-NEXT:    orps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; AVX-LABEL: test_fmaximum_vector_zero:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vmaxps %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vcmpunordps %xmm0, %xmm0, %xmm2
; AVX-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; X86-LABEL: test_fmaximum_vector_zero:
; X86:       # %bb.0:
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    vmaxps %xmm1, %xmm0, %xmm1
; X86-NEXT:    vcmpunordps %xmm0, %xmm0, %xmm2
; X86-NEXT:    vblendvps %xmm2, %xmm0, %xmm1, %xmm0
; X86-NEXT:    retl
  %r = call <4 x float> @llvm.maximum.v4f32(<4 x float> %x, <4 x float> <float 0., float 0., float 0., float 0.>)
  ret <4 x float> %r
}
