; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,CHECK32,RV32IM %s
; RUN: llc -mtriple=riscv64 -mattr=+m -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,CHECK64,RV64IM %s
; RUN: llc -mtriple=riscv64 -mattr=+m,+xventanacondops -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,CHECK64,RV64IMXVTCONDOPS %s
; RUN: llc -mtriple=riscv32 -mattr=+m,+experimental-zicond -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,CHECK32,CHECKZICOND,RV32IMZICOND %s
; RUN: llc -mtriple=riscv64 -mattr=+m,+experimental-zicond -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,CHECK64,CHECKZICOND,RV64IMZICOND %s

define i16 @select_xor_1(i16 %A, i8 %cond) {
; CHECK32-LABEL: select_xor_1:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    slli a1, a1, 31
; CHECK32-NEXT:    srai a1, a1, 31
; CHECK32-NEXT:    andi a1, a1, 43
; CHECK32-NEXT:    xor a0, a0, a1
; CHECK32-NEXT:    ret
;
; CHECK64-LABEL: select_xor_1:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    slli a1, a1, 63
; CHECK64-NEXT:    srai a1, a1, 63
; CHECK64-NEXT:    andi a1, a1, 43
; CHECK64-NEXT:    xor a0, a0, a1
; CHECK64-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %A, i16 %0
 ret i16 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i16 @select_xor_1b(i16 %A, i8 %cond) {
; RV32IM-LABEL: select_xor_1b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a1, a1, 31
; RV32IM-NEXT:    srai a1, a1, 31
; RV32IM-NEXT:    andi a1, a1, 43
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_1b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a1, a1, 63
; RV64IM-NEXT:    srai a1, a1, 63
; RV64IM-NEXT:    andi a1, a1, 43
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_1b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a1, a1, 1
; RV64IMXVTCONDOPS-NEXT:    li a2, 43
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a2, a1
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_1b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a1, a1, 1
; CHECKZICOND-NEXT:    li a2, 43
; CHECKZICOND-NEXT:    czero.eqz a1, a2, a1
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %A, i16 %0
 ret i16 %1
}

define i32 @select_xor_2(i32 %A, i32 %B, i8 %cond) {
; CHECK32-LABEL: select_xor_2:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    slli a2, a2, 31
; CHECK32-NEXT:    srai a2, a2, 31
; CHECK32-NEXT:    and a1, a2, a1
; CHECK32-NEXT:    xor a0, a0, a1
; CHECK32-NEXT:    ret
;
; CHECK64-LABEL: select_xor_2:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    slli a2, a2, 63
; CHECK64-NEXT:    srai a2, a2, 63
; CHECK64-NEXT:    and a1, a2, a1
; CHECK64-NEXT:    xor a0, a0, a1
; CHECK64-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_xor_2b(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_xor_2b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a2, a2, 31
; RV32IM-NEXT:    srai a2, a2, 31
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_2b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a2, a2, 63
; RV64IM-NEXT:    srai a2, a2, 63
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_2b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_2b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.eqz a1, a1, a2
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

define i16 @select_xor_3(i16 %A, i8 %cond) {
; RV32IM-LABEL: select_xor_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a1, a1, 1
; RV32IM-NEXT:    addi a1, a1, -1
; RV32IM-NEXT:    andi a1, a1, 43
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a1, a1, 1
; RV64IM-NEXT:    addiw a1, a1, -1
; RV64IM-NEXT:    andi a1, a1, 43
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a1, a1, 1
; RV64IMXVTCONDOPS-NEXT:    li a2, 43
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a2, a1
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_3:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a1, a1, 1
; CHECKZICOND-NEXT:    li a2, 43
; CHECKZICOND-NEXT:    czero.nez a1, a2, a1
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %0, i16 %A
 ret i16 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i16 @select_xor_3b(i16 %A, i8 %cond) {
; RV32IM-LABEL: select_xor_3b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a1, a1, 1
; RV32IM-NEXT:    addi a1, a1, -1
; RV32IM-NEXT:    andi a1, a1, 43
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_3b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a1, a1, 1
; RV64IM-NEXT:    addiw a1, a1, -1
; RV64IM-NEXT:    andi a1, a1, 43
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_3b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a1, a1, 1
; RV64IMXVTCONDOPS-NEXT:    li a2, 43
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a2, a1
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_3b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a1, a1, 1
; CHECKZICOND-NEXT:    li a2, 43
; CHECKZICOND-NEXT:    czero.nez a1, a2, a1
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i16 %A, 43
 %1 = select i1 %cmp10, i16 %0, i16 %A
 ret i16 %1
}

define i32 @select_xor_4(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_xor_4:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_4:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_4:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_4:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_xor_4b(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_xor_4b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    xor a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_xor_4b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    xor a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_xor_4b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    xor a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_xor_4b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    xor a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = xor i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

define i32 @select_or(i32 %A, i32 %B, i8 %cond) {
; CHECK32-LABEL: select_or:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    slli a2, a2, 31
; CHECK32-NEXT:    srai a2, a2, 31
; CHECK32-NEXT:    and a1, a2, a1
; CHECK32-NEXT:    or a0, a0, a1
; CHECK32-NEXT:    ret
;
; CHECK64-LABEL: select_or:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    slli a2, a2, 63
; CHECK64-NEXT:    srai a2, a2, 63
; CHECK64-NEXT:    and a1, a2, a1
; CHECK64-NEXT:    or a0, a0, a1
; CHECK64-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_b(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_or_b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a2, a2, 31
; RV32IM-NEXT:    srai a2, a2, 31
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a2, a2, 63
; RV64IM-NEXT:    srai a2, a2, 63
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.eqz a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

define i32 @select_or_1(i32 %A, i32 %B, i32 %cond) {
; CHECK32-LABEL: select_or_1:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    slli a2, a2, 31
; CHECK32-NEXT:    srai a2, a2, 31
; CHECK32-NEXT:    and a1, a2, a1
; CHECK32-NEXT:    or a0, a0, a1
; CHECK32-NEXT:    ret
;
; CHECK64-LABEL: select_or_1:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    slli a2, a2, 63
; CHECK64-NEXT:    srai a2, a2, 63
; CHECK64-NEXT:    and a1, a2, a1
; CHECK64-NEXT:    or a0, a0, a1
; CHECK64-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp eq i32 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_1b(i32 %A, i32 %B, i32 %cond) {
; RV32IM-LABEL: select_or_1b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    slli a2, a2, 31
; RV32IM-NEXT:    srai a2, a2, 31
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_1b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    slli a2, a2, 63
; RV64IM-NEXT:    srai a2, a2, 63
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_1b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_1b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.eqz a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp ne i32 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %A, i32 %0
 ret i32 %1
}

define i32 @select_or_2(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_or_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_2:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp eq i8 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_2b(i32 %A, i32 %B, i8 %cond) {
; RV32IM-LABEL: select_or_2b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_2b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_2b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_2b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i8 %cond, 1
 %cmp10 = icmp ne i8 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

define i32 @select_or_3(i32 %A, i32 %B, i32 %cond) {
; RV32IM-LABEL: select_or_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_3:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp eq i32 %and, 0
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

; Equivalent to above, but with icmp ne (and %cond, 1), 1 instead of
; icmp eq (and %cond, 1), 0
define i32 @select_or_3b(i32 %A, i32 %B, i32 %cond) {
; RV32IM-LABEL: select_or_3b:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    andi a2, a2, 1
; RV32IM-NEXT:    addi a2, a2, -1
; RV32IM-NEXT:    and a1, a2, a1
; RV32IM-NEXT:    or a0, a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_or_3b:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    andi a2, a2, 1
; RV64IM-NEXT:    addi a2, a2, -1
; RV64IM-NEXT:    and a1, a2, a1
; RV64IM-NEXT:    or a0, a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_or_3b:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a2, 1
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a1
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_or_3b:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a2, 1
; CHECKZICOND-NEXT:    czero.nez a1, a1, a2
; CHECKZICOND-NEXT:    or a0, a0, a1
; CHECKZICOND-NEXT:    ret
entry:
 %and = and i32 %cond, 1
 %cmp10 = icmp ne i32 %and, 1
 %0 = or i32 %B, %A
 %1 = select i1 %cmp10, i32 %0, i32 %A
 ret i32 %1
}

define i32 @select_add_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_add_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    neg a0, a0
; RV32IM-NEXT:    and a0, a0, a1
; RV32IM-NEXT:    add a0, a2, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_add_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    negw a0, a0
; RV64IM-NEXT:    and a0, a0, a1
; RV64IM-NEXT:    addw a0, a2, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_add_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    addw a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_add_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    add a0, a2, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_add_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    addw a0, a2, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = add i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_add_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_add_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    and a0, a0, a2
; RV32IM-NEXT:    add a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_add_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addiw a0, a0, -1
; RV64IM-NEXT:    and a0, a0, a2
; RV64IM-NEXT:    addw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_add_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    addw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_add_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    add a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_add_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    addw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = add i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_add_3(i1 zeroext %cond, i32 %a) {
; RV32IM-LABEL: select_add_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    andi a0, a0, 42
; RV32IM-NEXT:    add a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_add_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addiw a0, a0, -1
; RV64IM-NEXT:    andi a0, a0, 42
; RV64IM-NEXT:    addw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_add_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    li a2, 42
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    addw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_add_3:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    li a2, 42
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    add a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_add_3:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    li a2, 42
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    addw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = add i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_sub_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_sub_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB19_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    sub a2, a1, a2
; RV32IM-NEXT:  .LBB19_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_sub_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB19_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    subw a2, a1, a2
; RV64IM-NEXT:  .LBB19_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_sub_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    subw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_sub_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    sub a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_sub_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    subw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = sub i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_sub_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_sub_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    and a0, a0, a2
; RV32IM-NEXT:    sub a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_sub_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addiw a0, a0, -1
; RV64IM-NEXT:    and a0, a0, a2
; RV64IM-NEXT:    subw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_sub_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    subw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_sub_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    sub a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_sub_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    subw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = sub i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_sub_3(i1 zeroext %cond, i32 %a) {
; RV32IM-LABEL: select_sub_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    addi a0, a0, -1
; RV32IM-NEXT:    andi a0, a0, 42
; RV32IM-NEXT:    sub a0, a1, a0
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_sub_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    addiw a0, a0, -1
; RV64IM-NEXT:    andi a0, a0, 42
; RV64IM-NEXT:    subw a0, a1, a0
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_sub_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    li a2, 42
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    subw a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_sub_3:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    li a2, 42
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    sub a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_sub_3:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    li a2, 42
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    subw a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = sub i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_and_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_and_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB22_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    and a2, a1, a2
; RV32IM-NEXT:  .LBB22_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_and_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB22_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    and a2, a1, a2
; RV64IM-NEXT:  .LBB22_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_and_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    and a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_and_1:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    and a1, a1, a2
; CHECKZICOND-NEXT:    czero.nez a0, a2, a0
; CHECKZICOND-NEXT:    or a0, a1, a0
; CHECKZICOND-NEXT:    ret
entry:
  %c = and i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_and_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_and_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB23_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    and a1, a1, a2
; RV32IM-NEXT:  .LBB23_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_and_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB23_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    and a1, a1, a2
; RV64IM-NEXT:  .LBB23_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_and_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    and a2, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_and_2:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    and a2, a1, a2
; CHECKZICOND-NEXT:    czero.eqz a0, a1, a0
; CHECKZICOND-NEXT:    or a0, a2, a0
; CHECKZICOND-NEXT:    ret
entry:
  %c = and i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_and_3(i1 zeroext %cond, i32 %a) {
; RV32IM-LABEL: select_and_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB24_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    andi a1, a1, 42
; RV32IM-NEXT:  .LBB24_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_and_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB24_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    andi a1, a1, 42
; RV64IM-NEXT:  .LBB24_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_and_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    andi a2, a1, 42
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; CHECKZICOND-LABEL: select_and_3:
; CHECKZICOND:       # %bb.0: # %entry
; CHECKZICOND-NEXT:    andi a2, a1, 42
; CHECKZICOND-NEXT:    czero.eqz a0, a1, a0
; CHECKZICOND-NEXT:    or a0, a2, a0
; CHECKZICOND-NEXT:    ret
entry:
  %c = and i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_udiv_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_udiv_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB25_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    divu a2, a1, a2
; RV32IM-NEXT:  .LBB25_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_udiv_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB25_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    divuw a2, a1, a2
; RV64IM-NEXT:  .LBB25_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_udiv_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    divuw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_udiv_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    divu a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_udiv_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    divuw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = udiv i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_udiv_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_udiv_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB26_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    divu a1, a1, a2
; RV32IM-NEXT:  .LBB26_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_udiv_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB26_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    divuw a1, a1, a2
; RV64IM-NEXT:  .LBB26_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_udiv_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    divuw a2, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_udiv_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    divu a2, a1, a2
; RV32IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    or a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_udiv_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    divuw a2, a1, a2
; RV64IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    or a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = udiv i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_udiv_3(i1 zeroext %cond, i32 %a) {
; RV32IM-LABEL: select_udiv_3:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB27_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    srli a1, a1, 1
; RV32IM-NEXT:    lui a0, 199729
; RV32IM-NEXT:    addi a0, a0, -975
; RV32IM-NEXT:    mulhu a1, a1, a0
; RV32IM-NEXT:    srli a1, a1, 2
; RV32IM-NEXT:  .LBB27_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_udiv_3:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB27_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    srliw a0, a1, 1
; RV64IM-NEXT:    lui a1, 199729
; RV64IM-NEXT:    addiw a1, a1, -975
; RV64IM-NEXT:    mul a1, a0, a1
; RV64IM-NEXT:    srli a1, a1, 34
; RV64IM-NEXT:  .LBB27_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_udiv_3:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    srliw a2, a1, 1
; RV64IMXVTCONDOPS-NEXT:    lui a3, 199729
; RV64IMXVTCONDOPS-NEXT:    addiw a3, a3, -975
; RV64IMXVTCONDOPS-NEXT:    mul a2, a2, a3
; RV64IMXVTCONDOPS-NEXT:    srli a2, a2, 34
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_udiv_3:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    srli a2, a1, 1
; RV32IMZICOND-NEXT:    lui a3, 199729
; RV32IMZICOND-NEXT:    addi a3, a3, -975
; RV32IMZICOND-NEXT:    mulhu a2, a2, a3
; RV32IMZICOND-NEXT:    srli a2, a2, 2
; RV32IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    or a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_udiv_3:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    srliw a2, a1, 1
; RV64IMZICOND-NEXT:    lui a3, 199729
; RV64IMZICOND-NEXT:    addiw a3, a3, -975
; RV64IMZICOND-NEXT:    mul a2, a2, a3
; RV64IMZICOND-NEXT:    srli a2, a2, 34
; RV64IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    or a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = udiv i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_shl_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_shl_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB28_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    sll a2, a1, a2
; RV32IM-NEXT:  .LBB28_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_shl_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB28_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    sllw a2, a1, a2
; RV64IM-NEXT:  .LBB28_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_shl_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    sllw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_shl_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    sll a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_shl_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    sllw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = shl i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_shl_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_shl_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB29_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    sll a1, a1, a2
; RV32IM-NEXT:  .LBB29_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_shl_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB29_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    sllw a1, a1, a2
; RV64IM-NEXT:  .LBB29_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_shl_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    sllw a2, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_shl_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    sll a2, a1, a2
; RV32IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    or a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_shl_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    sllw a2, a1, a2
; RV64IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    or a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = shl i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_shl_3(i1 zeroext %cond, i32 %a) {
; CHECK-LABEL: select_shl_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    ret
entry:
  %c = shl i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_ashr_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_ashr_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB31_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    sra a2, a1, a2
; RV32IM-NEXT:  .LBB31_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_ashr_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB31_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    sraw a2, a1, a2
; RV64IM-NEXT:  .LBB31_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_ashr_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    sraw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_ashr_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    sra a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_ashr_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    sraw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = ashr i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_ashr_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_ashr_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB32_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    sra a1, a1, a2
; RV32IM-NEXT:  .LBB32_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_ashr_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB32_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    sraw a1, a1, a2
; RV64IM-NEXT:  .LBB32_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_ashr_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    sraw a2, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_ashr_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    sra a2, a1, a2
; RV32IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    or a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_ashr_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    sraw a2, a1, a2
; RV64IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    or a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = ashr i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_ashr_3(i1 zeroext %cond, i32 %a) {
; CHECK-LABEL: select_ashr_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    ret
entry:
  %c = ashr i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_lshr_1(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_lshr_1:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    beqz a0, .LBB34_2
; RV32IM-NEXT:  # %bb.1:
; RV32IM-NEXT:    srl a2, a1, a2
; RV32IM-NEXT:  .LBB34_2: # %entry
; RV32IM-NEXT:    mv a0, a2
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_lshr_1:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    beqz a0, .LBB34_2
; RV64IM-NEXT:  # %bb.1:
; RV64IM-NEXT:    srlw a2, a1, a2
; RV64IM-NEXT:  .LBB34_2: # %entry
; RV64IM-NEXT:    mv a0, a2
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_lshr_1:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    srlw a1, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a2, a2, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a0, a2
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_lshr_1:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    srl a1, a1, a2
; RV32IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV32IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV32IMZICOND-NEXT:    or a0, a0, a2
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_lshr_1:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    srlw a1, a1, a2
; RV64IMZICOND-NEXT:    czero.nez a2, a2, a0
; RV64IMZICOND-NEXT:    czero.eqz a0, a1, a0
; RV64IMZICOND-NEXT:    or a0, a0, a2
; RV64IMZICOND-NEXT:    ret
entry:
  %c = lshr i32 %a, %b
  %res = select i1 %cond, i32 %c, i32 %b
  ret i32 %res
}

define i32 @select_lshr_2(i1 zeroext %cond, i32 %a, i32 %b) {
; RV32IM-LABEL: select_lshr_2:
; RV32IM:       # %bb.0: # %entry
; RV32IM-NEXT:    bnez a0, .LBB35_2
; RV32IM-NEXT:  # %bb.1: # %entry
; RV32IM-NEXT:    srl a1, a1, a2
; RV32IM-NEXT:  .LBB35_2: # %entry
; RV32IM-NEXT:    mv a0, a1
; RV32IM-NEXT:    ret
;
; RV64IM-LABEL: select_lshr_2:
; RV64IM:       # %bb.0: # %entry
; RV64IM-NEXT:    bnez a0, .LBB35_2
; RV64IM-NEXT:  # %bb.1: # %entry
; RV64IM-NEXT:    srlw a1, a1, a2
; RV64IM-NEXT:  .LBB35_2: # %entry
; RV64IM-NEXT:    mv a0, a1
; RV64IM-NEXT:    ret
;
; RV64IMXVTCONDOPS-LABEL: select_lshr_2:
; RV64IMXVTCONDOPS:       # %bb.0: # %entry
; RV64IMXVTCONDOPS-NEXT:    srlw a2, a1, a2
; RV64IMXVTCONDOPS-NEXT:    vt.maskc a1, a1, a0
; RV64IMXVTCONDOPS-NEXT:    vt.maskcn a0, a2, a0
; RV64IMXVTCONDOPS-NEXT:    or a0, a1, a0
; RV64IMXVTCONDOPS-NEXT:    ret
;
; RV32IMZICOND-LABEL: select_lshr_2:
; RV32IMZICOND:       # %bb.0: # %entry
; RV32IMZICOND-NEXT:    srl a2, a1, a2
; RV32IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV32IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV32IMZICOND-NEXT:    or a0, a1, a0
; RV32IMZICOND-NEXT:    ret
;
; RV64IMZICOND-LABEL: select_lshr_2:
; RV64IMZICOND:       # %bb.0: # %entry
; RV64IMZICOND-NEXT:    srlw a2, a1, a2
; RV64IMZICOND-NEXT:    czero.eqz a1, a1, a0
; RV64IMZICOND-NEXT:    czero.nez a0, a2, a0
; RV64IMZICOND-NEXT:    or a0, a1, a0
; RV64IMZICOND-NEXT:    ret
entry:
  %c = lshr i32 %a, %b
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}

define i32 @select_lshr_3(i1 zeroext %cond, i32 %a) {
; CHECK-LABEL: select_lshr_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    ret
entry:
  %c = lshr i32 %a, 42
  %res = select i1 %cond, i32 %a, i32 %c
  ret i32 %res
}
