; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=CHECK32I %s
; RUN: llc -mtriple=riscv32 -mattr=+zcmp -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=CHECK32ZCMP %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=CHECK64I %s
; RUN: llc -mtriple=riscv64 -mattr=+zcmp -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=CHECK64ZCMP %s

declare i32 @foo(i32)
declare i32 @func(i32,i32)

define i32 @zcmp_mv(i32 %num, i32 %f) nounwind {
; CHECK32I-LABEL: zcmp_mv:
; CHECK32I:       # %bb.0:
; CHECK32I-NEXT:    addi sp, sp, -16
; CHECK32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; CHECK32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; CHECK32I-NEXT:    mv s0, a1
; CHECK32I-NEXT:    mv s1, a0
; CHECK32I-NEXT:    call func@plt
; CHECK32I-NEXT:    mv s2, a0
; CHECK32I-NEXT:    mv a0, s1
; CHECK32I-NEXT:    mv a1, s0
; CHECK32I-NEXT:    call func@plt
; CHECK32I-NEXT:    add a0, s2, s0
; CHECK32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; CHECK32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; CHECK32I-NEXT:    addi sp, sp, 16
; CHECK32I-NEXT:    ret
;
; CHECK32ZCMP-LABEL: zcmp_mv:
; CHECK32ZCMP:       # %bb.0:
; CHECK32ZCMP-NEXT:    cm.push {ra, s0-s2}, -16
; CHECK32ZCMP-NEXT:    cm.mvsa01 s1, s0
; CHECK32ZCMP-NEXT:    call func@plt
; CHECK32ZCMP-NEXT:    mv s2, a0
; CHECK32ZCMP-NEXT:    cm.mva01s s1, s0
; CHECK32ZCMP-NEXT:    call func@plt
; CHECK32ZCMP-NEXT:    add a0, s2, s0
; CHECK32ZCMP-NEXT:    cm.popret {ra, s0-s2}, 16
;
; CHECK64I-LABEL: zcmp_mv:
; CHECK64I:       # %bb.0:
; CHECK64I-NEXT:    addi sp, sp, -32
; CHECK64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK64I-NEXT:    mv s0, a1
; CHECK64I-NEXT:    mv s1, a0
; CHECK64I-NEXT:    call func@plt
; CHECK64I-NEXT:    mv s2, a0
; CHECK64I-NEXT:    mv a0, s1
; CHECK64I-NEXT:    mv a1, s0
; CHECK64I-NEXT:    call func@plt
; CHECK64I-NEXT:    addw a0, s2, s0
; CHECK64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK64I-NEXT:    addi sp, sp, 32
; CHECK64I-NEXT:    ret
;
; CHECK64ZCMP-LABEL: zcmp_mv:
; CHECK64ZCMP:       # %bb.0:
; CHECK64ZCMP-NEXT:    cm.push {ra, s0-s2}, -32
; CHECK64ZCMP-NEXT:    cm.mvsa01 s1, s0
; CHECK64ZCMP-NEXT:    call func@plt
; CHECK64ZCMP-NEXT:    mv s2, a0
; CHECK64ZCMP-NEXT:    cm.mva01s s1, s0
; CHECK64ZCMP-NEXT:    call func@plt
; CHECK64ZCMP-NEXT:    addw a0, s2, s0
; CHECK64ZCMP-NEXT:    cm.popret {ra, s0-s2}, 32
  %call = call i32 @func(i32 %num, i32 %f)
  %call1 = call i32 @func(i32 %num, i32 %f)
  %res = add i32 %call, %f
  ret i32 %res
}

define i32 @not_zcmp_mv(i32 %num, i32 %f) nounwind {
; CHECK32I-LABEL: not_zcmp_mv:
; CHECK32I:       # %bb.0:
; CHECK32I-NEXT:    addi sp, sp, -16
; CHECK32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; CHECK32I-NEXT:    mv s0, a1
; CHECK32I-NEXT:    call foo@plt
; CHECK32I-NEXT:    mv s1, a0
; CHECK32I-NEXT:    mv a0, s0
; CHECK32I-NEXT:    call foo@plt
; CHECK32I-NEXT:    mv a0, s1
; CHECK32I-NEXT:    call foo@plt
; CHECK32I-NEXT:    li a0, 1
; CHECK32I-NEXT:    mv a1, s0
; CHECK32I-NEXT:    call func@plt
; CHECK32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; CHECK32I-NEXT:    addi sp, sp, 16
; CHECK32I-NEXT:    ret
;
; CHECK32ZCMP-LABEL: not_zcmp_mv:
; CHECK32ZCMP:       # %bb.0:
; CHECK32ZCMP-NEXT:    cm.push {ra, s0-s1}, -16
; CHECK32ZCMP-NEXT:    mv s0, a1
; CHECK32ZCMP-NEXT:    call foo@plt
; CHECK32ZCMP-NEXT:    mv s1, a0
; CHECK32ZCMP-NEXT:    mv a0, s0
; CHECK32ZCMP-NEXT:    call foo@plt
; CHECK32ZCMP-NEXT:    mv a0, s1
; CHECK32ZCMP-NEXT:    call foo@plt
; CHECK32ZCMP-NEXT:    li a0, 1
; CHECK32ZCMP-NEXT:    mv a1, s0
; CHECK32ZCMP-NEXT:    call func@plt
; CHECK32ZCMP-NEXT:    cm.popret {ra, s0-s1}, 16
;
; CHECK64I-LABEL: not_zcmp_mv:
; CHECK64I:       # %bb.0:
; CHECK64I-NEXT:    addi sp, sp, -32
; CHECK64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK64I-NEXT:    mv s0, a1
; CHECK64I-NEXT:    call foo@plt
; CHECK64I-NEXT:    mv s1, a0
; CHECK64I-NEXT:    mv a0, s0
; CHECK64I-NEXT:    call foo@plt
; CHECK64I-NEXT:    mv a0, s1
; CHECK64I-NEXT:    call foo@plt
; CHECK64I-NEXT:    li a0, 1
; CHECK64I-NEXT:    mv a1, s0
; CHECK64I-NEXT:    call func@plt
; CHECK64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK64I-NEXT:    addi sp, sp, 32
; CHECK64I-NEXT:    ret
;
; CHECK64ZCMP-LABEL: not_zcmp_mv:
; CHECK64ZCMP:       # %bb.0:
; CHECK64ZCMP-NEXT:    cm.push {ra, s0-s1}, -32
; CHECK64ZCMP-NEXT:    mv s0, a1
; CHECK64ZCMP-NEXT:    call foo@plt
; CHECK64ZCMP-NEXT:    mv s1, a0
; CHECK64ZCMP-NEXT:    mv a0, s0
; CHECK64ZCMP-NEXT:    call foo@plt
; CHECK64ZCMP-NEXT:    mv a0, s1
; CHECK64ZCMP-NEXT:    call foo@plt
; CHECK64ZCMP-NEXT:    li a0, 1
; CHECK64ZCMP-NEXT:    mv a1, s0
; CHECK64ZCMP-NEXT:    call func@plt
; CHECK64ZCMP-NEXT:    cm.popret {ra, s0-s1}, 32
  %call = call i32 @foo(i32 %num)
  %call1 = call i32 @foo(i32 %f)
  %tmp = call i32 @foo(i32 %call)
  %res = call i32 @func(i32 1, i32 %f)
  ret i32 %res
}
