; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -S -disable-output "-passes=print<scalar-evolution>" < %s 2>&1 | FileCheck %s

; The obvious case.
define i32 @mul_biggerShl(i32 %val) nounwind {
; CHECK-LABEL: 'mul_biggerShl'
; CHECK-NEXT:  Classifying expressions for: @mul_biggerShl
; CHECK-NEXT:    %tmp1 = mul i32 %val, 64
; CHECK-NEXT:    -->  (64 * %val) U: [0,-63) S: [-2147483648,2147483585)
; CHECK-NEXT:    %tmp2 = udiv i32 %tmp1, 16
; CHECK-NEXT:    -->  ((64 * %val) /u 16) U: [0,268435453) S: [0,268435456)
; CHECK-NEXT:  Determining loop execution counts for: @mul_biggerShl
;
  %tmp1 = mul i32 %val, 64
  %tmp2 = udiv i32 %tmp1, 16
  ret i32 %tmp2
}

define i32 @mul_biggerLshl(i32 %val) nounwind {
; CHECK-LABEL: 'mul_biggerLshl'
; CHECK-NEXT:  Classifying expressions for: @mul_biggerLshl
; CHECK-NEXT:    %tmp1 = mul i32 %val, 16
; CHECK-NEXT:    -->  (16 * %val) U: [0,-15) S: [-2147483648,2147483633)
; CHECK-NEXT:    %tmp2 = udiv i32 %tmp1, 64
; CHECK-NEXT:    -->  ((16 * %val) /u 64) U: [0,67108864) S: [0,67108864)
; CHECK-NEXT:  Determining loop execution counts for: @mul_biggerLshl
;
  %tmp1 = mul i32 %val, 16
  %tmp2 = udiv i32 %tmp1, 64
  ret i32 %tmp2
}

; Or, it could have been transformed to shifts

define i32 @shifty_biggerShl(i32 %val) {
; CHECK-LABEL: 'shifty_biggerShl'
; CHECK-NEXT:  Classifying expressions for: @shifty_biggerShl
; CHECK-NEXT:    %tmp1 = shl i32 %val, 6
; CHECK-NEXT:    -->  (64 * %val) U: [0,-63) S: [-2147483648,2147483585)
; CHECK-NEXT:    %tmp2 = lshr i32 %tmp1, 4
; CHECK-NEXT:    -->  ((64 * %val) /u 16) U: [0,268435453) S: [0,268435456)
; CHECK-NEXT:  Determining loop execution counts for: @shifty_biggerShl
;
  %tmp1 = shl i32 %val, 6
  %tmp2 = lshr i32 %tmp1, 4
  ret i32 %tmp2
}

define i32 @shifty_biggerShl_shlnuw(i32 %val) {
; CHECK-LABEL: 'shifty_biggerShl_shlnuw'
; CHECK-NEXT:  Classifying expressions for: @shifty_biggerShl_shlnuw
; CHECK-NEXT:    %tmp1 = shl nuw i32 %val, 6
; CHECK-NEXT:    -->  (64 * %val) U: [0,-63) S: [-2147483648,2147483585)
; CHECK-NEXT:    %tmp2 = lshr i32 %tmp1, 4
; CHECK-NEXT:    -->  ((64 * %val) /u 16) U: [0,268435453) S: [0,268435456)
; CHECK-NEXT:  Determining loop execution counts for: @shifty_biggerShl_shlnuw
;
  %tmp1 = shl nuw i32 %val, 6
  %tmp2 = lshr i32 %tmp1, 4
  ret i32 %tmp2
}

define i32 @shifty_biggerLshr(i32 %val) {
; CHECK-LABEL: 'shifty_biggerLshr'
; CHECK-NEXT:  Classifying expressions for: @shifty_biggerLshr
; CHECK-NEXT:    %tmp1 = shl i32 %val, 4
; CHECK-NEXT:    -->  (16 * %val) U: [0,-15) S: [-2147483648,2147483633)
; CHECK-NEXT:    %tmp2 = lshr i32 %tmp1, 6
; CHECK-NEXT:    -->  ((16 * %val) /u 64) U: [0,67108864) S: [0,67108864)
; CHECK-NEXT:  Determining loop execution counts for: @shifty_biggerLshr
;
  %tmp1 = shl i32 %val, 4
  %tmp2 = lshr i32 %tmp1, 6
  ret i32 %tmp2
}

define i32 @shifty_biggerLshr_shlnuw(i32 %val) {
; CHECK-LABEL: 'shifty_biggerLshr_shlnuw'
; CHECK-NEXT:  Classifying expressions for: @shifty_biggerLshr_shlnuw
; CHECK-NEXT:    %tmp1 = shl nuw i32 %val, 4
; CHECK-NEXT:    -->  (16 * %val) U: [0,-15) S: [-2147483648,2147483633)
; CHECK-NEXT:    %tmp2 = lshr i32 %tmp1, 6
; CHECK-NEXT:    -->  ((16 * %val) /u 64) U: [0,67108864) S: [0,67108864)
; CHECK-NEXT:  Determining loop execution counts for: @shifty_biggerLshr_shlnuw
;
  %tmp1 = shl nuw i32 %val, 4
  %tmp2 = lshr i32 %tmp1, 6
  ret i32 %tmp2
}

; Or, further folded into mask variant.

define i32 @masky_biggerShl(i32 %val) {
; CHECK-LABEL: 'masky_biggerShl'
; CHECK-NEXT:  Classifying expressions for: @masky_biggerShl
; CHECK-NEXT:    %tmp1 = shl i32 %val, 2
; CHECK-NEXT:    -->  (4 * %val) U: [0,-3) S: [-2147483648,2147483645)
; CHECK-NEXT:    %tmp2 = and i32 %tmp1, 268435452
; CHECK-NEXT:    -->  (4 * (zext i26 (trunc i32 %val to i26) to i32))<nuw><nsw> U: [0,268435453) S: [0,268435453)
; CHECK-NEXT:  Determining loop execution counts for: @masky_biggerShl
;
  %tmp1 = shl i32 %val, 2
  %tmp2 = and i32 %tmp1, 268435452
  ret i32 %tmp2
}

define i32 @masky_biggerShl_shlnuw(i32 %val) {
; CHECK-LABEL: 'masky_biggerShl_shlnuw'
; CHECK-NEXT:  Classifying expressions for: @masky_biggerShl_shlnuw
; CHECK-NEXT:    %tmp1 = shl nuw i32 %val, 2
; CHECK-NEXT:    -->  (4 * %val) U: [0,-3) S: [-2147483648,2147483645)
; CHECK-NEXT:  Determining loop execution counts for: @masky_biggerShl_shlnuw
;
  %tmp1 = shl nuw i32 %val, 2
  ret i32 %tmp1
}

define i32 @masky_biggerLshr(i32 %val) {
; CHECK-LABEL: 'masky_biggerLshr'
; CHECK-NEXT:  Classifying expressions for: @masky_biggerLshr
; CHECK-NEXT:    %tmp1 = lshr i32 %val, 2
; CHECK-NEXT:    -->  (%val /u 4) U: [0,1073741824) S: [0,1073741824)
; CHECK-NEXT:    %tmp2 = and i32 %tmp1, 67108863
; CHECK-NEXT:    -->  (zext i26 (trunc i32 (%val /u 4) to i26) to i32) U: [0,67108864) S: [0,67108864)
; CHECK-NEXT:  Determining loop execution counts for: @masky_biggerLshr
;
  %tmp1 = lshr i32 %val, 2
  %tmp2 = and i32 %tmp1, 67108863
  ret i32 %tmp2
}

define i32 @masky_biggerLshr_shlnuw(i32 %val) {
; CHECK-LABEL: 'masky_biggerLshr_shlnuw'
; CHECK-NEXT:  Classifying expressions for: @masky_biggerLshr_shlnuw
; CHECK-NEXT:    %tmp1 = lshr i32 %val, 2
; CHECK-NEXT:    -->  (%val /u 4) U: [0,1073741824) S: [0,1073741824)
; CHECK-NEXT:  Determining loop execution counts for: @masky_biggerLshr_shlnuw
;
  %tmp1 = lshr i32 %val, 2
  ret i32 %tmp1
}
