/*
 * livepatch_bsc1231862
 *
 * Fix for CVE-2024-49860, bsc#1231862
 *
 *  Copyright (c) 2025 SUSE
 *  Author: Marcos Paulo de Souza <mpdesouza@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#if IS_ENABLED(CONFIG_ACPI)

/* klp-ccp: from drivers/acpi/device_sysfs.c */
#include <linux/acpi.h>
#include <linux/device.h>
#include <linux/export.h>

/* klp-ccp: from drivers/acpi/internal.h */
#include <linux/idr.h>

/* klp-ccp: from drivers/acpi/device_sysfs.c */
extern void acpi_expose_nondev_subnodes(struct kobject *kobj,
					struct acpi_device_data *data);

extern struct device_attribute dev_attr_modalias;

extern struct device_attribute dev_attr_real_power_state;

extern struct device_attribute dev_attr_power_state;

extern struct device_attribute dev_attr_eject;

extern struct device_attribute dev_attr_hid;

extern struct device_attribute dev_attr_uid;

extern struct device_attribute dev_attr_adr;

extern struct device_attribute dev_attr_path;

extern struct device_attribute dev_attr_description;

extern struct device_attribute dev_attr_sun;

extern struct device_attribute dev_attr_hrv;

extern struct device_attribute dev_attr_status;

int klpp_acpi_device_setup_files(struct acpi_device *dev)
{
	struct acpi_buffer buffer = {ACPI_ALLOCATE_BUFFER, NULL};
	acpi_status status;
	int result = 0;

	/*
	 * Devices gotten from FADT don't have a "path" attribute
	 */
	if (dev->handle) {
		result = device_create_file(&dev->dev, &dev_attr_path);
		if (result)
			goto end;
	}

	if (!list_empty(&dev->pnp.ids)) {
		result = device_create_file(&dev->dev, &dev_attr_hid);
		if (result)
			goto end;

		result = device_create_file(&dev->dev, &dev_attr_modalias);
		if (result)
			goto end;
	}

	/*
	 * If device has _STR, 'description' file is created
	 */
	if (acpi_has_method(dev->handle, "_STR")) {
		status = acpi_evaluate_object_typed(dev->handle, "_STR",
						    NULL, &buffer,
						    ACPI_TYPE_BUFFER);
		if (ACPI_FAILURE(status))
			buffer.pointer = NULL;
		dev->pnp.str_obj = buffer.pointer;
		result = device_create_file(&dev->dev, &dev_attr_description);
		if (result)
			goto end;
	}

	if (dev->pnp.type.bus_address)
		result = device_create_file(&dev->dev, &dev_attr_adr);
	if (dev->pnp.unique_id)
		result = device_create_file(&dev->dev, &dev_attr_uid);

	if (acpi_has_method(dev->handle, "_SUN")) {
		result = device_create_file(&dev->dev, &dev_attr_sun);
		if (result)
			goto end;
	}

	if (acpi_has_method(dev->handle, "_HRV")) {
		result = device_create_file(&dev->dev, &dev_attr_hrv);
		if (result)
			goto end;
	}

	if (acpi_has_method(dev->handle, "_STA")) {
		result = device_create_file(&dev->dev, &dev_attr_status);
		if (result)
			goto end;
	}

	/*
	 * If device has _EJ0, 'eject' file is created that is used to trigger
	 * hot-removal function from userland.
	 */
	if (acpi_has_method(dev->handle, "_EJ0")) {
		result = device_create_file(&dev->dev, &dev_attr_eject);
		if (result)
			return result;
	}

	if (dev->flags.power_manageable) {
		result = device_create_file(&dev->dev, &dev_attr_power_state);
		if (result)
			return result;

		if (dev->power.flags.power_resources)
			result = device_create_file(&dev->dev,
						    &dev_attr_real_power_state);
	}

	acpi_expose_nondev_subnodes(&dev->dev.kobj, &dev->data);

end:
	return result;
}


#include "livepatch_bsc1231862.h"

#include <linux/livepatch.h>

extern typeof(acpi_expose_nondev_subnodes) acpi_expose_nondev_subnodes
	 KLP_RELOC_SYMBOL(vmlinux, vmlinux, acpi_expose_nondev_subnodes);
extern typeof(dev_attr_adr) dev_attr_adr
	 KLP_RELOC_SYMBOL(vmlinux, vmlinux, dev_attr_adr);
extern typeof(dev_attr_description) dev_attr_description
	 KLP_RELOC_SYMBOL_POS(vmlinux, vmlinux, dev_attr_description, 1);
extern typeof(dev_attr_eject) dev_attr_eject
	 KLP_RELOC_SYMBOL(vmlinux, vmlinux, dev_attr_eject);
extern typeof(dev_attr_hid) dev_attr_hid
	 KLP_RELOC_SYMBOL(vmlinux, vmlinux, dev_attr_hid);
extern typeof(dev_attr_hrv) dev_attr_hrv
	 KLP_RELOC_SYMBOL(vmlinux, vmlinux, dev_attr_hrv);
extern typeof(dev_attr_modalias) dev_attr_modalias
	 KLP_RELOC_SYMBOL_POS(vmlinux, vmlinux, dev_attr_modalias, 2);
extern typeof(dev_attr_path) dev_attr_path
	 KLP_RELOC_SYMBOL_POS(vmlinux, vmlinux, dev_attr_path, 1);
extern typeof(dev_attr_power_state) dev_attr_power_state
	 KLP_RELOC_SYMBOL_POS(vmlinux, vmlinux, dev_attr_power_state, 2);
extern typeof(dev_attr_real_power_state) dev_attr_real_power_state
	 KLP_RELOC_SYMBOL(vmlinux, vmlinux, dev_attr_real_power_state);
extern typeof(dev_attr_status) dev_attr_status
	 KLP_RELOC_SYMBOL_POS(vmlinux, vmlinux, dev_attr_status, 1);
extern typeof(dev_attr_sun) dev_attr_sun
	 KLP_RELOC_SYMBOL(vmlinux, vmlinux, dev_attr_sun);
extern typeof(dev_attr_uid) dev_attr_uid
	 KLP_RELOC_SYMBOL_POS(vmlinux, vmlinux, dev_attr_uid, 1);

#endif /* IS_ENABLED(CONFIG_ACPI) */
