; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals
; This test checks to make sure that constant exprs fold in some simple
; situations

; RUN: opt -S < %s | FileCheck %s
; RUN: llvm-as < %s | llvm-dis | FileCheck %s
; RUN: verify-uselistorder %s

@A = global i64 0

@add = global ptr inttoptr (i64 add (i64 ptrtoint (ptr @A to i64), i64 0) to ptr) ; X + 0 == X
@sub = global ptr inttoptr (i64 sub (i64 ptrtoint (ptr @A to i64), i64 0) to ptr) ; X - 0 == X
@mul = global ptr inttoptr (i64 mul (i64 ptrtoint (ptr @A to i64), i64 0) to ptr) ; X * 0 == 0
@and1 = global ptr inttoptr (i64 and (i64 ptrtoint (ptr @A to i64), i64 0) to ptr) ; X & 0 == 0
@and2 = global ptr inttoptr (i64 and (i64 ptrtoint (ptr @A to i64), i64 -1) to ptr) ; X & -1 == X
@or = global i64 or (i64 ptrtoint (ptr @A to i64), i64 -1)  ; X | -1 == -1
@xor = global ptr inttoptr (i64 xor (i64 ptrtoint (ptr @A to i64), i64 0) to ptr) ; X ^ 0 == X

%Ty = type { i32, i32 }
@B = external global %Ty

; @icmp_ult1 and @icmp_ult2 will be folded by the target-dependent constant folder instead.
@icmp_ult1 = global i1 icmp ult (ptr @A, ptr getelementptr (i64, ptr @A, i64 1))        ; true
@icmp_slt = global i1 icmp slt (ptr @A, ptr @A)        ; false
@icmp_ult2 = global i1 icmp ult (ptr @B,
  ptr getelementptr (%Ty, ptr @B, i64 0, i32 1))            ; true
;global i1 icmp ne (ptr @A, ptr @B)                 ; true

; PR2206
@cons = weak global i32 0, align 8              ; <ptr> [#uses=1]
@and3 = global i64 and (i64 ptrtoint (ptr @cons to i64), i64 7)

@gep1 = global <2 x ptr> getelementptr(i8, <2 x ptr> undef, <2 x i64> <i64 1, i64 1>)
@gep2 = global <2 x ptr> getelementptr({ i8 }, <2 x ptr> undef, <2 x i64> <i64 1, i64 1>, <2 x i32> <i32 0, i32 0>)
@gep3 = global <2 x ptr> getelementptr(i8, <2 x ptr> zeroinitializer, <2 x i64> <i64 0, i64 0>)
@gep4 = global <2 x ptr> getelementptr({ i8 }, <2 x ptr> zeroinitializer, <2 x i64> <i64 0, i64 0>, <2 x i32> <i32 0, i32 0>)


; Need a function to make update_test_checks.py work.
;.
; CHECK: @[[A:[a-zA-Z0-9_$"\\.-]+]] = global i64 0
; CHECK: @[[ADD:[a-zA-Z0-9_$"\\.-]+]] = global ptr @A
; CHECK: @[[SUB:[a-zA-Z0-9_$"\\.-]+]] = global ptr @A
; CHECK: @[[MUL:[a-zA-Z0-9_$"\\.-]+]] = global ptr null
; CHECK: @[[AND1:[a-zA-Z0-9_$"\\.-]+]] = global ptr null
; CHECK: @[[AND2:[a-zA-Z0-9_$"\\.-]+]] = global ptr @A
; CHECK: @[[OR:[a-zA-Z0-9_$"\\.-]+]] = global i64 -1
; CHECK: @[[XOR:[a-zA-Z0-9_$"\\.-]+]] = global ptr @A
; CHECK: @[[B:[a-zA-Z0-9_$"\\.-]+]] = external global [[TY:%.*]]
; CHECK: @[[ICMP_ULT1:[a-zA-Z0-9_$"\\.-]+]] = global i1 icmp ugt (ptr getelementptr inbounds (i64, ptr @A, i64 1), ptr @A)
; CHECK: @[[ICMP_SLT:[a-zA-Z0-9_$"\\.-]+]] = global i1 false
; CHECK: @[[ICMP_ULT2:[a-zA-Z0-9_$"\\.-]+]] = global i1 icmp ugt (ptr getelementptr inbounds ([[TY:%.*]], ptr @B, i64 0, i32 1), ptr @B)
; CHECK: @[[CONS:[a-zA-Z0-9_$"\\.-]+]] = weak global i32 0, align 8
; CHECK: @[[AND3:[a-zA-Z0-9_$"\\.-]+]] = global i64 0
; CHECK: @[[GEP1:[a-zA-Z0-9_$"\\.-]+]] = global <2 x ptr> undef
; CHECK: @[[GEP2:[a-zA-Z0-9_$"\\.-]+]] = global <2 x ptr> undef
; CHECK: @[[GEP3:[a-zA-Z0-9_$"\\.-]+]] = global <2 x ptr> zeroinitializer
; CHECK: @[[GEP4:[a-zA-Z0-9_$"\\.-]+]] = global <2 x ptr> zeroinitializer
;.
define void @dummy() {
; CHECK-LABEL: @dummy(
; CHECK-NEXT:    ret void
;
  ret void
}
