/* SPDX-License-Identifier: (GPL-2.0 OR MIT) */

/* This file is autogenerated by cml-utils 2021-10-10 13:25:08 +0200.
 * Commit ID: 26db2002924973d36a30b369c94f025a678fe9ea (dirty)
 */

#ifndef _LAN966X_REGS_H_
#define _LAN966X_REGS_H_

#include <linux/bitfield.h>
#include <linux/types.h>
#include <linux/bug.h>

enum lan966x_target {
	TARGET_AFI = 2,
	TARGET_ANA = 3,
	TARGET_CHIP_TOP = 5,
	TARGET_CPU = 6,
	TARGET_DEV = 13,
	TARGET_FDMA = 21,
	TARGET_GCB = 27,
	TARGET_ORG = 36,
	TARGET_PTP = 41,
	TARGET_QS = 42,
	TARGET_QSYS = 46,
	TARGET_REW = 47,
	TARGET_SYS = 52,
	NUM_TARGETS = 66
};

#define __REG(...)    __VA_ARGS__

/*      AFI:PORT_TBL:PORT_FRM_OUT */
#define AFI_PORT_FRM_OUT(g)       __REG(TARGET_AFI, 0, 1, 98816, g, 10, 8, 0, 0, 1, 4)

#define AFI_PORT_FRM_OUT_FRM_OUT_CNT             GENMASK(26, 16)
#define AFI_PORT_FRM_OUT_FRM_OUT_CNT_SET(x)\
	FIELD_PREP(AFI_PORT_FRM_OUT_FRM_OUT_CNT, x)
#define AFI_PORT_FRM_OUT_FRM_OUT_CNT_GET(x)\
	FIELD_GET(AFI_PORT_FRM_OUT_FRM_OUT_CNT, x)

/*      AFI:PORT_TBL:PORT_CFG */
#define AFI_PORT_CFG(g)           __REG(TARGET_AFI, 0, 1, 98816, g, 10, 8, 4, 0, 1, 4)

#define AFI_PORT_CFG_FC_SKIP_TTI_INJ             BIT(16)
#define AFI_PORT_CFG_FC_SKIP_TTI_INJ_SET(x)\
	FIELD_PREP(AFI_PORT_CFG_FC_SKIP_TTI_INJ, x)
#define AFI_PORT_CFG_FC_SKIP_TTI_INJ_GET(x)\
	FIELD_GET(AFI_PORT_CFG_FC_SKIP_TTI_INJ, x)

#define AFI_PORT_CFG_FRM_OUT_MAX                 GENMASK(9, 0)
#define AFI_PORT_CFG_FRM_OUT_MAX_SET(x)\
	FIELD_PREP(AFI_PORT_CFG_FRM_OUT_MAX, x)
#define AFI_PORT_CFG_FRM_OUT_MAX_GET(x)\
	FIELD_GET(AFI_PORT_CFG_FRM_OUT_MAX, x)

/*      ANA:ANA:ADVLEARN */
#define ANA_ADVLEARN              __REG(TARGET_ANA, 0, 1, 29824, 0, 1, 244, 0, 0, 1, 4)

#define ANA_ADVLEARN_VLAN_CHK                    BIT(0)
#define ANA_ADVLEARN_VLAN_CHK_SET(x)\
	FIELD_PREP(ANA_ADVLEARN_VLAN_CHK, x)
#define ANA_ADVLEARN_VLAN_CHK_GET(x)\
	FIELD_GET(ANA_ADVLEARN_VLAN_CHK, x)

/*      ANA:ANA:VLANMASK */
#define ANA_VLANMASK              __REG(TARGET_ANA, 0, 1, 29824, 0, 1, 244, 8, 0, 1, 4)

/*      ANA:ANA:ANAINTR */
#define ANA_ANAINTR               __REG(TARGET_ANA, 0, 1, 29824, 0, 1, 244, 16, 0, 1, 4)

#define ANA_ANAINTR_INTR                         BIT(1)
#define ANA_ANAINTR_INTR_SET(x)\
	FIELD_PREP(ANA_ANAINTR_INTR, x)
#define ANA_ANAINTR_INTR_GET(x)\
	FIELD_GET(ANA_ANAINTR_INTR, x)

#define ANA_ANAINTR_INTR_ENA                     BIT(0)
#define ANA_ANAINTR_INTR_ENA_SET(x)\
	FIELD_PREP(ANA_ANAINTR_INTR_ENA, x)
#define ANA_ANAINTR_INTR_ENA_GET(x)\
	FIELD_GET(ANA_ANAINTR_INTR_ENA, x)

/*      ANA:ANA:AUTOAGE */
#define ANA_AUTOAGE               __REG(TARGET_ANA, 0, 1, 29824, 0, 1, 244, 44, 0, 1, 4)

#define ANA_AUTOAGE_AGE_PERIOD                   GENMASK(20, 1)
#define ANA_AUTOAGE_AGE_PERIOD_SET(x)\
	FIELD_PREP(ANA_AUTOAGE_AGE_PERIOD, x)
#define ANA_AUTOAGE_AGE_PERIOD_GET(x)\
	FIELD_GET(ANA_AUTOAGE_AGE_PERIOD, x)

/*      ANA:ANA:FLOODING */
#define ANA_FLOODING(r)           __REG(TARGET_ANA, 0, 1, 29824, 0, 1, 244, 68, r, 8, 4)

#define ANA_FLOODING_FLD_UNICAST                 GENMASK(17, 12)
#define ANA_FLOODING_FLD_UNICAST_SET(x)\
	FIELD_PREP(ANA_FLOODING_FLD_UNICAST, x)
#define ANA_FLOODING_FLD_UNICAST_GET(x)\
	FIELD_GET(ANA_FLOODING_FLD_UNICAST, x)

#define ANA_FLOODING_FLD_BROADCAST               GENMASK(11, 6)
#define ANA_FLOODING_FLD_BROADCAST_SET(x)\
	FIELD_PREP(ANA_FLOODING_FLD_BROADCAST, x)
#define ANA_FLOODING_FLD_BROADCAST_GET(x)\
	FIELD_GET(ANA_FLOODING_FLD_BROADCAST, x)

#define ANA_FLOODING_FLD_MULTICAST               GENMASK(5, 0)
#define ANA_FLOODING_FLD_MULTICAST_SET(x)\
	FIELD_PREP(ANA_FLOODING_FLD_MULTICAST, x)
#define ANA_FLOODING_FLD_MULTICAST_GET(x)\
	FIELD_GET(ANA_FLOODING_FLD_MULTICAST, x)

/*      ANA:ANA:FLOODING_IPMC */
#define ANA_FLOODING_IPMC         __REG(TARGET_ANA, 0, 1, 29824, 0, 1, 244, 100, 0, 1, 4)

#define ANA_FLOODING_IPMC_FLD_MC4_CTRL           GENMASK(23, 18)
#define ANA_FLOODING_IPMC_FLD_MC4_CTRL_SET(x)\
	FIELD_PREP(ANA_FLOODING_IPMC_FLD_MC4_CTRL, x)
#define ANA_FLOODING_IPMC_FLD_MC4_CTRL_GET(x)\
	FIELD_GET(ANA_FLOODING_IPMC_FLD_MC4_CTRL, x)

#define ANA_FLOODING_IPMC_FLD_MC4_DATA           GENMASK(17, 12)
#define ANA_FLOODING_IPMC_FLD_MC4_DATA_SET(x)\
	FIELD_PREP(ANA_FLOODING_IPMC_FLD_MC4_DATA, x)
#define ANA_FLOODING_IPMC_FLD_MC4_DATA_GET(x)\
	FIELD_GET(ANA_FLOODING_IPMC_FLD_MC4_DATA, x)

#define ANA_FLOODING_IPMC_FLD_MC6_CTRL           GENMASK(11, 6)
#define ANA_FLOODING_IPMC_FLD_MC6_CTRL_SET(x)\
	FIELD_PREP(ANA_FLOODING_IPMC_FLD_MC6_CTRL, x)
#define ANA_FLOODING_IPMC_FLD_MC6_CTRL_GET(x)\
	FIELD_GET(ANA_FLOODING_IPMC_FLD_MC6_CTRL, x)

#define ANA_FLOODING_IPMC_FLD_MC6_DATA           GENMASK(5, 0)
#define ANA_FLOODING_IPMC_FLD_MC6_DATA_SET(x)\
	FIELD_PREP(ANA_FLOODING_IPMC_FLD_MC6_DATA, x)
#define ANA_FLOODING_IPMC_FLD_MC6_DATA_GET(x)\
	FIELD_GET(ANA_FLOODING_IPMC_FLD_MC6_DATA, x)

/*      ANA:PGID:PGID */
#define ANA_PGID(g)               __REG(TARGET_ANA, 0, 1, 27648, g, 89, 8, 0, 0, 1, 4)

#define ANA_PGID_PGID                            GENMASK(8, 0)
#define ANA_PGID_PGID_SET(x)\
	FIELD_PREP(ANA_PGID_PGID, x)
#define ANA_PGID_PGID_GET(x)\
	FIELD_GET(ANA_PGID_PGID, x)

/*      ANA:PGID:PGID_CFG */
#define ANA_PGID_CFG(g)           __REG(TARGET_ANA, 0, 1, 27648, g, 89, 8, 4, 0, 1, 4)

#define ANA_PGID_CFG_OBEY_VLAN                   BIT(0)
#define ANA_PGID_CFG_OBEY_VLAN_SET(x)\
	FIELD_PREP(ANA_PGID_CFG_OBEY_VLAN, x)
#define ANA_PGID_CFG_OBEY_VLAN_GET(x)\
	FIELD_GET(ANA_PGID_CFG_OBEY_VLAN, x)

/*      ANA:ANA_TABLES:MACHDATA */
#define ANA_MACHDATA              __REG(TARGET_ANA, 0, 1, 27520, 0, 1, 128, 40, 0, 1, 4)

/*      ANA:ANA_TABLES:MACLDATA */
#define ANA_MACLDATA              __REG(TARGET_ANA, 0, 1, 27520, 0, 1, 128, 44, 0, 1, 4)

/*      ANA:ANA_TABLES:MACACCESS */
#define ANA_MACACCESS             __REG(TARGET_ANA, 0, 1, 27520, 0, 1, 128, 48, 0, 1, 4)

#define ANA_MACACCESS_CHANGE2SW                  BIT(17)
#define ANA_MACACCESS_CHANGE2SW_SET(x)\
	FIELD_PREP(ANA_MACACCESS_CHANGE2SW, x)
#define ANA_MACACCESS_CHANGE2SW_GET(x)\
	FIELD_GET(ANA_MACACCESS_CHANGE2SW, x)

#define ANA_MACACCESS_MAC_CPU_COPY               BIT(16)
#define ANA_MACACCESS_MAC_CPU_COPY_SET(x)\
	FIELD_PREP(ANA_MACACCESS_MAC_CPU_COPY, x)
#define ANA_MACACCESS_MAC_CPU_COPY_GET(x)\
	FIELD_GET(ANA_MACACCESS_MAC_CPU_COPY, x)

#define ANA_MACACCESS_VALID                      BIT(12)
#define ANA_MACACCESS_VALID_SET(x)\
	FIELD_PREP(ANA_MACACCESS_VALID, x)
#define ANA_MACACCESS_VALID_GET(x)\
	FIELD_GET(ANA_MACACCESS_VALID, x)

#define ANA_MACACCESS_ENTRYTYPE                  GENMASK(11, 10)
#define ANA_MACACCESS_ENTRYTYPE_SET(x)\
	FIELD_PREP(ANA_MACACCESS_ENTRYTYPE, x)
#define ANA_MACACCESS_ENTRYTYPE_GET(x)\
	FIELD_GET(ANA_MACACCESS_ENTRYTYPE, x)

#define ANA_MACACCESS_DEST_IDX                   GENMASK(9, 4)
#define ANA_MACACCESS_DEST_IDX_SET(x)\
	FIELD_PREP(ANA_MACACCESS_DEST_IDX, x)
#define ANA_MACACCESS_DEST_IDX_GET(x)\
	FIELD_GET(ANA_MACACCESS_DEST_IDX, x)

#define ANA_MACACCESS_MAC_TABLE_CMD              GENMASK(3, 0)
#define ANA_MACACCESS_MAC_TABLE_CMD_SET(x)\
	FIELD_PREP(ANA_MACACCESS_MAC_TABLE_CMD, x)
#define ANA_MACACCESS_MAC_TABLE_CMD_GET(x)\
	FIELD_GET(ANA_MACACCESS_MAC_TABLE_CMD, x)

/*      ANA:ANA_TABLES:MACTINDX */
#define ANA_MACTINDX              __REG(TARGET_ANA, 0, 1, 27520, 0, 1, 128, 52, 0, 1, 4)

#define ANA_MACTINDX_BUCKET                      GENMASK(12, 11)
#define ANA_MACTINDX_BUCKET_SET(x)\
	FIELD_PREP(ANA_MACTINDX_BUCKET, x)
#define ANA_MACTINDX_BUCKET_GET(x)\
	FIELD_GET(ANA_MACTINDX_BUCKET, x)

#define ANA_MACTINDX_M_INDEX                     GENMASK(10, 0)
#define ANA_MACTINDX_M_INDEX_SET(x)\
	FIELD_PREP(ANA_MACTINDX_M_INDEX, x)
#define ANA_MACTINDX_M_INDEX_GET(x)\
	FIELD_GET(ANA_MACTINDX_M_INDEX, x)

/*      ANA:ANA_TABLES:VLAN_PORT_MASK */
#define ANA_VLAN_PORT_MASK        __REG(TARGET_ANA, 0, 1, 27520, 0, 1, 128, 56, 0, 1, 4)

#define ANA_VLAN_PORT_MASK_VLAN_PORT_MASK        GENMASK(8, 0)
#define ANA_VLAN_PORT_MASK_VLAN_PORT_MASK_SET(x)\
	FIELD_PREP(ANA_VLAN_PORT_MASK_VLAN_PORT_MASK, x)
#define ANA_VLAN_PORT_MASK_VLAN_PORT_MASK_GET(x)\
	FIELD_GET(ANA_VLAN_PORT_MASK_VLAN_PORT_MASK, x)

/*      ANA:ANA_TABLES:VLANACCESS */
#define ANA_VLANACCESS            __REG(TARGET_ANA, 0, 1, 27520, 0, 1, 128, 60, 0, 1, 4)

#define ANA_VLANACCESS_VLAN_TBL_CMD              GENMASK(1, 0)
#define ANA_VLANACCESS_VLAN_TBL_CMD_SET(x)\
	FIELD_PREP(ANA_VLANACCESS_VLAN_TBL_CMD, x)
#define ANA_VLANACCESS_VLAN_TBL_CMD_GET(x)\
	FIELD_GET(ANA_VLANACCESS_VLAN_TBL_CMD, x)

/*      ANA:ANA_TABLES:VLANTIDX */
#define ANA_VLANTIDX              __REG(TARGET_ANA, 0, 1, 27520, 0, 1, 128, 64, 0, 1, 4)

#define ANA_VLANTIDX_VLAN_PGID_CPU_DIS           BIT(18)
#define ANA_VLANTIDX_VLAN_PGID_CPU_DIS_SET(x)\
	FIELD_PREP(ANA_VLANTIDX_VLAN_PGID_CPU_DIS, x)
#define ANA_VLANTIDX_VLAN_PGID_CPU_DIS_GET(x)\
	FIELD_GET(ANA_VLANTIDX_VLAN_PGID_CPU_DIS, x)

#define ANA_VLANTIDX_V_INDEX                     GENMASK(11, 0)
#define ANA_VLANTIDX_V_INDEX_SET(x)\
	FIELD_PREP(ANA_VLANTIDX_V_INDEX, x)
#define ANA_VLANTIDX_V_INDEX_GET(x)\
	FIELD_GET(ANA_VLANTIDX_V_INDEX, x)

/*      ANA:PORT:VLAN_CFG */
#define ANA_VLAN_CFG(g)           __REG(TARGET_ANA, 0, 1, 28672, g, 9, 128, 0, 0, 1, 4)

#define ANA_VLAN_CFG_VLAN_AWARE_ENA              BIT(20)
#define ANA_VLAN_CFG_VLAN_AWARE_ENA_SET(x)\
	FIELD_PREP(ANA_VLAN_CFG_VLAN_AWARE_ENA, x)
#define ANA_VLAN_CFG_VLAN_AWARE_ENA_GET(x)\
	FIELD_GET(ANA_VLAN_CFG_VLAN_AWARE_ENA, x)

#define ANA_VLAN_CFG_VLAN_POP_CNT                GENMASK(19, 18)
#define ANA_VLAN_CFG_VLAN_POP_CNT_SET(x)\
	FIELD_PREP(ANA_VLAN_CFG_VLAN_POP_CNT, x)
#define ANA_VLAN_CFG_VLAN_POP_CNT_GET(x)\
	FIELD_GET(ANA_VLAN_CFG_VLAN_POP_CNT, x)

#define ANA_VLAN_CFG_VLAN_VID                    GENMASK(11, 0)
#define ANA_VLAN_CFG_VLAN_VID_SET(x)\
	FIELD_PREP(ANA_VLAN_CFG_VLAN_VID, x)
#define ANA_VLAN_CFG_VLAN_VID_GET(x)\
	FIELD_GET(ANA_VLAN_CFG_VLAN_VID, x)

/*      ANA:PORT:DROP_CFG */
#define ANA_DROP_CFG(g)           __REG(TARGET_ANA, 0, 1, 28672, g, 9, 128, 4, 0, 1, 4)

#define ANA_DROP_CFG_DROP_UNTAGGED_ENA           BIT(6)
#define ANA_DROP_CFG_DROP_UNTAGGED_ENA_SET(x)\
	FIELD_PREP(ANA_DROP_CFG_DROP_UNTAGGED_ENA, x)
#define ANA_DROP_CFG_DROP_UNTAGGED_ENA_GET(x)\
	FIELD_GET(ANA_DROP_CFG_DROP_UNTAGGED_ENA, x)

#define ANA_DROP_CFG_DROP_PRIO_S_TAGGED_ENA      BIT(3)
#define ANA_DROP_CFG_DROP_PRIO_S_TAGGED_ENA_SET(x)\
	FIELD_PREP(ANA_DROP_CFG_DROP_PRIO_S_TAGGED_ENA, x)
#define ANA_DROP_CFG_DROP_PRIO_S_TAGGED_ENA_GET(x)\
	FIELD_GET(ANA_DROP_CFG_DROP_PRIO_S_TAGGED_ENA, x)

#define ANA_DROP_CFG_DROP_PRIO_C_TAGGED_ENA      BIT(2)
#define ANA_DROP_CFG_DROP_PRIO_C_TAGGED_ENA_SET(x)\
	FIELD_PREP(ANA_DROP_CFG_DROP_PRIO_C_TAGGED_ENA, x)
#define ANA_DROP_CFG_DROP_PRIO_C_TAGGED_ENA_GET(x)\
	FIELD_GET(ANA_DROP_CFG_DROP_PRIO_C_TAGGED_ENA, x)

#define ANA_DROP_CFG_DROP_MC_SMAC_ENA            BIT(0)
#define ANA_DROP_CFG_DROP_MC_SMAC_ENA_SET(x)\
	FIELD_PREP(ANA_DROP_CFG_DROP_MC_SMAC_ENA, x)
#define ANA_DROP_CFG_DROP_MC_SMAC_ENA_GET(x)\
	FIELD_GET(ANA_DROP_CFG_DROP_MC_SMAC_ENA, x)

/*      ANA:PORT:CPU_FWD_CFG */
#define ANA_CPU_FWD_CFG(g)        __REG(TARGET_ANA, 0, 1, 28672, g, 9, 128, 96, 0, 1, 4)

#define ANA_CPU_FWD_CFG_MLD_REDIR_ENA            BIT(6)
#define ANA_CPU_FWD_CFG_MLD_REDIR_ENA_SET(x)\
	FIELD_PREP(ANA_CPU_FWD_CFG_MLD_REDIR_ENA, x)
#define ANA_CPU_FWD_CFG_MLD_REDIR_ENA_GET(x)\
	FIELD_GET(ANA_CPU_FWD_CFG_MLD_REDIR_ENA, x)

#define ANA_CPU_FWD_CFG_IGMP_REDIR_ENA           BIT(5)
#define ANA_CPU_FWD_CFG_IGMP_REDIR_ENA_SET(x)\
	FIELD_PREP(ANA_CPU_FWD_CFG_IGMP_REDIR_ENA, x)
#define ANA_CPU_FWD_CFG_IGMP_REDIR_ENA_GET(x)\
	FIELD_GET(ANA_CPU_FWD_CFG_IGMP_REDIR_ENA, x)

#define ANA_CPU_FWD_CFG_IPMC_CTRL_COPY_ENA       BIT(4)
#define ANA_CPU_FWD_CFG_IPMC_CTRL_COPY_ENA_SET(x)\
	FIELD_PREP(ANA_CPU_FWD_CFG_IPMC_CTRL_COPY_ENA, x)
#define ANA_CPU_FWD_CFG_IPMC_CTRL_COPY_ENA_GET(x)\
	FIELD_GET(ANA_CPU_FWD_CFG_IPMC_CTRL_COPY_ENA, x)

#define ANA_CPU_FWD_CFG_SRC_COPY_ENA             BIT(3)
#define ANA_CPU_FWD_CFG_SRC_COPY_ENA_SET(x)\
	FIELD_PREP(ANA_CPU_FWD_CFG_SRC_COPY_ENA, x)
#define ANA_CPU_FWD_CFG_SRC_COPY_ENA_GET(x)\
	FIELD_GET(ANA_CPU_FWD_CFG_SRC_COPY_ENA, x)

/*      ANA:PORT:CPU_FWD_BPDU_CFG */
#define ANA_CPU_FWD_BPDU_CFG(g)   __REG(TARGET_ANA, 0, 1, 28672, g, 9, 128, 100, 0, 1, 4)

/*      ANA:PORT:PORT_CFG */
#define ANA_PORT_CFG(g)           __REG(TARGET_ANA, 0, 1, 28672, g, 9, 128, 112, 0, 1, 4)

#define ANA_PORT_CFG_LEARNAUTO                   BIT(6)
#define ANA_PORT_CFG_LEARNAUTO_SET(x)\
	FIELD_PREP(ANA_PORT_CFG_LEARNAUTO, x)
#define ANA_PORT_CFG_LEARNAUTO_GET(x)\
	FIELD_GET(ANA_PORT_CFG_LEARNAUTO, x)

#define ANA_PORT_CFG_LEARN_ENA                   BIT(5)
#define ANA_PORT_CFG_LEARN_ENA_SET(x)\
	FIELD_PREP(ANA_PORT_CFG_LEARN_ENA, x)
#define ANA_PORT_CFG_LEARN_ENA_GET(x)\
	FIELD_GET(ANA_PORT_CFG_LEARN_ENA, x)

#define ANA_PORT_CFG_RECV_ENA                    BIT(4)
#define ANA_PORT_CFG_RECV_ENA_SET(x)\
	FIELD_PREP(ANA_PORT_CFG_RECV_ENA, x)
#define ANA_PORT_CFG_RECV_ENA_GET(x)\
	FIELD_GET(ANA_PORT_CFG_RECV_ENA, x)

#define ANA_PORT_CFG_PORTID_VAL                  GENMASK(3, 0)
#define ANA_PORT_CFG_PORTID_VAL_SET(x)\
	FIELD_PREP(ANA_PORT_CFG_PORTID_VAL, x)
#define ANA_PORT_CFG_PORTID_VAL_GET(x)\
	FIELD_GET(ANA_PORT_CFG_PORTID_VAL, x)

/*      ANA:PFC:PFC_CFG */
#define ANA_PFC_CFG(g)            __REG(TARGET_ANA, 0, 1, 30720, g, 8, 64, 0, 0, 1, 4)

#define ANA_PFC_CFG_FC_LINK_SPEED                GENMASK(1, 0)
#define ANA_PFC_CFG_FC_LINK_SPEED_SET(x)\
	FIELD_PREP(ANA_PFC_CFG_FC_LINK_SPEED, x)
#define ANA_PFC_CFG_FC_LINK_SPEED_GET(x)\
	FIELD_GET(ANA_PFC_CFG_FC_LINK_SPEED, x)

/*      CHIP_TOP:CUPHY_CFG:CUPHY_PORT_CFG */
#define CHIP_TOP_CUPHY_PORT_CFG(r) __REG(TARGET_CHIP_TOP, 0, 1, 16, 0, 1, 20, 8, r, 2, 4)

#define CHIP_TOP_CUPHY_PORT_CFG_GTX_CLK_ENA      BIT(0)
#define CHIP_TOP_CUPHY_PORT_CFG_GTX_CLK_ENA_SET(x)\
	FIELD_PREP(CHIP_TOP_CUPHY_PORT_CFG_GTX_CLK_ENA, x)
#define CHIP_TOP_CUPHY_PORT_CFG_GTX_CLK_ENA_GET(x)\
	FIELD_GET(CHIP_TOP_CUPHY_PORT_CFG_GTX_CLK_ENA, x)

/*      DEV:PORT_MODE:CLOCK_CFG */
#define DEV_CLOCK_CFG(t)          __REG(TARGET_DEV, t, 8, 0, 0, 1, 28, 0, 0, 1, 4)

#define DEV_CLOCK_CFG_MAC_TX_RST                 BIT(7)
#define DEV_CLOCK_CFG_MAC_TX_RST_SET(x)\
	FIELD_PREP(DEV_CLOCK_CFG_MAC_TX_RST, x)
#define DEV_CLOCK_CFG_MAC_TX_RST_GET(x)\
	FIELD_GET(DEV_CLOCK_CFG_MAC_TX_RST, x)

#define DEV_CLOCK_CFG_MAC_RX_RST                 BIT(6)
#define DEV_CLOCK_CFG_MAC_RX_RST_SET(x)\
	FIELD_PREP(DEV_CLOCK_CFG_MAC_RX_RST, x)
#define DEV_CLOCK_CFG_MAC_RX_RST_GET(x)\
	FIELD_GET(DEV_CLOCK_CFG_MAC_RX_RST, x)

#define DEV_CLOCK_CFG_PCS_TX_RST                 BIT(5)
#define DEV_CLOCK_CFG_PCS_TX_RST_SET(x)\
	FIELD_PREP(DEV_CLOCK_CFG_PCS_TX_RST, x)
#define DEV_CLOCK_CFG_PCS_TX_RST_GET(x)\
	FIELD_GET(DEV_CLOCK_CFG_PCS_TX_RST, x)

#define DEV_CLOCK_CFG_PCS_RX_RST                 BIT(4)
#define DEV_CLOCK_CFG_PCS_RX_RST_SET(x)\
	FIELD_PREP(DEV_CLOCK_CFG_PCS_RX_RST, x)
#define DEV_CLOCK_CFG_PCS_RX_RST_GET(x)\
	FIELD_GET(DEV_CLOCK_CFG_PCS_RX_RST, x)

#define DEV_CLOCK_CFG_PORT_RST                   BIT(3)
#define DEV_CLOCK_CFG_PORT_RST_SET(x)\
	FIELD_PREP(DEV_CLOCK_CFG_PORT_RST, x)
#define DEV_CLOCK_CFG_PORT_RST_GET(x)\
	FIELD_GET(DEV_CLOCK_CFG_PORT_RST, x)

#define DEV_CLOCK_CFG_LINK_SPEED                 GENMASK(1, 0)
#define DEV_CLOCK_CFG_LINK_SPEED_SET(x)\
	FIELD_PREP(DEV_CLOCK_CFG_LINK_SPEED, x)
#define DEV_CLOCK_CFG_LINK_SPEED_GET(x)\
	FIELD_GET(DEV_CLOCK_CFG_LINK_SPEED, x)

/*      DEV:MAC_CFG_STATUS:MAC_ENA_CFG */
#define DEV_MAC_ENA_CFG(t)        __REG(TARGET_DEV, t, 8, 28, 0, 1, 44, 0, 0, 1, 4)

#define DEV_MAC_ENA_CFG_RX_ENA                   BIT(4)
#define DEV_MAC_ENA_CFG_RX_ENA_SET(x)\
	FIELD_PREP(DEV_MAC_ENA_CFG_RX_ENA, x)
#define DEV_MAC_ENA_CFG_RX_ENA_GET(x)\
	FIELD_GET(DEV_MAC_ENA_CFG_RX_ENA, x)

#define DEV_MAC_ENA_CFG_TX_ENA                   BIT(0)
#define DEV_MAC_ENA_CFG_TX_ENA_SET(x)\
	FIELD_PREP(DEV_MAC_ENA_CFG_TX_ENA, x)
#define DEV_MAC_ENA_CFG_TX_ENA_GET(x)\
	FIELD_GET(DEV_MAC_ENA_CFG_TX_ENA, x)

/*      DEV:MAC_CFG_STATUS:MAC_MODE_CFG */
#define DEV_MAC_MODE_CFG(t)       __REG(TARGET_DEV, t, 8, 28, 0, 1, 44, 4, 0, 1, 4)

#define DEV_MAC_MODE_CFG_GIGA_MODE_ENA           BIT(4)
#define DEV_MAC_MODE_CFG_GIGA_MODE_ENA_SET(x)\
	FIELD_PREP(DEV_MAC_MODE_CFG_GIGA_MODE_ENA, x)
#define DEV_MAC_MODE_CFG_GIGA_MODE_ENA_GET(x)\
	FIELD_GET(DEV_MAC_MODE_CFG_GIGA_MODE_ENA, x)

/*      DEV:MAC_CFG_STATUS:MAC_MAXLEN_CFG */
#define DEV_MAC_MAXLEN_CFG(t)     __REG(TARGET_DEV, t, 8, 28, 0, 1, 44, 8, 0, 1, 4)

#define DEV_MAC_MAXLEN_CFG_MAX_LEN               GENMASK(15, 0)
#define DEV_MAC_MAXLEN_CFG_MAX_LEN_SET(x)\
	FIELD_PREP(DEV_MAC_MAXLEN_CFG_MAX_LEN, x)
#define DEV_MAC_MAXLEN_CFG_MAX_LEN_GET(x)\
	FIELD_GET(DEV_MAC_MAXLEN_CFG_MAX_LEN, x)

/*      DEV:MAC_CFG_STATUS:MAC_IFG_CFG */
#define DEV_MAC_IFG_CFG(t)        __REG(TARGET_DEV, t, 8, 28, 0, 1, 44, 20, 0, 1, 4)

#define DEV_MAC_IFG_CFG_TX_IFG                   GENMASK(12, 8)
#define DEV_MAC_IFG_CFG_TX_IFG_SET(x)\
	FIELD_PREP(DEV_MAC_IFG_CFG_TX_IFG, x)
#define DEV_MAC_IFG_CFG_TX_IFG_GET(x)\
	FIELD_GET(DEV_MAC_IFG_CFG_TX_IFG, x)

#define DEV_MAC_IFG_CFG_RX_IFG2                  GENMASK(7, 4)
#define DEV_MAC_IFG_CFG_RX_IFG2_SET(x)\
	FIELD_PREP(DEV_MAC_IFG_CFG_RX_IFG2, x)
#define DEV_MAC_IFG_CFG_RX_IFG2_GET(x)\
	FIELD_GET(DEV_MAC_IFG_CFG_RX_IFG2, x)

#define DEV_MAC_IFG_CFG_RX_IFG1                  GENMASK(3, 0)
#define DEV_MAC_IFG_CFG_RX_IFG1_SET(x)\
	FIELD_PREP(DEV_MAC_IFG_CFG_RX_IFG1, x)
#define DEV_MAC_IFG_CFG_RX_IFG1_GET(x)\
	FIELD_GET(DEV_MAC_IFG_CFG_RX_IFG1, x)

/*      DEV:MAC_CFG_STATUS:MAC_HDX_CFG */
#define DEV_MAC_HDX_CFG(t)        __REG(TARGET_DEV, t, 8, 28, 0, 1, 44, 24, 0, 1, 4)

#define DEV_MAC_HDX_CFG_SEED                     GENMASK(23, 16)
#define DEV_MAC_HDX_CFG_SEED_SET(x)\
	FIELD_PREP(DEV_MAC_HDX_CFG_SEED, x)
#define DEV_MAC_HDX_CFG_SEED_GET(x)\
	FIELD_GET(DEV_MAC_HDX_CFG_SEED, x)

#define DEV_MAC_HDX_CFG_SEED_LOAD                BIT(12)
#define DEV_MAC_HDX_CFG_SEED_LOAD_SET(x)\
	FIELD_PREP(DEV_MAC_HDX_CFG_SEED_LOAD, x)
#define DEV_MAC_HDX_CFG_SEED_LOAD_GET(x)\
	FIELD_GET(DEV_MAC_HDX_CFG_SEED_LOAD, x)

/*      DEV:MAC_CFG_STATUS:MAC_FC_MAC_LOW_CFG */
#define DEV_FC_MAC_LOW_CFG(t)     __REG(TARGET_DEV, t, 8, 28, 0, 1, 44, 32, 0, 1, 4)

/*      DEV:MAC_CFG_STATUS:MAC_FC_MAC_HIGH_CFG */
#define DEV_FC_MAC_HIGH_CFG(t)    __REG(TARGET_DEV, t, 8, 28, 0, 1, 44, 36, 0, 1, 4)

/*      DEV:PCS1G_CFG_STATUS:PCS1G_CFG */
#define DEV_PCS1G_CFG(t)          __REG(TARGET_DEV, t, 8, 72, 0, 1, 68, 0, 0, 1, 4)

#define DEV_PCS1G_CFG_PCS_ENA                    BIT(0)
#define DEV_PCS1G_CFG_PCS_ENA_SET(x)\
	FIELD_PREP(DEV_PCS1G_CFG_PCS_ENA, x)
#define DEV_PCS1G_CFG_PCS_ENA_GET(x)\
	FIELD_GET(DEV_PCS1G_CFG_PCS_ENA, x)

/*      DEV:PCS1G_CFG_STATUS:PCS1G_MODE_CFG */
#define DEV_PCS1G_MODE_CFG(t)     __REG(TARGET_DEV, t, 8, 72, 0, 1, 68, 4, 0, 1, 4)

#define DEV_PCS1G_MODE_CFG_SGMII_MODE_ENA        BIT(0)
#define DEV_PCS1G_MODE_CFG_SGMII_MODE_ENA_SET(x)\
	FIELD_PREP(DEV_PCS1G_MODE_CFG_SGMII_MODE_ENA, x)
#define DEV_PCS1G_MODE_CFG_SGMII_MODE_ENA_GET(x)\
	FIELD_GET(DEV_PCS1G_MODE_CFG_SGMII_MODE_ENA, x)

/*      DEV:PCS1G_CFG_STATUS:PCS1G_SD_CFG */
#define DEV_PCS1G_SD_CFG(t)       __REG(TARGET_DEV, t, 8, 72, 0, 1, 68, 8, 0, 1, 4)

#define DEV_PCS1G_SD_CFG_SD_ENA                  BIT(0)
#define DEV_PCS1G_SD_CFG_SD_ENA_SET(x)\
	FIELD_PREP(DEV_PCS1G_SD_CFG_SD_ENA, x)
#define DEV_PCS1G_SD_CFG_SD_ENA_GET(x)\
	FIELD_GET(DEV_PCS1G_SD_CFG_SD_ENA, x)

/*      DEV:PCS1G_CFG_STATUS:PCS1G_ANEG_CFG */
#define DEV_PCS1G_ANEG_CFG(t)     __REG(TARGET_DEV, t, 8, 72, 0, 1, 68, 12, 0, 1, 4)

#define DEV_PCS1G_ANEG_CFG_ADV_ABILITY           GENMASK(31, 16)
#define DEV_PCS1G_ANEG_CFG_ADV_ABILITY_SET(x)\
	FIELD_PREP(DEV_PCS1G_ANEG_CFG_ADV_ABILITY, x)
#define DEV_PCS1G_ANEG_CFG_ADV_ABILITY_GET(x)\
	FIELD_GET(DEV_PCS1G_ANEG_CFG_ADV_ABILITY, x)

#define DEV_PCS1G_ANEG_CFG_SW_RESOLVE_ENA        BIT(8)
#define DEV_PCS1G_ANEG_CFG_SW_RESOLVE_ENA_SET(x)\
	FIELD_PREP(DEV_PCS1G_ANEG_CFG_SW_RESOLVE_ENA, x)
#define DEV_PCS1G_ANEG_CFG_SW_RESOLVE_ENA_GET(x)\
	FIELD_GET(DEV_PCS1G_ANEG_CFG_SW_RESOLVE_ENA, x)

#define DEV_PCS1G_ANEG_CFG_RESTART_ONE_SHOT      BIT(1)
#define DEV_PCS1G_ANEG_CFG_RESTART_ONE_SHOT_SET(x)\
	FIELD_PREP(DEV_PCS1G_ANEG_CFG_RESTART_ONE_SHOT, x)
#define DEV_PCS1G_ANEG_CFG_RESTART_ONE_SHOT_GET(x)\
	FIELD_GET(DEV_PCS1G_ANEG_CFG_RESTART_ONE_SHOT, x)

#define DEV_PCS1G_ANEG_CFG_ENA                   BIT(0)
#define DEV_PCS1G_ANEG_CFG_ENA_SET(x)\
	FIELD_PREP(DEV_PCS1G_ANEG_CFG_ENA, x)
#define DEV_PCS1G_ANEG_CFG_ENA_GET(x)\
	FIELD_GET(DEV_PCS1G_ANEG_CFG_ENA, x)

/*      DEV:PCS1G_CFG_STATUS:PCS1G_ANEG_STATUS */
#define DEV_PCS1G_ANEG_STATUS(t)  __REG(TARGET_DEV, t, 8, 72, 0, 1, 68, 32, 0, 1, 4)

#define DEV_PCS1G_ANEG_STATUS_LP_ADV             GENMASK(31, 16)
#define DEV_PCS1G_ANEG_STATUS_LP_ADV_SET(x)\
	FIELD_PREP(DEV_PCS1G_ANEG_STATUS_LP_ADV, x)
#define DEV_PCS1G_ANEG_STATUS_LP_ADV_GET(x)\
	FIELD_GET(DEV_PCS1G_ANEG_STATUS_LP_ADV, x)

#define DEV_PCS1G_ANEG_STATUS_ANEG_COMPLETE      BIT(0)
#define DEV_PCS1G_ANEG_STATUS_ANEG_COMPLETE_SET(x)\
	FIELD_PREP(DEV_PCS1G_ANEG_STATUS_ANEG_COMPLETE, x)
#define DEV_PCS1G_ANEG_STATUS_ANEG_COMPLETE_GET(x)\
	FIELD_GET(DEV_PCS1G_ANEG_STATUS_ANEG_COMPLETE, x)

/*      DEV:PCS1G_CFG_STATUS:PCS1G_LINK_STATUS */
#define DEV_PCS1G_LINK_STATUS(t)  __REG(TARGET_DEV, t, 8, 72, 0, 1, 68, 40, 0, 1, 4)

#define DEV_PCS1G_LINK_STATUS_LINK_STATUS        BIT(4)
#define DEV_PCS1G_LINK_STATUS_LINK_STATUS_SET(x)\
	FIELD_PREP(DEV_PCS1G_LINK_STATUS_LINK_STATUS, x)
#define DEV_PCS1G_LINK_STATUS_LINK_STATUS_GET(x)\
	FIELD_GET(DEV_PCS1G_LINK_STATUS_LINK_STATUS, x)

#define DEV_PCS1G_LINK_STATUS_SYNC_STATUS        BIT(0)
#define DEV_PCS1G_LINK_STATUS_SYNC_STATUS_SET(x)\
	FIELD_PREP(DEV_PCS1G_LINK_STATUS_SYNC_STATUS, x)
#define DEV_PCS1G_LINK_STATUS_SYNC_STATUS_GET(x)\
	FIELD_GET(DEV_PCS1G_LINK_STATUS_SYNC_STATUS, x)

/*      DEV:PCS1G_CFG_STATUS:PCS1G_STICKY */
#define DEV_PCS1G_STICKY(t)       __REG(TARGET_DEV, t, 8, 72, 0, 1, 68, 48, 0, 1, 4)

#define DEV_PCS1G_STICKY_LINK_DOWN_STICKY        BIT(4)
#define DEV_PCS1G_STICKY_LINK_DOWN_STICKY_SET(x)\
	FIELD_PREP(DEV_PCS1G_STICKY_LINK_DOWN_STICKY, x)
#define DEV_PCS1G_STICKY_LINK_DOWN_STICKY_GET(x)\
	FIELD_GET(DEV_PCS1G_STICKY_LINK_DOWN_STICKY, x)

/*      FDMA:FDMA:FDMA_CH_ACTIVATE */
#define FDMA_CH_ACTIVATE          __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 0, 0, 1, 4)

#define FDMA_CH_ACTIVATE_CH_ACTIVATE             GENMASK(7, 0)
#define FDMA_CH_ACTIVATE_CH_ACTIVATE_SET(x)\
	FIELD_PREP(FDMA_CH_ACTIVATE_CH_ACTIVATE, x)
#define FDMA_CH_ACTIVATE_CH_ACTIVATE_GET(x)\
	FIELD_GET(FDMA_CH_ACTIVATE_CH_ACTIVATE, x)

/*      FDMA:FDMA:FDMA_CH_RELOAD */
#define FDMA_CH_RELOAD            __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 4, 0, 1, 4)

#define FDMA_CH_RELOAD_CH_RELOAD                 GENMASK(7, 0)
#define FDMA_CH_RELOAD_CH_RELOAD_SET(x)\
	FIELD_PREP(FDMA_CH_RELOAD_CH_RELOAD, x)
#define FDMA_CH_RELOAD_CH_RELOAD_GET(x)\
	FIELD_GET(FDMA_CH_RELOAD_CH_RELOAD, x)

/*      FDMA:FDMA:FDMA_CH_DISABLE */
#define FDMA_CH_DISABLE           __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 8, 0, 1, 4)

#define FDMA_CH_DISABLE_CH_DISABLE               GENMASK(7, 0)
#define FDMA_CH_DISABLE_CH_DISABLE_SET(x)\
	FIELD_PREP(FDMA_CH_DISABLE_CH_DISABLE, x)
#define FDMA_CH_DISABLE_CH_DISABLE_GET(x)\
	FIELD_GET(FDMA_CH_DISABLE_CH_DISABLE, x)

/*      FDMA:FDMA:FDMA_CH_DB_DISCARD */
#define FDMA_CH_DB_DISCARD        __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 16, 0, 1, 4)

#define FDMA_CH_DB_DISCARD_DB_DISCARD            GENMASK(7, 0)
#define FDMA_CH_DB_DISCARD_DB_DISCARD_SET(x)\
	FIELD_PREP(FDMA_CH_DB_DISCARD_DB_DISCARD, x)
#define FDMA_CH_DB_DISCARD_DB_DISCARD_GET(x)\
	FIELD_GET(FDMA_CH_DB_DISCARD_DB_DISCARD, x)

/*      FDMA:FDMA:FDMA_DCB_LLP */
#define FDMA_DCB_LLP(r)           __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 52, r, 8, 4)

/*      FDMA:FDMA:FDMA_DCB_LLP1 */
#define FDMA_DCB_LLP1(r)          __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 84, r, 8, 4)

/*      FDMA:FDMA:FDMA_CH_ACTIVE */
#define FDMA_CH_ACTIVE            __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 180, 0, 1, 4)

/*      FDMA:FDMA:FDMA_CH_CFG */
#define FDMA_CH_CFG(r)            __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 224, r, 8, 4)

#define FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY          BIT(4)
#define FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY_SET(x)\
	FIELD_PREP(FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY, x)
#define FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY_GET(x)\
	FIELD_GET(FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY, x)

#define FDMA_CH_CFG_CH_INJ_PORT                  BIT(3)
#define FDMA_CH_CFG_CH_INJ_PORT_SET(x)\
	FIELD_PREP(FDMA_CH_CFG_CH_INJ_PORT, x)
#define FDMA_CH_CFG_CH_INJ_PORT_GET(x)\
	FIELD_GET(FDMA_CH_CFG_CH_INJ_PORT, x)

#define FDMA_CH_CFG_CH_DCB_DB_CNT                GENMASK(2, 1)
#define FDMA_CH_CFG_CH_DCB_DB_CNT_SET(x)\
	FIELD_PREP(FDMA_CH_CFG_CH_DCB_DB_CNT, x)
#define FDMA_CH_CFG_CH_DCB_DB_CNT_GET(x)\
	FIELD_GET(FDMA_CH_CFG_CH_DCB_DB_CNT, x)

#define FDMA_CH_CFG_CH_MEM                       BIT(0)
#define FDMA_CH_CFG_CH_MEM_SET(x)\
	FIELD_PREP(FDMA_CH_CFG_CH_MEM, x)
#define FDMA_CH_CFG_CH_MEM_GET(x)\
	FIELD_GET(FDMA_CH_CFG_CH_MEM, x)

/*      FDMA:FDMA:FDMA_PORT_CTRL */
#define FDMA_PORT_CTRL(r)         __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 376, r, 2, 4)

#define FDMA_PORT_CTRL_INJ_STOP                  BIT(4)
#define FDMA_PORT_CTRL_INJ_STOP_SET(x)\
	FIELD_PREP(FDMA_PORT_CTRL_INJ_STOP, x)
#define FDMA_PORT_CTRL_INJ_STOP_GET(x)\
	FIELD_GET(FDMA_PORT_CTRL_INJ_STOP, x)

#define FDMA_PORT_CTRL_XTR_STOP                  BIT(2)
#define FDMA_PORT_CTRL_XTR_STOP_SET(x)\
	FIELD_PREP(FDMA_PORT_CTRL_XTR_STOP, x)
#define FDMA_PORT_CTRL_XTR_STOP_GET(x)\
	FIELD_GET(FDMA_PORT_CTRL_XTR_STOP, x)

/*      FDMA:FDMA:FDMA_INTR_DB */
#define FDMA_INTR_DB              __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 392, 0, 1, 4)

/*      FDMA:FDMA:FDMA_INTR_DB_ENA */
#define FDMA_INTR_DB_ENA          __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 396, 0, 1, 4)

#define FDMA_INTR_DB_ENA_INTR_DB_ENA             GENMASK(7, 0)
#define FDMA_INTR_DB_ENA_INTR_DB_ENA_SET(x)\
	FIELD_PREP(FDMA_INTR_DB_ENA_INTR_DB_ENA, x)
#define FDMA_INTR_DB_ENA_INTR_DB_ENA_GET(x)\
	FIELD_GET(FDMA_INTR_DB_ENA_INTR_DB_ENA, x)

/*      FDMA:FDMA:FDMA_INTR_ERR */
#define FDMA_INTR_ERR             __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 400, 0, 1, 4)

/*      FDMA:FDMA:FDMA_ERRORS */
#define FDMA_ERRORS               __REG(TARGET_FDMA, 0, 1, 8, 0, 1, 428, 412, 0, 1, 4)

/*      PTP:PTP_CFG:PTP_PIN_INTR */
#define PTP_PIN_INTR              __REG(TARGET_PTP, 0, 1, 512, 0, 1, 16, 0, 0, 1, 4)

#define PTP_PIN_INTR_INTR_PTP                    GENMASK(7, 0)
#define PTP_PIN_INTR_INTR_PTP_SET(x)\
	FIELD_PREP(PTP_PIN_INTR_INTR_PTP, x)
#define PTP_PIN_INTR_INTR_PTP_GET(x)\
	FIELD_GET(PTP_PIN_INTR_INTR_PTP, x)

/*      PTP:PTP_CFG:PTP_PIN_INTR_ENA */
#define PTP_PIN_INTR_ENA          __REG(TARGET_PTP, 0, 1, 512, 0, 1, 16, 4, 0, 1, 4)

#define PTP_PIN_INTR_ENA_INTR_ENA                GENMASK(7, 0)
#define PTP_PIN_INTR_ENA_INTR_ENA_SET(x)\
	FIELD_PREP(PTP_PIN_INTR_ENA_INTR_ENA, x)
#define PTP_PIN_INTR_ENA_INTR_ENA_GET(x)\
	FIELD_GET(PTP_PIN_INTR_ENA_INTR_ENA, x)

/*      PTP:PTP_CFG:PTP_DOM_CFG */
#define PTP_DOM_CFG               __REG(TARGET_PTP, 0, 1, 512, 0, 1, 16, 12, 0, 1, 4)

#define PTP_DOM_CFG_ENA                          GENMASK(11, 9)
#define PTP_DOM_CFG_ENA_SET(x)\
	FIELD_PREP(PTP_DOM_CFG_ENA, x)
#define PTP_DOM_CFG_ENA_GET(x)\
	FIELD_GET(PTP_DOM_CFG_ENA, x)

#define PTP_DOM_CFG_CLKCFG_DIS                   GENMASK(2, 0)
#define PTP_DOM_CFG_CLKCFG_DIS_SET(x)\
	FIELD_PREP(PTP_DOM_CFG_CLKCFG_DIS, x)
#define PTP_DOM_CFG_CLKCFG_DIS_GET(x)\
	FIELD_GET(PTP_DOM_CFG_CLKCFG_DIS, x)

/*      PTP:PTP_TOD_DOMAINS:CLK_PER_CFG */
#define PTP_CLK_PER_CFG(g, r)     __REG(TARGET_PTP, 0, 1, 528, g, 3, 28, 0, r, 2, 4)

/*      PTP:PTP_PINS:PTP_PIN_CFG */
#define PTP_PIN_CFG(g)            __REG(TARGET_PTP, 0, 1, 0, g, 8, 64, 0, 0, 1, 4)

#define PTP_PIN_CFG_PIN_ACTION                   GENMASK(29, 27)
#define PTP_PIN_CFG_PIN_ACTION_SET(x)\
	FIELD_PREP(PTP_PIN_CFG_PIN_ACTION, x)
#define PTP_PIN_CFG_PIN_ACTION_GET(x)\
	FIELD_GET(PTP_PIN_CFG_PIN_ACTION, x)

#define PTP_PIN_CFG_PIN_SYNC                     GENMASK(26, 25)
#define PTP_PIN_CFG_PIN_SYNC_SET(x)\
	FIELD_PREP(PTP_PIN_CFG_PIN_SYNC, x)
#define PTP_PIN_CFG_PIN_SYNC_GET(x)\
	FIELD_GET(PTP_PIN_CFG_PIN_SYNC, x)

#define PTP_PIN_CFG_PIN_SELECT                   GENMASK(23, 21)
#define PTP_PIN_CFG_PIN_SELECT_SET(x)\
	FIELD_PREP(PTP_PIN_CFG_PIN_SELECT, x)
#define PTP_PIN_CFG_PIN_SELECT_GET(x)\
	FIELD_GET(PTP_PIN_CFG_PIN_SELECT, x)

#define PTP_PIN_CFG_PIN_DOM                      GENMASK(17, 16)
#define PTP_PIN_CFG_PIN_DOM_SET(x)\
	FIELD_PREP(PTP_PIN_CFG_PIN_DOM, x)
#define PTP_PIN_CFG_PIN_DOM_GET(x)\
	FIELD_GET(PTP_PIN_CFG_PIN_DOM, x)

/*      PTP:PTP_PINS:PTP_TOD_SEC_MSB */
#define PTP_TOD_SEC_MSB(g)        __REG(TARGET_PTP, 0, 1, 0, g, 8, 64, 4, 0, 1, 4)

#define PTP_TOD_SEC_MSB_TOD_SEC_MSB              GENMASK(15, 0)
#define PTP_TOD_SEC_MSB_TOD_SEC_MSB_SET(x)\
	FIELD_PREP(PTP_TOD_SEC_MSB_TOD_SEC_MSB, x)
#define PTP_TOD_SEC_MSB_TOD_SEC_MSB_GET(x)\
	FIELD_GET(PTP_TOD_SEC_MSB_TOD_SEC_MSB, x)

/*      PTP:PTP_PINS:PTP_TOD_SEC_LSB */
#define PTP_TOD_SEC_LSB(g)        __REG(TARGET_PTP, 0, 1, 0, g, 8, 64, 8, 0, 1, 4)

/*      PTP:PTP_PINS:PTP_TOD_NSEC */
#define PTP_TOD_NSEC(g)           __REG(TARGET_PTP, 0, 1, 0, g, 8, 64, 12, 0, 1, 4)

#define PTP_TOD_NSEC_TOD_NSEC                    GENMASK(29, 0)
#define PTP_TOD_NSEC_TOD_NSEC_SET(x)\
	FIELD_PREP(PTP_TOD_NSEC_TOD_NSEC, x)
#define PTP_TOD_NSEC_TOD_NSEC_GET(x)\
	FIELD_GET(PTP_TOD_NSEC_TOD_NSEC, x)

/*      PTP:PTP_PINS:WF_HIGH_PERIOD */
#define PTP_WF_HIGH_PERIOD(g)     __REG(TARGET_PTP,\
					0, 1, 0, g, 8, 64, 24, 0, 1, 4)

#define PTP_WF_HIGH_PERIOD_PIN_WFH(x)            ((x) & GENMASK(29, 0))
#define PTP_WF_HIGH_PERIOD_PIN_WFH_M             GENMASK(29, 0)
#define PTP_WF_HIGH_PERIOD_PIN_WFH_X(x)          ((x) & GENMASK(29, 0))

/*      PTP:PTP_PINS:WF_LOW_PERIOD */
#define PTP_WF_LOW_PERIOD(g)      __REG(TARGET_PTP,\
					0, 1, 0, g, 8, 64, 28, 0, 1, 4)

#define PTP_WF_LOW_PERIOD_PIN_WFL(x)             ((x) & GENMASK(29, 0))
#define PTP_WF_LOW_PERIOD_PIN_WFL_M              GENMASK(29, 0)
#define PTP_WF_LOW_PERIOD_PIN_WFL_X(x)           ((x) & GENMASK(29, 0))

/*      PTP:PTP_TS_FIFO:PTP_TWOSTEP_CTRL */
#define PTP_TWOSTEP_CTRL          __REG(TARGET_PTP, 0, 1, 612, 0, 1, 12, 0, 0, 1, 4)

#define PTP_TWOSTEP_CTRL_NXT                     BIT(11)
#define PTP_TWOSTEP_CTRL_NXT_SET(x)\
	FIELD_PREP(PTP_TWOSTEP_CTRL_NXT, x)
#define PTP_TWOSTEP_CTRL_NXT_GET(x)\
	FIELD_GET(PTP_TWOSTEP_CTRL_NXT, x)

#define PTP_TWOSTEP_CTRL_VLD                     BIT(10)
#define PTP_TWOSTEP_CTRL_VLD_SET(x)\
	FIELD_PREP(PTP_TWOSTEP_CTRL_VLD, x)
#define PTP_TWOSTEP_CTRL_VLD_GET(x)\
	FIELD_GET(PTP_TWOSTEP_CTRL_VLD, x)

#define PTP_TWOSTEP_CTRL_STAMP_TX                BIT(9)
#define PTP_TWOSTEP_CTRL_STAMP_TX_SET(x)\
	FIELD_PREP(PTP_TWOSTEP_CTRL_STAMP_TX, x)
#define PTP_TWOSTEP_CTRL_STAMP_TX_GET(x)\
	FIELD_GET(PTP_TWOSTEP_CTRL_STAMP_TX, x)

#define PTP_TWOSTEP_CTRL_STAMP_PORT              GENMASK(8, 1)
#define PTP_TWOSTEP_CTRL_STAMP_PORT_SET(x)\
	FIELD_PREP(PTP_TWOSTEP_CTRL_STAMP_PORT, x)
#define PTP_TWOSTEP_CTRL_STAMP_PORT_GET(x)\
	FIELD_GET(PTP_TWOSTEP_CTRL_STAMP_PORT, x)

#define PTP_TWOSTEP_CTRL_OVFL                    BIT(0)
#define PTP_TWOSTEP_CTRL_OVFL_SET(x)\
	FIELD_PREP(PTP_TWOSTEP_CTRL_OVFL, x)
#define PTP_TWOSTEP_CTRL_OVFL_GET(x)\
	FIELD_GET(PTP_TWOSTEP_CTRL_OVFL, x)

/*      PTP:PTP_TS_FIFO:PTP_TWOSTEP_STAMP */
#define PTP_TWOSTEP_STAMP         __REG(TARGET_PTP, 0, 1, 612, 0, 1, 12, 4, 0, 1, 4)

#define PTP_TWOSTEP_STAMP_STAMP_NSEC             GENMASK(31, 2)
#define PTP_TWOSTEP_STAMP_STAMP_NSEC_SET(x)\
	FIELD_PREP(PTP_TWOSTEP_STAMP_STAMP_NSEC, x)
#define PTP_TWOSTEP_STAMP_STAMP_NSEC_GET(x)\
	FIELD_GET(PTP_TWOSTEP_STAMP_STAMP_NSEC, x)

/*      DEVCPU_QS:XTR:XTR_GRP_CFG */
#define QS_XTR_GRP_CFG(r)         __REG(TARGET_QS, 0, 1, 0, 0, 1, 36, 0, r, 2, 4)

#define QS_XTR_GRP_CFG_MODE                      GENMASK(3, 2)
#define QS_XTR_GRP_CFG_MODE_SET(x)\
	FIELD_PREP(QS_XTR_GRP_CFG_MODE, x)
#define QS_XTR_GRP_CFG_MODE_GET(x)\
	FIELD_GET(QS_XTR_GRP_CFG_MODE, x)

#define QS_XTR_GRP_CFG_BYTE_SWAP                 BIT(0)
#define QS_XTR_GRP_CFG_BYTE_SWAP_SET(x)\
	FIELD_PREP(QS_XTR_GRP_CFG_BYTE_SWAP, x)
#define QS_XTR_GRP_CFG_BYTE_SWAP_GET(x)\
	FIELD_GET(QS_XTR_GRP_CFG_BYTE_SWAP, x)

/*      DEVCPU_QS:XTR:XTR_RD */
#define QS_XTR_RD(r)              __REG(TARGET_QS, 0, 1, 0, 0, 1, 36, 8, r, 2, 4)

/*      DEVCPU_QS:XTR:XTR_FLUSH */
#define QS_XTR_FLUSH              __REG(TARGET_QS, 0, 1, 0, 0, 1, 36, 24, 0, 1, 4)

/*      DEVCPU_QS:XTR:XTR_DATA_PRESENT */
#define QS_XTR_DATA_PRESENT       __REG(TARGET_QS, 0, 1, 0, 0, 1, 36, 28, 0, 1, 4)

/*      DEVCPU_QS:INJ:INJ_GRP_CFG */
#define QS_INJ_GRP_CFG(r)         __REG(TARGET_QS, 0, 1, 36, 0, 1, 40, 0, r, 2, 4)

#define QS_INJ_GRP_CFG_MODE                      GENMASK(3, 2)
#define QS_INJ_GRP_CFG_MODE_SET(x)\
	FIELD_PREP(QS_INJ_GRP_CFG_MODE, x)
#define QS_INJ_GRP_CFG_MODE_GET(x)\
	FIELD_GET(QS_INJ_GRP_CFG_MODE, x)

#define QS_INJ_GRP_CFG_BYTE_SWAP                 BIT(0)
#define QS_INJ_GRP_CFG_BYTE_SWAP_SET(x)\
	FIELD_PREP(QS_INJ_GRP_CFG_BYTE_SWAP, x)
#define QS_INJ_GRP_CFG_BYTE_SWAP_GET(x)\
	FIELD_GET(QS_INJ_GRP_CFG_BYTE_SWAP, x)

/*      DEVCPU_QS:INJ:INJ_WR */
#define QS_INJ_WR(r)              __REG(TARGET_QS, 0, 1, 36, 0, 1, 40, 8, r, 2, 4)

/*      DEVCPU_QS:INJ:INJ_CTRL */
#define QS_INJ_CTRL(r)            __REG(TARGET_QS, 0, 1, 36, 0, 1, 40, 16, r, 2, 4)

#define QS_INJ_CTRL_GAP_SIZE                     GENMASK(24, 21)
#define QS_INJ_CTRL_GAP_SIZE_SET(x)\
	FIELD_PREP(QS_INJ_CTRL_GAP_SIZE, x)
#define QS_INJ_CTRL_GAP_SIZE_GET(x)\
	FIELD_GET(QS_INJ_CTRL_GAP_SIZE, x)

#define QS_INJ_CTRL_EOF                          BIT(19)
#define QS_INJ_CTRL_EOF_SET(x)\
	FIELD_PREP(QS_INJ_CTRL_EOF, x)
#define QS_INJ_CTRL_EOF_GET(x)\
	FIELD_GET(QS_INJ_CTRL_EOF, x)

#define QS_INJ_CTRL_SOF                          BIT(18)
#define QS_INJ_CTRL_SOF_SET(x)\
	FIELD_PREP(QS_INJ_CTRL_SOF, x)
#define QS_INJ_CTRL_SOF_GET(x)\
	FIELD_GET(QS_INJ_CTRL_SOF, x)

#define QS_INJ_CTRL_VLD_BYTES                    GENMASK(17, 16)
#define QS_INJ_CTRL_VLD_BYTES_SET(x)\
	FIELD_PREP(QS_INJ_CTRL_VLD_BYTES, x)
#define QS_INJ_CTRL_VLD_BYTES_GET(x)\
	FIELD_GET(QS_INJ_CTRL_VLD_BYTES, x)

/*      DEVCPU_QS:INJ:INJ_STATUS */
#define QS_INJ_STATUS             __REG(TARGET_QS, 0, 1, 36, 0, 1, 40, 24, 0, 1, 4)

#define QS_INJ_STATUS_WMARK_REACHED              GENMASK(5, 4)
#define QS_INJ_STATUS_WMARK_REACHED_SET(x)\
	FIELD_PREP(QS_INJ_STATUS_WMARK_REACHED, x)
#define QS_INJ_STATUS_WMARK_REACHED_GET(x)\
	FIELD_GET(QS_INJ_STATUS_WMARK_REACHED, x)

#define QS_INJ_STATUS_FIFO_RDY                   GENMASK(3, 2)
#define QS_INJ_STATUS_FIFO_RDY_SET(x)\
	FIELD_PREP(QS_INJ_STATUS_FIFO_RDY, x)
#define QS_INJ_STATUS_FIFO_RDY_GET(x)\
	FIELD_GET(QS_INJ_STATUS_FIFO_RDY, x)

/*      QSYS:SYSTEM:PORT_MODE */
#define QSYS_PORT_MODE(r)         __REG(TARGET_QSYS, 0, 1, 28008, 0, 1, 216, 0, r, 10, 4)

#define QSYS_PORT_MODE_DEQUEUE_DIS               BIT(1)
#define QSYS_PORT_MODE_DEQUEUE_DIS_SET(x)\
	FIELD_PREP(QSYS_PORT_MODE_DEQUEUE_DIS, x)
#define QSYS_PORT_MODE_DEQUEUE_DIS_GET(x)\
	FIELD_GET(QSYS_PORT_MODE_DEQUEUE_DIS, x)

/*      QSYS:SYSTEM:SWITCH_PORT_MODE */
#define QSYS_SW_PORT_MODE(r)      __REG(TARGET_QSYS, 0, 1, 28008, 0, 1, 216, 80, r, 9, 4)

#define QSYS_SW_PORT_MODE_PORT_ENA               BIT(18)
#define QSYS_SW_PORT_MODE_PORT_ENA_SET(x)\
	FIELD_PREP(QSYS_SW_PORT_MODE_PORT_ENA, x)
#define QSYS_SW_PORT_MODE_PORT_ENA_GET(x)\
	FIELD_GET(QSYS_SW_PORT_MODE_PORT_ENA, x)

#define QSYS_SW_PORT_MODE_SCH_NEXT_CFG           GENMASK(16, 14)
#define QSYS_SW_PORT_MODE_SCH_NEXT_CFG_SET(x)\
	FIELD_PREP(QSYS_SW_PORT_MODE_SCH_NEXT_CFG, x)
#define QSYS_SW_PORT_MODE_SCH_NEXT_CFG_GET(x)\
	FIELD_GET(QSYS_SW_PORT_MODE_SCH_NEXT_CFG, x)

#define QSYS_SW_PORT_MODE_INGRESS_DROP_MODE      BIT(12)
#define QSYS_SW_PORT_MODE_INGRESS_DROP_MODE_SET(x)\
	FIELD_PREP(QSYS_SW_PORT_MODE_INGRESS_DROP_MODE, x)
#define QSYS_SW_PORT_MODE_INGRESS_DROP_MODE_GET(x)\
	FIELD_GET(QSYS_SW_PORT_MODE_INGRESS_DROP_MODE, x)

#define QSYS_SW_PORT_MODE_TX_PFC_ENA             GENMASK(11, 4)
#define QSYS_SW_PORT_MODE_TX_PFC_ENA_SET(x)\
	FIELD_PREP(QSYS_SW_PORT_MODE_TX_PFC_ENA, x)
#define QSYS_SW_PORT_MODE_TX_PFC_ENA_GET(x)\
	FIELD_GET(QSYS_SW_PORT_MODE_TX_PFC_ENA, x)

#define QSYS_SW_PORT_MODE_AGING_MODE             GENMASK(1, 0)
#define QSYS_SW_PORT_MODE_AGING_MODE_SET(x)\
	FIELD_PREP(QSYS_SW_PORT_MODE_AGING_MODE, x)
#define QSYS_SW_PORT_MODE_AGING_MODE_GET(x)\
	FIELD_GET(QSYS_SW_PORT_MODE_AGING_MODE, x)

/*      QSYS:SYSTEM:SW_STATUS */
#define QSYS_SW_STATUS(r)         __REG(TARGET_QSYS, 0, 1, 28008, 0, 1, 216, 164, r, 9, 4)

#define QSYS_SW_STATUS_EQ_AVAIL                  GENMASK(7, 0)
#define QSYS_SW_STATUS_EQ_AVAIL_SET(x)\
	FIELD_PREP(QSYS_SW_STATUS_EQ_AVAIL, x)
#define QSYS_SW_STATUS_EQ_AVAIL_GET(x)\
	FIELD_GET(QSYS_SW_STATUS_EQ_AVAIL, x)

/*      QSYS:SYSTEM:CPU_GROUP_MAP */
#define QSYS_CPU_GROUP_MAP        __REG(TARGET_QSYS, 0, 1, 28008, 0, 1, 216, 204, 0, 1, 4)

/*      QSYS:RES_CTRL:RES_CFG */
#define QSYS_RES_CFG(g)           __REG(TARGET_QSYS, 0, 1, 32768, g, 1024, 8, 0, 0, 1, 4)

/*      REW:PORT:PORT_VLAN_CFG */
#define REW_PORT_VLAN_CFG(g)      __REG(TARGET_REW, 0, 1, 0, g, 10, 128, 0, 0, 1, 4)

#define REW_PORT_VLAN_CFG_PORT_TPID              GENMASK(31, 16)
#define REW_PORT_VLAN_CFG_PORT_TPID_SET(x)\
	FIELD_PREP(REW_PORT_VLAN_CFG_PORT_TPID, x)
#define REW_PORT_VLAN_CFG_PORT_TPID_GET(x)\
	FIELD_GET(REW_PORT_VLAN_CFG_PORT_TPID, x)

#define REW_PORT_VLAN_CFG_PORT_VID               GENMASK(11, 0)
#define REW_PORT_VLAN_CFG_PORT_VID_SET(x)\
	FIELD_PREP(REW_PORT_VLAN_CFG_PORT_VID, x)
#define REW_PORT_VLAN_CFG_PORT_VID_GET(x)\
	FIELD_GET(REW_PORT_VLAN_CFG_PORT_VID, x)

/*      REW:PORT:TAG_CFG */
#define REW_TAG_CFG(g)            __REG(TARGET_REW, 0, 1, 0, g, 10, 128, 4, 0, 1, 4)

#define REW_TAG_CFG_TAG_CFG                      GENMASK(8, 7)
#define REW_TAG_CFG_TAG_CFG_SET(x)\
	FIELD_PREP(REW_TAG_CFG_TAG_CFG, x)
#define REW_TAG_CFG_TAG_CFG_GET(x)\
	FIELD_GET(REW_TAG_CFG_TAG_CFG, x)

#define REW_TAG_CFG_TAG_TPID_CFG                 GENMASK(6, 5)
#define REW_TAG_CFG_TAG_TPID_CFG_SET(x)\
	FIELD_PREP(REW_TAG_CFG_TAG_TPID_CFG, x)
#define REW_TAG_CFG_TAG_TPID_CFG_GET(x)\
	FIELD_GET(REW_TAG_CFG_TAG_TPID_CFG, x)

/*      REW:PORT:PORT_CFG */
#define REW_PORT_CFG(g)           __REG(TARGET_REW, 0, 1, 0, g, 10, 128, 8, 0, 1, 4)

#define REW_PORT_CFG_NO_REWRITE                  BIT(0)
#define REW_PORT_CFG_NO_REWRITE_SET(x)\
	FIELD_PREP(REW_PORT_CFG_NO_REWRITE, x)
#define REW_PORT_CFG_NO_REWRITE_GET(x)\
	FIELD_GET(REW_PORT_CFG_NO_REWRITE, x)

/*      SYS:SYSTEM:RESET_CFG */
#define SYS_RESET_CFG             __REG(TARGET_SYS, 0, 1, 4128, 0, 1, 168, 0, 0, 1, 4)

#define SYS_RESET_CFG_CORE_ENA                   BIT(0)
#define SYS_RESET_CFG_CORE_ENA_SET(x)\
	FIELD_PREP(SYS_RESET_CFG_CORE_ENA, x)
#define SYS_RESET_CFG_CORE_ENA_GET(x)\
	FIELD_GET(SYS_RESET_CFG_CORE_ENA, x)

/*      SYS:SYSTEM:PORT_MODE */
#define SYS_PORT_MODE(r)          __REG(TARGET_SYS, 0, 1, 4128, 0, 1, 168, 44, r, 10, 4)

#define SYS_PORT_MODE_INCL_INJ_HDR               GENMASK(5, 4)
#define SYS_PORT_MODE_INCL_INJ_HDR_SET(x)\
	FIELD_PREP(SYS_PORT_MODE_INCL_INJ_HDR, x)
#define SYS_PORT_MODE_INCL_INJ_HDR_GET(x)\
	FIELD_GET(SYS_PORT_MODE_INCL_INJ_HDR, x)

#define SYS_PORT_MODE_INCL_XTR_HDR               GENMASK(3, 2)
#define SYS_PORT_MODE_INCL_XTR_HDR_SET(x)\
	FIELD_PREP(SYS_PORT_MODE_INCL_XTR_HDR, x)
#define SYS_PORT_MODE_INCL_XTR_HDR_GET(x)\
	FIELD_GET(SYS_PORT_MODE_INCL_XTR_HDR, x)

/*      SYS:SYSTEM:FRONT_PORT_MODE */
#define SYS_FRONT_PORT_MODE(r)    __REG(TARGET_SYS, 0, 1, 4128, 0, 1, 168, 84, r, 8, 4)

#define SYS_FRONT_PORT_MODE_HDX_MODE             BIT(1)
#define SYS_FRONT_PORT_MODE_HDX_MODE_SET(x)\
	FIELD_PREP(SYS_FRONT_PORT_MODE_HDX_MODE, x)
#define SYS_FRONT_PORT_MODE_HDX_MODE_GET(x)\
	FIELD_GET(SYS_FRONT_PORT_MODE_HDX_MODE, x)

/*      SYS:SYSTEM:FRM_AGING */
#define SYS_FRM_AGING             __REG(TARGET_SYS, 0, 1, 4128, 0, 1, 168, 116, 0, 1, 4)

#define SYS_FRM_AGING_AGE_TX_ENA                 BIT(20)
#define SYS_FRM_AGING_AGE_TX_ENA_SET(x)\
	FIELD_PREP(SYS_FRM_AGING_AGE_TX_ENA, x)
#define SYS_FRM_AGING_AGE_TX_ENA_GET(x)\
	FIELD_GET(SYS_FRM_AGING_AGE_TX_ENA, x)

/*      SYS:SYSTEM:STAT_CFG */
#define SYS_STAT_CFG              __REG(TARGET_SYS, 0, 1, 4128, 0, 1, 168, 120, 0, 1, 4)

#define SYS_STAT_CFG_STAT_VIEW                   GENMASK(9, 0)
#define SYS_STAT_CFG_STAT_VIEW_SET(x)\
	FIELD_PREP(SYS_STAT_CFG_STAT_VIEW, x)
#define SYS_STAT_CFG_STAT_VIEW_GET(x)\
	FIELD_GET(SYS_STAT_CFG_STAT_VIEW, x)

/*      SYS:PAUSE_CFG:PAUSE_CFG */
#define SYS_PAUSE_CFG(r)          __REG(TARGET_SYS, 0, 1, 4296, 0, 1, 112, 0, r, 9, 4)

#define SYS_PAUSE_CFG_PAUSE_START                GENMASK(18, 10)
#define SYS_PAUSE_CFG_PAUSE_START_SET(x)\
	FIELD_PREP(SYS_PAUSE_CFG_PAUSE_START, x)
#define SYS_PAUSE_CFG_PAUSE_START_GET(x)\
	FIELD_GET(SYS_PAUSE_CFG_PAUSE_START, x)

#define SYS_PAUSE_CFG_PAUSE_STOP                 GENMASK(9, 1)
#define SYS_PAUSE_CFG_PAUSE_STOP_SET(x)\
	FIELD_PREP(SYS_PAUSE_CFG_PAUSE_STOP, x)
#define SYS_PAUSE_CFG_PAUSE_STOP_GET(x)\
	FIELD_GET(SYS_PAUSE_CFG_PAUSE_STOP, x)

#define SYS_PAUSE_CFG_PAUSE_ENA                  BIT(0)
#define SYS_PAUSE_CFG_PAUSE_ENA_SET(x)\
	FIELD_PREP(SYS_PAUSE_CFG_PAUSE_ENA, x)
#define SYS_PAUSE_CFG_PAUSE_ENA_GET(x)\
	FIELD_GET(SYS_PAUSE_CFG_PAUSE_ENA, x)

/*      SYS:PAUSE_CFG:ATOP */
#define SYS_ATOP(r)               __REG(TARGET_SYS, 0, 1, 4296, 0, 1, 112, 40, r, 9, 4)

/*      SYS:PAUSE_CFG:ATOP_TOT_CFG */
#define SYS_ATOP_TOT_CFG          __REG(TARGET_SYS, 0, 1, 4296, 0, 1, 112, 76, 0, 1, 4)

/*      SYS:PAUSE_CFG:MAC_FC_CFG */
#define SYS_MAC_FC_CFG(r)         __REG(TARGET_SYS, 0, 1, 4296, 0, 1, 112, 80, r, 8, 4)

#define SYS_MAC_FC_CFG_FC_LINK_SPEED             GENMASK(27, 26)
#define SYS_MAC_FC_CFG_FC_LINK_SPEED_SET(x)\
	FIELD_PREP(SYS_MAC_FC_CFG_FC_LINK_SPEED, x)
#define SYS_MAC_FC_CFG_FC_LINK_SPEED_GET(x)\
	FIELD_GET(SYS_MAC_FC_CFG_FC_LINK_SPEED, x)

#define SYS_MAC_FC_CFG_FC_LATENCY_CFG            GENMASK(25, 20)
#define SYS_MAC_FC_CFG_FC_LATENCY_CFG_SET(x)\
	FIELD_PREP(SYS_MAC_FC_CFG_FC_LATENCY_CFG, x)
#define SYS_MAC_FC_CFG_FC_LATENCY_CFG_GET(x)\
	FIELD_GET(SYS_MAC_FC_CFG_FC_LATENCY_CFG, x)

#define SYS_MAC_FC_CFG_ZERO_PAUSE_ENA            BIT(18)
#define SYS_MAC_FC_CFG_ZERO_PAUSE_ENA_SET(x)\
	FIELD_PREP(SYS_MAC_FC_CFG_ZERO_PAUSE_ENA, x)
#define SYS_MAC_FC_CFG_ZERO_PAUSE_ENA_GET(x)\
	FIELD_GET(SYS_MAC_FC_CFG_ZERO_PAUSE_ENA, x)

#define SYS_MAC_FC_CFG_TX_FC_ENA                 BIT(17)
#define SYS_MAC_FC_CFG_TX_FC_ENA_SET(x)\
	FIELD_PREP(SYS_MAC_FC_CFG_TX_FC_ENA, x)
#define SYS_MAC_FC_CFG_TX_FC_ENA_GET(x)\
	FIELD_GET(SYS_MAC_FC_CFG_TX_FC_ENA, x)

#define SYS_MAC_FC_CFG_RX_FC_ENA                 BIT(16)
#define SYS_MAC_FC_CFG_RX_FC_ENA_SET(x)\
	FIELD_PREP(SYS_MAC_FC_CFG_RX_FC_ENA, x)
#define SYS_MAC_FC_CFG_RX_FC_ENA_GET(x)\
	FIELD_GET(SYS_MAC_FC_CFG_RX_FC_ENA, x)

#define SYS_MAC_FC_CFG_PAUSE_VAL_CFG             GENMASK(15, 0)
#define SYS_MAC_FC_CFG_PAUSE_VAL_CFG_SET(x)\
	FIELD_PREP(SYS_MAC_FC_CFG_PAUSE_VAL_CFG, x)
#define SYS_MAC_FC_CFG_PAUSE_VAL_CFG_GET(x)\
	FIELD_GET(SYS_MAC_FC_CFG_PAUSE_VAL_CFG, x)

/*      SYS:STAT:CNT */
#define SYS_CNT(g)                __REG(TARGET_SYS, 0, 1, 0, g, 896, 4, 0, 0, 1, 4)

/*      SYS:RAM_CTRL:RAM_INIT */
#define SYS_RAM_INIT              __REG(TARGET_SYS, 0, 1, 4432, 0, 1, 4, 0, 0, 1, 4)

#define SYS_RAM_INIT_RAM_INIT                    BIT(1)
#define SYS_RAM_INIT_RAM_INIT_SET(x)\
	FIELD_PREP(SYS_RAM_INIT_RAM_INIT, x)
#define SYS_RAM_INIT_RAM_INIT_GET(x)\
	FIELD_GET(SYS_RAM_INIT_RAM_INIT, x)

#endif /* _LAN966X_REGS_H_ */
